/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models.model;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class TextureMapping {
    private final Map<TextureSlot, ResourceLocation> slots = Maps.newHashMap();
    private final Set<TextureSlot> forcedSlots = Sets.newHashSet();

    public TextureMapping put(TextureSlot pTextureSlot, ResourceLocation pTextureLocation) {
        this.slots.put(pTextureSlot, pTextureLocation);
        return this;
    }

    public TextureMapping putForced(TextureSlot pTextureSlot, ResourceLocation pTextureLocation) {
        this.slots.put(pTextureSlot, pTextureLocation);
        this.forcedSlots.add(pTextureSlot);
        return this;
    }

    public Stream<TextureSlot> getForced() {
        return this.forcedSlots.stream();
    }

    public TextureMapping copySlot(TextureSlot pSourceSlot, TextureSlot pTargetSlot) {
        this.slots.put(pTargetSlot, this.slots.get(pSourceSlot));
        return this;
    }

    public TextureMapping copyForced(TextureSlot pSourceSlot, TextureSlot pTargetSlot) {
        this.slots.put(pTargetSlot, this.slots.get(pSourceSlot));
        this.forcedSlots.add(pTargetSlot);
        return this;
    }

    public ResourceLocation get(TextureSlot pTextureSlot) {
        TextureSlot textureslot = pTextureSlot;
        while (textureslot != null) {
            ResourceLocation resourcelocation = this.slots.get(textureslot);
            if (resourcelocation != null) {
                return resourcelocation;
            }
            textureslot = textureslot.getParent();
        }
        throw new IllegalStateException("Can't find texture for slot " + pTextureSlot);
    }

    public TextureMapping copyAndUpdate(TextureSlot pTextureSlot, ResourceLocation pTextureLocation) {
        TextureMapping texturemapping = new TextureMapping();
        texturemapping.slots.putAll(this.slots);
        texturemapping.forcedSlots.addAll(this.forcedSlots);
        texturemapping.put(pTextureSlot, pTextureLocation);
        return texturemapping;
    }

    public static TextureMapping cube(Block pAllTextureLocation) {
        ResourceLocation resourcelocation = TextureMapping.getBlockTexture(pAllTextureLocation);
        return TextureMapping.cube(resourcelocation);
    }

    public static TextureMapping defaultTexture(Block pTextureLocation) {
        ResourceLocation resourcelocation = TextureMapping.getBlockTexture(pTextureLocation);
        return TextureMapping.defaultTexture(resourcelocation);
    }

    public static TextureMapping defaultTexture(ResourceLocation pTextureLocation) {
        return new TextureMapping().put(TextureSlot.TEXTURE, pTextureLocation);
    }

    public static TextureMapping cube(ResourceLocation pAllTextureLocation) {
        return new TextureMapping().put(TextureSlot.ALL, pAllTextureLocation);
    }

    public static TextureMapping cross(Block pCrossTextureLocation) {
        return TextureMapping.singleSlot(TextureSlot.CROSS, TextureMapping.getBlockTexture(pCrossTextureLocation));
    }

    public static TextureMapping cross(ResourceLocation pCrossTextureLocation) {
        return TextureMapping.singleSlot(TextureSlot.CROSS, pCrossTextureLocation);
    }

    public static TextureMapping plant(Block pPlantTextureLocation) {
        return TextureMapping.singleSlot(TextureSlot.PLANT, TextureMapping.getBlockTexture(pPlantTextureLocation));
    }

    public static TextureMapping plant(ResourceLocation pPlantTextureLocation) {
        return TextureMapping.singleSlot(TextureSlot.PLANT, pPlantTextureLocation);
    }

    public static TextureMapping rail(Block pRailTextureLocation) {
        return TextureMapping.singleSlot(TextureSlot.RAIL, TextureMapping.getBlockTexture(pRailTextureLocation));
    }

    public static TextureMapping rail(ResourceLocation pRailTextureLocation) {
        return TextureMapping.singleSlot(TextureSlot.RAIL, pRailTextureLocation);
    }

    public static TextureMapping wool(Block pWoolTextureLocation) {
        return TextureMapping.singleSlot(TextureSlot.WOOL, TextureMapping.getBlockTexture(pWoolTextureLocation));
    }

    public static TextureMapping wool(ResourceLocation pWoolTextureLocation) {
        return TextureMapping.singleSlot(TextureSlot.WOOL, pWoolTextureLocation);
    }

    public static TextureMapping stem(Block pStemBlock) {
        return TextureMapping.singleSlot(TextureSlot.STEM, TextureMapping.getBlockTexture(pStemBlock));
    }

    public static TextureMapping attachedStem(Block pUnattachedStemBlock, Block pAttachedStemBlock) {
        return new TextureMapping().put(TextureSlot.STEM, TextureMapping.getBlockTexture(pUnattachedStemBlock)).put(TextureSlot.UPPER_STEM, TextureMapping.getBlockTexture(pAttachedStemBlock));
    }

    public static TextureMapping pattern(Block pPatternBlock) {
        return TextureMapping.singleSlot(TextureSlot.PATTERN, TextureMapping.getBlockTexture(pPatternBlock));
    }

    public static TextureMapping fan(Block pFanBlock) {
        return TextureMapping.singleSlot(TextureSlot.FAN, TextureMapping.getBlockTexture(pFanBlock));
    }

    public static TextureMapping crop(ResourceLocation pCropTextureLocation) {
        return TextureMapping.singleSlot(TextureSlot.CROP, pCropTextureLocation);
    }

    public static TextureMapping pane(Block pGlassBlock, Block pPaneBlock) {
        return new TextureMapping().put(TextureSlot.PANE, TextureMapping.getBlockTexture(pGlassBlock)).put(TextureSlot.EDGE, TextureMapping.getBlockTexture(pPaneBlock, "_top"));
    }

    public static TextureMapping singleSlot(TextureSlot pTextureSlot, ResourceLocation pTextureLocation) {
        return new TextureMapping().put(pTextureSlot, pTextureLocation);
    }

    public static TextureMapping column(Block pColumnBlock) {
        return new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture(pColumnBlock, "_side")).put(TextureSlot.END, TextureMapping.getBlockTexture(pColumnBlock, "_top"));
    }

    public static TextureMapping cubeTop(Block pBlock) {
        return new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture(pBlock, "_side")).put(TextureSlot.TOP, TextureMapping.getBlockTexture(pBlock, "_top"));
    }

    public static TextureMapping logColumn(Block pLogBlock) {
        return new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture(pLogBlock)).put(TextureSlot.END, TextureMapping.getBlockTexture(pLogBlock, "_top"));
    }

    public static TextureMapping column(ResourceLocation pSideTextureLocation, ResourceLocation pEndTextureLocation) {
        return new TextureMapping().put(TextureSlot.SIDE, pSideTextureLocation).put(TextureSlot.END, pEndTextureLocation);
    }

    public static TextureMapping cubeBottomTop(Block pBlock) {
        return new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture(pBlock, "_side")).put(TextureSlot.TOP, TextureMapping.getBlockTexture(pBlock, "_top")).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture(pBlock, "_bottom"));
    }

    public static TextureMapping cubeBottomTopWithWall(Block pBlock) {
        ResourceLocation resourcelocation = TextureMapping.getBlockTexture(pBlock);
        return new TextureMapping().put(TextureSlot.WALL, resourcelocation).put(TextureSlot.SIDE, resourcelocation).put(TextureSlot.TOP, TextureMapping.getBlockTexture(pBlock, "_top")).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture(pBlock, "_bottom"));
    }

    public static TextureMapping columnWithWall(Block pColumnBlock) {
        ResourceLocation resourcelocation = TextureMapping.getBlockTexture(pColumnBlock);
        return new TextureMapping().put(TextureSlot.WALL, resourcelocation).put(TextureSlot.SIDE, resourcelocation).put(TextureSlot.END, TextureMapping.getBlockTexture(pColumnBlock, "_top"));
    }

    public static TextureMapping door(ResourceLocation pTopTextureLocation, ResourceLocation pBottomTextureLocation) {
        return new TextureMapping().put(TextureSlot.TOP, pTopTextureLocation).put(TextureSlot.BOTTOM, pBottomTextureLocation);
    }

    public static TextureMapping door(Block pDoorBlock) {
        return new TextureMapping().put(TextureSlot.TOP, TextureMapping.getBlockTexture(pDoorBlock, "_top")).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture(pDoorBlock, "_bottom"));
    }

    public static TextureMapping particle(Block pTextureLocation) {
        return new TextureMapping().put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture(pTextureLocation));
    }

    public static TextureMapping particle(ResourceLocation pTextureLocation) {
        return new TextureMapping().put(TextureSlot.PARTICLE, pTextureLocation);
    }

    public static TextureMapping fire0(Block pFireBlock) {
        return new TextureMapping().put(TextureSlot.FIRE, TextureMapping.getBlockTexture(pFireBlock, "_0"));
    }

    public static TextureMapping fire1(Block pFireBlock) {
        return new TextureMapping().put(TextureSlot.FIRE, TextureMapping.getBlockTexture(pFireBlock, "_1"));
    }

    public static TextureMapping lantern(Block pLanternBlock) {
        return new TextureMapping().put(TextureSlot.LANTERN, TextureMapping.getBlockTexture(pLanternBlock));
    }

    public static TextureMapping torch(Block pTorchTextureLocation) {
        return new TextureMapping().put(TextureSlot.TORCH, TextureMapping.getBlockTexture(pTorchTextureLocation));
    }

    public static TextureMapping torch(ResourceLocation pTorchTextureLocation) {
        return new TextureMapping().put(TextureSlot.TORCH, pTorchTextureLocation);
    }

    public static TextureMapping particleFromItem(Item pParticleItem) {
        return new TextureMapping().put(TextureSlot.PARTICLE, TextureMapping.getItemTexture(pParticleItem));
    }

    public static TextureMapping commandBlock(Block pCommandBlock) {
        return new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture(pCommandBlock, "_side")).put(TextureSlot.FRONT, TextureMapping.getBlockTexture(pCommandBlock, "_front")).put(TextureSlot.BACK, TextureMapping.getBlockTexture(pCommandBlock, "_back"));
    }

    public static TextureMapping orientableCube(Block pBlock) {
        return new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture(pBlock, "_side")).put(TextureSlot.FRONT, TextureMapping.getBlockTexture(pBlock, "_front")).put(TextureSlot.TOP, TextureMapping.getBlockTexture(pBlock, "_top")).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture(pBlock, "_bottom"));
    }

    public static TextureMapping orientableCubeOnlyTop(Block pBlock) {
        return new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture(pBlock, "_side")).put(TextureSlot.FRONT, TextureMapping.getBlockTexture(pBlock, "_front")).put(TextureSlot.TOP, TextureMapping.getBlockTexture(pBlock, "_top"));
    }

    public static TextureMapping orientableCubeSameEnds(Block pBlock) {
        return new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture(pBlock, "_side")).put(TextureSlot.FRONT, TextureMapping.getBlockTexture(pBlock, "_front")).put(TextureSlot.END, TextureMapping.getBlockTexture(pBlock, "_end"));
    }

    public static TextureMapping top(Block pBlock) {
        return new TextureMapping().put(TextureSlot.TOP, TextureMapping.getBlockTexture(pBlock, "_top"));
    }

    public static TextureMapping craftingTable(Block pCraftingTableBlock, Block pCraftingTableMaterialBlock) {
        return new TextureMapping().put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture(pCraftingTableBlock, "_front")).put(TextureSlot.DOWN, TextureMapping.getBlockTexture(pCraftingTableMaterialBlock)).put(TextureSlot.UP, TextureMapping.getBlockTexture(pCraftingTableBlock, "_top")).put(TextureSlot.NORTH, TextureMapping.getBlockTexture(pCraftingTableBlock, "_front")).put(TextureSlot.EAST, TextureMapping.getBlockTexture(pCraftingTableBlock, "_side")).put(TextureSlot.SOUTH, TextureMapping.getBlockTexture(pCraftingTableBlock, "_side")).put(TextureSlot.WEST, TextureMapping.getBlockTexture(pCraftingTableBlock, "_front"));
    }

    public static TextureMapping fletchingTable(Block pFletchingTableBlock, Block pFletchingTableMaterialBlock) {
        return new TextureMapping().put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture(pFletchingTableBlock, "_front")).put(TextureSlot.DOWN, TextureMapping.getBlockTexture(pFletchingTableMaterialBlock)).put(TextureSlot.UP, TextureMapping.getBlockTexture(pFletchingTableBlock, "_top")).put(TextureSlot.NORTH, TextureMapping.getBlockTexture(pFletchingTableBlock, "_front")).put(TextureSlot.SOUTH, TextureMapping.getBlockTexture(pFletchingTableBlock, "_front")).put(TextureSlot.EAST, TextureMapping.getBlockTexture(pFletchingTableBlock, "_side")).put(TextureSlot.WEST, TextureMapping.getBlockTexture(pFletchingTableBlock, "_side"));
    }

    public static TextureMapping campfire(Block pCampfireBlock) {
        return new TextureMapping().put(TextureSlot.LIT_LOG, TextureMapping.getBlockTexture(pCampfireBlock, "_log_lit")).put(TextureSlot.FIRE, TextureMapping.getBlockTexture(pCampfireBlock, "_fire"));
    }

    public static TextureMapping candleCake(Block pCandleCakeBlock, boolean pLit) {
        return new TextureMapping().put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture(Blocks.CAKE, "_side")).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture(Blocks.CAKE, "_bottom")).put(TextureSlot.TOP, TextureMapping.getBlockTexture(Blocks.CAKE, "_top")).put(TextureSlot.SIDE, TextureMapping.getBlockTexture(Blocks.CAKE, "_side")).put(TextureSlot.CANDLE, TextureMapping.getBlockTexture(pCandleCakeBlock, pLit ? "_lit" : ""));
    }

    public static TextureMapping cauldron(ResourceLocation pCauldronContentTextureLocation) {
        return new TextureMapping().put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture(Blocks.CAULDRON, "_side")).put(TextureSlot.SIDE, TextureMapping.getBlockTexture(Blocks.CAULDRON, "_side")).put(TextureSlot.TOP, TextureMapping.getBlockTexture(Blocks.CAULDRON, "_top")).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture(Blocks.CAULDRON, "_bottom")).put(TextureSlot.INSIDE, TextureMapping.getBlockTexture(Blocks.CAULDRON, "_inner")).put(TextureSlot.CONTENT, pCauldronContentTextureLocation);
    }

    public static TextureMapping layer0(Item pLayerZeroTextureLocation) {
        return new TextureMapping().put(TextureSlot.LAYER0, TextureMapping.getItemTexture(pLayerZeroTextureLocation));
    }

    public static TextureMapping layer0(Block pLayerZeroTextureLocation) {
        return new TextureMapping().put(TextureSlot.LAYER0, TextureMapping.getBlockTexture(pLayerZeroTextureLocation));
    }

    public static TextureMapping layer0(ResourceLocation pLayerZeroTextureLocation) {
        return new TextureMapping().put(TextureSlot.LAYER0, pLayerZeroTextureLocation);
    }

    public static ResourceLocation getBlockTexture(Block pBlock) {
        ResourceLocation resourcelocation = Registry.BLOCK.getKey(pBlock);
        return new ResourceLocation(resourcelocation.getNamespace(), "block/" + resourcelocation.getPath());
    }

    public static ResourceLocation getBlockTexture(Block pBlock, String pTextureSuffix) {
        ResourceLocation resourcelocation = Registry.BLOCK.getKey(pBlock);
        return new ResourceLocation(resourcelocation.getNamespace(), "block/" + resourcelocation.getPath() + pTextureSuffix);
    }

    public static ResourceLocation getItemTexture(Item pItem) {
        ResourceLocation resourcelocation = Registry.ITEM.getKey(pItem);
        return new ResourceLocation(resourcelocation.getNamespace(), "item/" + resourcelocation.getPath());
    }

    public static ResourceLocation getItemTexture(Item pItem, String pTextureSuffix) {
        ResourceLocation resourcelocation = Registry.ITEM.getKey(pItem);
        return new ResourceLocation(resourcelocation.getNamespace(), "item/" + resourcelocation.getPath() + pTextureSuffix);
    }
}

