/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public interface RecipeBuilder {
    public RecipeBuilder unlockedBy(String var1, CriterionTriggerInstance var2);

    public RecipeBuilder group(@Nullable String var1);

    public Item getResult();

    public void save(Consumer<FinishedRecipe> var1, ResourceLocation var2);

    default public void save(Consumer<FinishedRecipe> pFinishedRecipeConsumer) {
        this.save(pFinishedRecipeConsumer, RecipeBuilder.getDefaultRecipeId(this.getResult()));
    }

    default public void save(Consumer<FinishedRecipe> pFinishedRecipeConsumer, String pRecipeId) {
        ResourceLocation resourcelocation1 = new ResourceLocation(pRecipeId);
        ResourceLocation resourcelocation = RecipeBuilder.getDefaultRecipeId(this.getResult());
        if (resourcelocation1.equals(resourcelocation)) {
            throw new IllegalStateException("Recipe " + pRecipeId + " should remove its 'save' argument as it is equal to default one");
        }
        this.save(pFinishedRecipeConsumer, resourcelocation1);
    }

    public static ResourceLocation getDefaultRecipeId(ItemLike pItemLike) {
        return Registry.ITEM.getKey(pItemLike.asItem());
    }
}

