/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import com.mojang.logging.LogUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import org.slf4j.Logger;

public class NbtToSnbt
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final DataGenerator generator;

    public NbtToSnbt(DataGenerator pGenerator) {
        this.generator = pGenerator;
    }

    @Override
    public void run(HashCache pCache) throws IOException {
        Path path = this.generator.getOutputFolder();
        for (Path path1 : this.generator.getInputFolders()) {
            Files.walk(path1, new FileVisitOption[0]).filter(p_126430_ -> p_126430_.toString().endsWith(".nbt")).forEach(p_126441_ -> NbtToSnbt.convertStructure(p_126441_, this.getName(path1, (Path)p_126441_), path));
        }
    }

    @Override
    public String getName() {
        return "NBT to SNBT";
    }

    private String getName(Path pInputFolder, Path pFile) {
        String s = pInputFolder.relativize(pFile).toString().replaceAll("\\\\", "/");
        return s.substring(0, s.length() - ".nbt".length());
    }

    @Nullable
    public static Path convertStructure(Path pSnbtPath, String pName, Path pNbtPath) {
        try {
            NbtToSnbt.writeSnbt(pNbtPath.resolve(String.valueOf(pName) + ".snbt"), NbtUtils.structureToSnbt(NbtIo.readCompressed(Files.newInputStream(pSnbtPath, new OpenOption[0]))));
            LOGGER.info("Converted {} from NBT to SNBT", (Object)pName);
            return pNbtPath.resolve(String.valueOf(pName) + ".snbt");
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't convert {} from NBT to SNBT at {}", new Object[]{pName, pSnbtPath, ioexception});
            return null;
        }
    }

    public static void writeSnbt(Path pPath, String pContents) throws IOException {
        Files.createDirectories(pPath.getParent(), new FileAttribute[0]);
        try (BufferedWriter bufferedwriter = Files.newBufferedWriter(pPath, new OpenOption[0]);){
            bufferedwriter.write(pContents);
            bufferedwriter.write(10);
        }
    }
}

