/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.structures.NbtToSnbt;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class SnbtToNbt
implements DataProvider {
    @Nullable
    private static final Path DUMP_SNBT_TO = null;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final DataGenerator generator;
    private final List<Filter> filters = Lists.newArrayList();

    public SnbtToNbt(DataGenerator pGenerator) {
        this.generator = pGenerator;
    }

    public SnbtToNbt addFilter(Filter pFilter) {
        this.filters.add(pFilter);
        return this;
    }

    private CompoundTag applyFilters(String pFileName, CompoundTag pTag) {
        CompoundTag compoundtag = pTag;
        for (Filter snbttonbt$filter : this.filters) {
            compoundtag = snbttonbt$filter.apply(pFileName, compoundtag);
        }
        return compoundtag;
    }

    @Override
    public void run(HashCache pCache) throws IOException {
        Path path = this.generator.getOutputFolder();
        ArrayList list = Lists.newArrayList();
        for (Path path1 : this.generator.getInputFolders()) {
            Files.walk(path1, new FileVisitOption[0]).filter(p_126464_ -> p_126464_.toString().endsWith(".snbt")).forEach(p_126474_ -> list.add(CompletableFuture.supplyAsync(() -> this.readStructure((Path)p_126474_, this.getName(path1, (Path)p_126474_)), Util.backgroundExecutor())));
        }
        boolean flag = false;
        for (CompletableFuture completablefuture : list) {
            try {
                this.storeStructureIfChanged(pCache, (TaskResult)completablefuture.get(), path);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to process structure", (Throwable)exception);
                flag = true;
            }
        }
        if (flag) {
            throw new IllegalStateException("Failed to convert all structures, aborting");
        }
    }

    @Override
    public String getName() {
        return "SNBT -> NBT";
    }

    private String getName(Path pInputFolder, Path pFile) {
        String s = pInputFolder.relativize(pFile).toString().replaceAll("\\\\", "/");
        return s.substring(0, s.length() - ".snbt".length());
    }

    private TaskResult readStructure(Path pFilePath, String pFileName) {
        try {
            TaskResult snbttonbt$taskresult;
            try (BufferedReader bufferedreader = Files.newBufferedReader(pFilePath);){
                String s = IOUtils.toString((Reader)bufferedreader);
                CompoundTag compoundtag = this.applyFilters(pFileName, NbtUtils.snbtToStructure(s));
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                NbtIo.writeCompressed(compoundtag, bytearrayoutputstream);
                byte[] abyte = bytearrayoutputstream.toByteArray();
                String s1 = SHA1.hashBytes(abyte).toString();
                String s2 = DUMP_SNBT_TO != null ? NbtUtils.structureToSnbt(compoundtag) : null;
                snbttonbt$taskresult = new TaskResult(pFileName, abyte, s2, s1);
            }
            return snbttonbt$taskresult;
        }
        catch (Throwable throwable2) {
            throw new StructureConversionException(pFilePath, throwable2);
        }
    }

    private void storeStructureIfChanged(HashCache pCache, TaskResult pTaskResult, Path pDirectoryPath) {
        if (pTaskResult.snbtPayload != null) {
            Path path = DUMP_SNBT_TO.resolve(String.valueOf(pTaskResult.name) + ".snbt");
            try {
                NbtToSnbt.writeSnbt(path, pTaskResult.snbtPayload);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't write structure SNBT {} at {}", new Object[]{pTaskResult.name, path, ioexception});
            }
        }
        Path path1 = pDirectoryPath.resolve(String.valueOf(pTaskResult.name) + ".nbt");
        try {
            if (!Objects.equals(pCache.getHash(path1), pTaskResult.hash) || !Files.exists(path1, new LinkOption[0])) {
                Files.createDirectories(path1.getParent(), new FileAttribute[0]);
                try (OutputStream outputstream = Files.newOutputStream(path1, new OpenOption[0]);){
                    outputstream.write(pTaskResult.payload);
                }
            }
            pCache.putNew(path1, pTaskResult.hash);
        }
        catch (IOException ioexception1) {
            LOGGER.error("Couldn't write structure {} at {}", new Object[]{pTaskResult.name, path1, ioexception1});
        }
    }

    @FunctionalInterface
    public static interface Filter {
        public CompoundTag apply(String var1, CompoundTag var2);
    }

    static class StructureConversionException
    extends RuntimeException {
        public StructureConversionException(Path pPath, Throwable pCause) {
            super(pPath.toAbsolutePath().toString(), pCause);
        }
    }

    static class TaskResult {
        final String name;
        final byte[] payload;
        @Nullable
        final String snbtPayload;
        final String hash;

        public TaskResult(String pName, byte[] pPayload, @Nullable String pSnbtPayload, String pHash) {
            this.name = pName;
            this.payload = pPayload;
            this.snbtPayload = pSnbtPayload;
            this.hash = pHash;
        }
    }
}

