/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.tags;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import org.slf4j.Logger;

public abstract class TagsProvider<T>
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator generator;
    protected final Registry<T> registry;
    private final Map<ResourceLocation, Tag.Builder> builders = Maps.newLinkedHashMap();

    protected TagsProvider(DataGenerator pGenerator, Registry<T> pRegistry) {
        this.generator = pGenerator;
        this.registry = pRegistry;
    }

    protected abstract void addTags();

    @Override
    public void run(HashCache pCache) {
        this.builders.clear();
        this.addTags();
        this.builders.forEach((p_176835_, p_176836_) -> {
            List<Tag.BuilderEntry> list = p_176836_.getEntries().filter(p_176832_ -> !p_176832_.entry().verifyIfPresent(this.registry::containsKey, this.builders::containsKey)).toList();
            if (!list.isEmpty()) {
                throw new IllegalArgumentException(String.format("Couldn't define tag %s as it is missing following references: %s", p_176835_, list.stream().map(Objects::toString).collect(Collectors.joining(","))));
            }
            JsonObject jsonobject = p_176836_.serializeToJson();
            Path path = this.getPath((ResourceLocation)p_176835_);
            try {
                String s = GSON.toJson((JsonElement)jsonobject);
                String s1 = SHA1.hashUnencodedChars((CharSequence)s).toString();
                if (!Objects.equals(pCache.getHash(path), s1) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                        bufferedwriter.write(s);
                    }
                }
                pCache.putNew(path, s1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save tags to {}", (Object)path, (Object)ioexception);
            }
        });
    }

    private Path getPath(ResourceLocation pId) {
        ResourceKey<Registry<T>> resourcekey = this.registry.key();
        return this.generator.getOutputFolder().resolve("data/" + pId.getNamespace() + "/" + TagManager.getTagDir(resourcekey) + "/" + pId.getPath() + ".json");
    }

    protected TagAppender<T> tag(TagKey<T> pTag) {
        Tag.Builder tag$builder = this.getOrCreateRawBuilder(pTag);
        return new TagAppender<T>(tag$builder, this.registry, "vanilla");
    }

    protected Tag.Builder getOrCreateRawBuilder(TagKey<T> pTag) {
        return this.builders.computeIfAbsent(pTag.location(), p_176838_ -> new Tag.Builder());
    }

    protected static class TagAppender<T> {
        private final Tag.Builder builder;
        private final Registry<T> registry;
        private final String source;

        TagAppender(Tag.Builder pBuilder, Registry<T> pRegistry, String pSource) {
            this.builder = pBuilder;
            this.registry = pRegistry;
            this.source = pSource;
        }

        public TagAppender<T> add(T pItem) {
            this.builder.addElement(this.registry.getKey(pItem), this.source);
            return this;
        }

        @SafeVarargs
        public final TagAppender<T> a(ResourceKey<T> ... p_211102_) {
            ResourceKey<T>[] resourceKeyArray = p_211102_;
            int n = p_211102_.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceKey<T> resourcekey = resourceKeyArray[n2];
                this.builder.addElement(resourcekey.location(), this.source);
                ++n2;
            }
            return this;
        }

        public TagAppender<T> addOptional(ResourceLocation pLocation) {
            this.builder.addOptionalElement(pLocation, this.source);
            return this;
        }

        public TagAppender<T> addTag(TagKey<T> pTag) {
            this.builder.addTag(pTag.location(), this.source);
            return this;
        }

        public TagAppender<T> addOptionalTag(ResourceLocation pLocation) {
            this.builder.addOptionalTag(pLocation, this.source);
            return this;
        }

        @SafeVarargs
        public final TagAppender<T> a(T ... p_126585_) {
            Stream.of(p_126585_).map(this.registry::getKey).forEach(p_126587_ -> this.builder.addElement((ResourceLocation)p_126587_, this.source));
            return this;
        }
    }
}

