/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen.features;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.TreePlacements;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.BiasedToBottomInt;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomBooleanFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.DualNoiseProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseThresholdProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.material.Fluids;

public class VegetationFeatures {
    public static final Holder<ConfiguredFeature<ProbabilityFeatureConfiguration, ?>> BAMBOO_NO_PODZOL = FeatureUtils.register("bamboo_no_podzol", Feature.BAMBOO, new ProbabilityFeatureConfiguration(0.0f));
    public static final Holder<ConfiguredFeature<ProbabilityFeatureConfiguration, ?>> BAMBOO_SOME_PODZOL = FeatureUtils.register("bamboo_some_podzol", Feature.BAMBOO, new ProbabilityFeatureConfiguration(0.2f));
    public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> VINES = FeatureUtils.register("vines", Feature.VINES);
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_BROWN_MUSHROOM = FeatureUtils.register("patch_brown_mushroom", Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration(Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration(BlockStateProvider.simple(Blocks.BROWN_MUSHROOM))));
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_RED_MUSHROOM = FeatureUtils.register("patch_red_mushroom", Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration(Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration(BlockStateProvider.simple(Blocks.RED_MUSHROOM))));
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_SUNFLOWER = FeatureUtils.register("patch_sunflower", Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration(Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration(BlockStateProvider.simple(Blocks.SUNFLOWER))));
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_PUMPKIN = FeatureUtils.register("patch_pumpkin", Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration(Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration(BlockStateProvider.simple(Blocks.PUMPKIN)), List.of(Blocks.GRASS_BLOCK)));
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_BERRY_BUSH = FeatureUtils.register("patch_berry_bush", Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration(Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration(BlockStateProvider.simple((BlockState)Blocks.SWEET_BERRY_BUSH.defaultBlockState().setValue(SweetBerryBushBlock.AGE, 3))), List.of(Blocks.GRASS_BLOCK)));
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_TAIGA_GRASS = FeatureUtils.register("patch_taiga_grass", Feature.RANDOM_PATCH, VegetationFeatures.grassPatch(new WeightedStateProvider(SimpleWeightedRandomList.builder().add(Blocks.GRASS.defaultBlockState(), 1).add(Blocks.FERN.defaultBlockState(), 4)), 32));
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_GRASS = FeatureUtils.register("patch_grass", Feature.RANDOM_PATCH, VegetationFeatures.grassPatch(BlockStateProvider.simple(Blocks.GRASS), 32));
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_GRASS_JUNGLE = FeatureUtils.register("patch_grass_jungle", Feature.RANDOM_PATCH, new RandomPatchConfiguration(32, 7, 3, PlacementUtils.filtered(Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration(new WeightedStateProvider(SimpleWeightedRandomList.builder().add(Blocks.GRASS.defaultBlockState(), 3).add(Blocks.FERN.defaultBlockState(), 1))), BlockPredicate.allOf(BlockPredicate.ONLY_IN_AIR_PREDICATE, BlockPredicate.not(BlockPredicate.matchesBlock(Blocks.PODZOL, new BlockPos(0, -1, 0)))))));
    public static final Holder<ConfiguredFeature<SimpleBlockConfiguration, ?>> SINGLE_PIECE_OF_GRASS = FeatureUtils.register("single_piece_of_grass", Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration(BlockStateProvider.simple(Blocks.GRASS.defaultBlockState())));
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_DEAD_BUSH = FeatureUtils.register("patch_dead_bush", Feature.RANDOM_PATCH, VegetationFeatures.grassPatch(BlockStateProvider.simple(Blocks.DEAD_BUSH), 4));
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_MELON = FeatureUtils.register("patch_melon", Feature.RANDOM_PATCH, new RandomPatchConfiguration(64, 7, 3, PlacementUtils.filtered(Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration(BlockStateProvider.simple(Blocks.MELON)), BlockPredicate.allOf(BlockPredicate.replaceable(), BlockPredicate.matchesBlock(Blocks.GRASS_BLOCK, new BlockPos(0, -1, 0))))));
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_WATERLILY = FeatureUtils.register("patch_waterlily", Feature.RANDOM_PATCH, new RandomPatchConfiguration(10, 7, 3, PlacementUtils.onlyWhenEmpty(Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration(BlockStateProvider.simple(Blocks.LILY_PAD)))));
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_TALL_GRASS = FeatureUtils.register("patch_tall_grass", Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration(Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration(BlockStateProvider.simple(Blocks.TALL_GRASS))));
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_LARGE_FERN = FeatureUtils.register("patch_large_fern", Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration(Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration(BlockStateProvider.simple(Blocks.LARGE_FERN))));
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_CACTUS = FeatureUtils.register("patch_cactus", Feature.RANDOM_PATCH, FeatureUtils.simpleRandomPatchConfiguration(10, PlacementUtils.a(Feature.BLOCK_COLUMN, BlockColumnConfiguration.simple(BiasedToBottomInt.of(1, 3), BlockStateProvider.simple(Blocks.CACTUS)), BlockPredicateFilter.forPredicate(BlockPredicate.allOf(BlockPredicate.ONLY_IN_AIR_PREDICATE, BlockPredicate.wouldSurvive(Blocks.CACTUS.defaultBlockState(), BlockPos.ZERO))))));
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> PATCH_SUGAR_CANE = FeatureUtils.register("patch_sugar_cane", Feature.RANDOM_PATCH, new RandomPatchConfiguration(20, 4, 0, PlacementUtils.a(Feature.BLOCK_COLUMN, BlockColumnConfiguration.simple(BiasedToBottomInt.of(2, 4), BlockStateProvider.simple(Blocks.SUGAR_CANE)), BlockPredicateFilter.forPredicate(BlockPredicate.a(BlockPredicate.matchesBlock(Blocks.AIR, BlockPos.ZERO), BlockPredicate.wouldSurvive(Blocks.SUGAR_CANE.defaultBlockState(), BlockPos.ZERO), BlockPredicate.b(BlockPredicate.matchesFluids(List.of(Fluids.WATER, Fluids.FLOWING_WATER), new BlockPos(1, -1, 0)), BlockPredicate.matchesFluids(List.of(Fluids.WATER, Fluids.FLOWING_WATER), new BlockPos(-1, -1, 0)), BlockPredicate.matchesFluids(List.of(Fluids.WATER, Fluids.FLOWING_WATER), new BlockPos(0, -1, 1)), BlockPredicate.matchesFluids(List.of(Fluids.WATER, Fluids.FLOWING_WATER), new BlockPos(0, -1, -1))))))));
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_DEFAULT = FeatureUtils.register("flower_default", Feature.FLOWER, VegetationFeatures.grassPatch(new WeightedStateProvider(SimpleWeightedRandomList.builder().add(Blocks.POPPY.defaultBlockState(), 2).add(Blocks.DANDELION.defaultBlockState(), 1)), 64));
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_FLOWER_FOREST = FeatureUtils.register("flower_flower_forest", Feature.FLOWER, new RandomPatchConfiguration(96, 6, 2, PlacementUtils.onlyWhenEmpty(Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration(new NoiseProvider(2345L, new NormalNoise.NoiseParameters(0, 1.0, new double[0]), 0.020833334f, List.of(Blocks.DANDELION.defaultBlockState(), Blocks.POPPY.defaultBlockState(), Blocks.ALLIUM.defaultBlockState(), Blocks.AZURE_BLUET.defaultBlockState(), Blocks.RED_TULIP.defaultBlockState(), Blocks.ORANGE_TULIP.defaultBlockState(), Blocks.WHITE_TULIP.defaultBlockState(), Blocks.PINK_TULIP.defaultBlockState(), Blocks.OXEYE_DAISY.defaultBlockState(), Blocks.CORNFLOWER.defaultBlockState(), Blocks.LILY_OF_THE_VALLEY.defaultBlockState()))))));
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_SWAMP = FeatureUtils.register("flower_swamp", Feature.FLOWER, new RandomPatchConfiguration(64, 6, 2, PlacementUtils.onlyWhenEmpty(Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration(BlockStateProvider.simple(Blocks.BLUE_ORCHID)))));
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_PLAIN = FeatureUtils.register("flower_plain", Feature.FLOWER, new RandomPatchConfiguration(64, 6, 2, PlacementUtils.onlyWhenEmpty(Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration(new NoiseThresholdProvider(2345L, new NormalNoise.NoiseParameters(0, 1.0, new double[0]), 0.005f, -0.8f, 0.33333334f, Blocks.DANDELION.defaultBlockState(), List.of(Blocks.ORANGE_TULIP.defaultBlockState(), Blocks.RED_TULIP.defaultBlockState(), Blocks.PINK_TULIP.defaultBlockState(), Blocks.WHITE_TULIP.defaultBlockState()), List.of(Blocks.POPPY.defaultBlockState(), Blocks.AZURE_BLUET.defaultBlockState(), Blocks.OXEYE_DAISY.defaultBlockState(), Blocks.CORNFLOWER.defaultBlockState()))))));
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWER_MEADOW = FeatureUtils.register("flower_meadow", Feature.FLOWER, new RandomPatchConfiguration(96, 6, 2, PlacementUtils.onlyWhenEmpty(Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration(new DualNoiseProvider(new InclusiveRange<Integer>(1, 3), new NormalNoise.NoiseParameters(-10, 1.0, new double[0]), 1.0f, 2345L, new NormalNoise.NoiseParameters(-3, 1.0, new double[0]), 1.0f, List.of(Blocks.TALL_GRASS.defaultBlockState(), Blocks.ALLIUM.defaultBlockState(), Blocks.POPPY.defaultBlockState(), Blocks.AZURE_BLUET.defaultBlockState(), Blocks.DANDELION.defaultBlockState(), Blocks.CORNFLOWER.defaultBlockState(), Blocks.OXEYE_DAISY.defaultBlockState(), Blocks.GRASS.defaultBlockState()))))));
    public static final Holder<ConfiguredFeature<SimpleRandomFeatureConfiguration, ?>> FOREST_FLOWERS = FeatureUtils.register("forest_flowers", Feature.SIMPLE_RANDOM_SELECTOR, new SimpleRandomFeatureConfiguration(HolderSet.a(PlacementUtils.a(Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration(Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration(BlockStateProvider.simple(Blocks.LILAC))), new PlacementModifier[0]), PlacementUtils.a(Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration(Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration(BlockStateProvider.simple(Blocks.ROSE_BUSH))), new PlacementModifier[0]), PlacementUtils.a(Feature.RANDOM_PATCH, FeatureUtils.simplePatchConfiguration(Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration(BlockStateProvider.simple(Blocks.PEONY))), new PlacementModifier[0]), PlacementUtils.a(Feature.NO_BONEMEAL_FLOWER, FeatureUtils.simplePatchConfiguration(Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration(BlockStateProvider.simple(Blocks.LILY_OF_THE_VALLEY))), new PlacementModifier[0]))));
    public static final Holder<ConfiguredFeature<RandomFeatureConfiguration, ?>> DARK_FOREST_VEGETATION = FeatureUtils.register("dark_forest_vegetation", Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacementUtils.a(TreeFeatures.HUGE_BROWN_MUSHROOM, new PlacementModifier[0]), 0.025f), new WeightedPlacedFeature(PlacementUtils.a(TreeFeatures.HUGE_RED_MUSHROOM, new PlacementModifier[0]), 0.05f), new WeightedPlacedFeature(TreePlacements.DARK_OAK_CHECKED, 0.6666667f), new WeightedPlacedFeature(TreePlacements.BIRCH_CHECKED, 0.2f), new WeightedPlacedFeature(TreePlacements.FANCY_OAK_CHECKED, 0.1f)), TreePlacements.OAK_CHECKED));
    public static final Holder<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_FLOWER_FOREST = FeatureUtils.register("trees_flower_forest", Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(TreePlacements.BIRCH_BEES_002, 0.2f), new WeightedPlacedFeature(TreePlacements.FANCY_OAK_BEES_002, 0.1f)), TreePlacements.OAK_BEES_002));
    public static final Holder<ConfiguredFeature<RandomFeatureConfiguration, ?>> MEADOW_TREES = FeatureUtils.register("meadow_trees", Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(TreePlacements.FANCY_OAK_BEES, 0.5f)), TreePlacements.SUPER_BIRCH_BEES));
    public static final Holder<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_TAIGA = FeatureUtils.register("trees_taiga", Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(TreePlacements.PINE_CHECKED, 0.33333334f)), TreePlacements.SPRUCE_CHECKED));
    public static final Holder<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_GROVE = FeatureUtils.register("trees_grove", Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(TreePlacements.PINE_ON_SNOW, 0.33333334f)), TreePlacements.SPRUCE_ON_SNOW));
    public static final Holder<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_SAVANNA = FeatureUtils.register("trees_savanna", Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(TreePlacements.ACACIA_CHECKED, 0.8f)), TreePlacements.OAK_CHECKED));
    public static final Holder<ConfiguredFeature<RandomFeatureConfiguration, ?>> BIRCH_TALL = FeatureUtils.register("birch_tall", Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(TreePlacements.SUPER_BIRCH_BEES_0002, 0.5f)), TreePlacements.BIRCH_BEES_0002_PLACED));
    public static final Holder<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_WINDSWEPT_HILLS = FeatureUtils.register("trees_windswept_hills", Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(TreePlacements.SPRUCE_CHECKED, 0.666f), new WeightedPlacedFeature(TreePlacements.FANCY_OAK_CHECKED, 0.1f)), TreePlacements.OAK_CHECKED));
    public static final Holder<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_WATER = FeatureUtils.register("trees_water", Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(TreePlacements.FANCY_OAK_CHECKED, 0.1f)), TreePlacements.OAK_CHECKED));
    public static final Holder<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_BIRCH_AND_OAK = FeatureUtils.register("trees_birch_and_oak", Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(TreePlacements.BIRCH_BEES_0002_PLACED, 0.2f), new WeightedPlacedFeature(TreePlacements.FANCY_OAK_BEES_0002, 0.1f)), TreePlacements.OAK_BEES_0002));
    public static final Holder<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_PLAINS = FeatureUtils.register("trees_plains", Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(PlacementUtils.a(TreeFeatures.FANCY_OAK_BEES_005, new PlacementModifier[0]), 0.33333334f)), PlacementUtils.a(TreeFeatures.OAK_BEES_005, new PlacementModifier[0])));
    public static final Holder<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_SPARSE_JUNGLE = FeatureUtils.register("trees_sparse_jungle", Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(TreePlacements.FANCY_OAK_CHECKED, 0.1f), new WeightedPlacedFeature(TreePlacements.JUNGLE_BUSH, 0.5f)), TreePlacements.JUNGLE_TREE_CHECKED));
    public static final Holder<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_OLD_GROWTH_SPRUCE_TAIGA = FeatureUtils.register("trees_old_growth_spruce_taiga", Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(TreePlacements.MEGA_SPRUCE_CHECKED, 0.33333334f), new WeightedPlacedFeature(TreePlacements.PINE_CHECKED, 0.33333334f)), TreePlacements.SPRUCE_CHECKED));
    public static final Holder<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_OLD_GROWTH_PINE_TAIGA = FeatureUtils.register("trees_old_growth_pine_taiga", Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(TreePlacements.MEGA_SPRUCE_CHECKED, 0.025641026f), new WeightedPlacedFeature(TreePlacements.MEGA_PINE_CHECKED, 0.30769232f), new WeightedPlacedFeature(TreePlacements.PINE_CHECKED, 0.33333334f)), TreePlacements.SPRUCE_CHECKED));
    public static final Holder<ConfiguredFeature<RandomFeatureConfiguration, ?>> TREES_JUNGLE = FeatureUtils.register("trees_jungle", Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(TreePlacements.FANCY_OAK_CHECKED, 0.1f), new WeightedPlacedFeature(TreePlacements.JUNGLE_BUSH, 0.5f), new WeightedPlacedFeature(TreePlacements.MEGA_JUNGLE_TREE_CHECKED, 0.33333334f)), TreePlacements.JUNGLE_TREE_CHECKED));
    public static final Holder<ConfiguredFeature<RandomFeatureConfiguration, ?>> BAMBOO_VEGETATION = FeatureUtils.register("bamboo_vegetation", Feature.RANDOM_SELECTOR, new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature(TreePlacements.FANCY_OAK_CHECKED, 0.05f), new WeightedPlacedFeature(TreePlacements.JUNGLE_BUSH, 0.15f), new WeightedPlacedFeature(TreePlacements.MEGA_JUNGLE_TREE_CHECKED, 0.7f)), PlacementUtils.a(PATCH_GRASS_JUNGLE, new PlacementModifier[0])));
    public static final Holder<ConfiguredFeature<RandomBooleanFeatureConfiguration, ?>> MUSHROOM_ISLAND_VEGETATION = FeatureUtils.register("mushroom_island_vegetation", Feature.RANDOM_BOOLEAN_SELECTOR, new RandomBooleanFeatureConfiguration(PlacementUtils.a(TreeFeatures.HUGE_RED_MUSHROOM, new PlacementModifier[0]), PlacementUtils.a(TreeFeatures.HUGE_BROWN_MUSHROOM, new PlacementModifier[0])));

    private static RandomPatchConfiguration grassPatch(BlockStateProvider p_195203_, int p_195204_) {
        return FeatureUtils.simpleRandomPatchConfiguration(p_195204_, PlacementUtils.onlyWhenEmpty(Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration(p_195203_)));
    }
}

