/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.ExhaustedAttemptsException;
import net.minecraft.gametest.framework.GameTestAssertPosException;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestListener;
import net.minecraft.gametest.framework.GameTestTicker;
import net.minecraft.gametest.framework.GlobalTestReporter;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.commons.lang3.exception.ExceptionUtils;

class ReportGameListener
implements GameTestListener {
    private final GameTestInfo originalTestInfo;
    private final GameTestTicker testTicker;
    private final BlockPos structurePos;
    int attempts;
    int successes;

    public ReportGameListener(GameTestInfo pTestInfo, GameTestTicker pTestTicker, BlockPos pPos) {
        this.originalTestInfo = pTestInfo;
        this.testTicker = pTestTicker;
        this.structurePos = pPos;
        this.attempts = 0;
        this.successes = 0;
    }

    @Override
    public void testStructureLoaded(GameTestInfo pTestInfo) {
        ReportGameListener.spawnBeacon(this.originalTestInfo, Blocks.LIGHT_GRAY_STAINED_GLASS);
        ++this.attempts;
    }

    @Override
    public void testPassed(GameTestInfo pTestInfo) {
        ++this.successes;
        if (!pTestInfo.isFlaky()) {
            ReportGameListener.reportPassed(pTestInfo, String.valueOf(pTestInfo.getTestName()) + " passed!");
        } else if (this.successes >= pTestInfo.requiredSuccesses()) {
            ReportGameListener.reportPassed(pTestInfo, pTestInfo + " passed " + this.successes + " times of " + this.attempts + " attempts.");
        } else {
            ReportGameListener.say(this.originalTestInfo.getLevel(), ChatFormatting.GREEN, "Flaky test " + this.originalTestInfo + " succeeded, attempt: " + this.attempts + " successes: " + this.successes);
            this.rerunTest();
        }
    }

    @Override
    public void testFailed(GameTestInfo pTestInfo) {
        if (!pTestInfo.isFlaky()) {
            ReportGameListener.reportFailure(pTestInfo, pTestInfo.getError());
        } else {
            TestFunction testfunction = this.originalTestInfo.getTestFunction();
            String s = "Flaky test " + this.originalTestInfo + " failed, attempt: " + this.attempts + "/" + testfunction.getMaxAttempts();
            if (testfunction.getRequiredSuccesses() > 1) {
                s = String.valueOf(s) + ", successes: " + this.successes + " (" + testfunction.getRequiredSuccesses() + " required)";
            }
            ReportGameListener.say(this.originalTestInfo.getLevel(), ChatFormatting.YELLOW, s);
            if (pTestInfo.maxAttempts() - this.attempts + this.successes >= pTestInfo.requiredSuccesses()) {
                this.rerunTest();
            } else {
                ReportGameListener.reportFailure(pTestInfo, new ExhaustedAttemptsException(this.attempts, this.successes, pTestInfo));
            }
        }
    }

    public static void reportPassed(GameTestInfo pTestInfo, String pMessage) {
        ReportGameListener.spawnBeacon(pTestInfo, Blocks.LIME_STAINED_GLASS);
        ReportGameListener.visualizePassedTest(pTestInfo, pMessage);
    }

    private static void visualizePassedTest(GameTestInfo pTestInfo, String pMessage) {
        ReportGameListener.say(pTestInfo.getLevel(), ChatFormatting.GREEN, pMessage);
        GlobalTestReporter.onTestSuccess(pTestInfo);
    }

    protected static void reportFailure(GameTestInfo pTestInfo, Throwable pError) {
        ReportGameListener.spawnBeacon(pTestInfo, pTestInfo.isRequired() ? Blocks.RED_STAINED_GLASS : Blocks.ORANGE_STAINED_GLASS);
        ReportGameListener.spawnLectern(pTestInfo, Util.describeError(pError));
        ReportGameListener.visualizeFailedTest(pTestInfo, pError);
    }

    protected static void visualizeFailedTest(GameTestInfo pTestInfo, Throwable pError) {
        String s = String.valueOf(pError.getMessage()) + (pError.getCause() == null ? "" : " cause: " + Util.describeError(pError.getCause()));
        String s1 = String.valueOf(pTestInfo.isRequired() ? "" : "(optional) ") + pTestInfo.getTestName() + " failed! " + s;
        ReportGameListener.say(pTestInfo.getLevel(), pTestInfo.isRequired() ? ChatFormatting.RED : ChatFormatting.YELLOW, s1);
        Throwable throwable = (Throwable)MoreObjects.firstNonNull((Object)ExceptionUtils.getRootCause((Throwable)pError), (Object)pError);
        if (throwable instanceof GameTestAssertPosException) {
            GameTestAssertPosException gametestassertposexception = (GameTestAssertPosException)throwable;
            ReportGameListener.showRedBox(pTestInfo.getLevel(), gametestassertposexception.getAbsolutePos(), gametestassertposexception.getMessageToShowAtBlock());
        }
        GlobalTestReporter.onTestFailed(pTestInfo);
    }

    private void rerunTest() {
        this.originalTestInfo.clearStructure();
        GameTestInfo gametestinfo = new GameTestInfo(this.originalTestInfo.getTestFunction(), this.originalTestInfo.getRotation(), this.originalTestInfo.getLevel());
        gametestinfo.startExecution();
        this.testTicker.add(gametestinfo);
        gametestinfo.addListener(this);
        gametestinfo.spawnStructure(this.structurePos, 2);
    }

    protected static void spawnBeacon(GameTestInfo pTestInfo, Block pBlock) {
        ServerLevel serverlevel = pTestInfo.getLevel();
        BlockPos blockpos = pTestInfo.getStructureBlockPos();
        BlockPos blockpos1 = new BlockPos(-1, -1, -1);
        BlockPos blockpos2 = StructureTemplate.transform(blockpos.offset(blockpos1), Mirror.NONE, pTestInfo.getRotation(), blockpos);
        serverlevel.setBlockAndUpdate(blockpos2, Blocks.BEACON.defaultBlockState().rotate(pTestInfo.getRotation()));
        BlockPos blockpos3 = blockpos2.offset(0, 1, 0);
        serverlevel.setBlockAndUpdate(blockpos3, pBlock.defaultBlockState());
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                BlockPos blockpos4 = blockpos2.offset(i, -1, j);
                serverlevel.setBlockAndUpdate(blockpos4, Blocks.IRON_BLOCK.defaultBlockState());
                ++j;
            }
            ++i;
        }
    }

    private static void spawnLectern(GameTestInfo pTestInfo, String pMessage) {
        ServerLevel serverlevel = pTestInfo.getLevel();
        BlockPos blockpos = pTestInfo.getStructureBlockPos();
        BlockPos blockpos1 = new BlockPos(-1, 1, -1);
        BlockPos blockpos2 = StructureTemplate.transform(blockpos.offset(blockpos1), Mirror.NONE, pTestInfo.getRotation(), blockpos);
        serverlevel.setBlockAndUpdate(blockpos2, Blocks.LECTERN.defaultBlockState().rotate(pTestInfo.getRotation()));
        BlockState blockstate = serverlevel.getBlockState(blockpos2);
        ItemStack itemstack = ReportGameListener.createBook(pTestInfo.getTestName(), pTestInfo.isRequired(), pMessage);
        LecternBlock.tryPlaceBook(null, serverlevel, blockpos2, blockstate, itemstack);
    }

    private static ItemStack createBook(String pTestName, boolean pRequired, String pMessage) {
        ItemStack itemstack = new ItemStack(Items.WRITABLE_BOOK);
        ListTag listtag = new ListTag();
        StringBuffer stringbuffer = new StringBuffer();
        Arrays.stream(pTestName.split("\\.")).forEach(p_177716_ -> stringbuffer.append((String)p_177716_).append('\n'));
        if (!pRequired) {
            stringbuffer.append("(optional)\n");
        }
        stringbuffer.append("-------------------\n");
        listtag.add(StringTag.valueOf(stringbuffer + pMessage));
        itemstack.addTagElement("pages", listtag);
        return itemstack;
    }

    protected static void say(ServerLevel pServerLevel, ChatFormatting pFormatting, String pMessage) {
        pServerLevel.getPlayers(p_177705_ -> true).forEach(p_177709_ -> p_177709_.sendMessage(new TextComponent(pMessage).withStyle(pFormatting), Util.NIL_UUID));
    }

    private static void showRedBox(ServerLevel pServerLevel, BlockPos pPos, String pDisplayMessage) {
        DebugPackets.sendGameTestAddMarker(pServerLevel, pPos, pDisplayMessage, -2130771968, Integer.MAX_VALUE);
    }
}

