/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.data.structures.NbtToSnbt;
import net.minecraft.data.structures.StructureUpdater;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.Bootstrap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.LevelTicks;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class StructureUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String DEFAULT_TEST_STRUCTURES_DIR = "gameteststructures";
    public static String testStructuresDir = "gameteststructures";
    private static final int HOW_MANY_CHUNKS_TO_LOAD_IN_EACH_DIRECTION_OF_STRUCTURE = 4;

    public static Rotation getRotationForRotationSteps(int pRotationSteps) {
        switch (pRotationSteps) {
            case 0: {
                return Rotation.NONE;
            }
            case 1: {
                return Rotation.CLOCKWISE_90;
            }
            case 2: {
                return Rotation.CLOCKWISE_180;
            }
            case 3: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        throw new IllegalArgumentException("rotationSteps must be a value from 0-3. Got value " + pRotationSteps);
    }

    public static int getRotationStepsForRotation(Rotation pRotation) {
        switch (pRotation) {
            case NONE: {
                return 0;
            }
            case CLOCKWISE_90: {
                return 1;
            }
            case CLOCKWISE_180: {
                return 2;
            }
            case COUNTERCLOCKWISE_90: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unknown rotation value, don't know how many steps it represents: " + (Object)((Object)pRotation));
    }

    public static void a(String[] p_177771_) throws IOException {
        Bootstrap.bootStrap();
        Files.walk(Paths.get(testStructuresDir, new String[0]), new FileVisitOption[0]).filter(p_177775_ -> p_177775_.toString().endsWith(".snbt")).forEach(p_177773_ -> {
            try {
                String s = new String(Files.readAllBytes(p_177773_), StandardCharsets.UTF_8);
                CompoundTag compoundtag = NbtUtils.snbtToStructure(s);
                CompoundTag compoundtag1 = StructureUpdater.update(p_177773_.toString(), compoundtag);
                NbtToSnbt.writeSnbt(p_177773_, NbtUtils.structureToSnbt(compoundtag1));
            }
            catch (CommandSyntaxException | IOException commandsyntaxexception) {
                LOGGER.error("Something went wrong upgrading: {}", p_177773_, (Object)commandsyntaxexception);
            }
        });
    }

    public static AABB getStructureBounds(StructureBlockEntity pStructureBlockEntity) {
        BlockPos blockpos = pStructureBlockEntity.getBlockPos();
        BlockPos blockpos1 = blockpos.offset(pStructureBlockEntity.getStructureSize().offset(-1, -1, -1));
        BlockPos blockpos2 = StructureTemplate.transform(blockpos1, Mirror.NONE, pStructureBlockEntity.getRotation(), blockpos);
        return new AABB(blockpos, blockpos2);
    }

    public static BoundingBox getStructureBoundingBox(StructureBlockEntity pStructureBlockEntity) {
        BlockPos blockpos = pStructureBlockEntity.getBlockPos();
        BlockPos blockpos1 = blockpos.offset(pStructureBlockEntity.getStructureSize().offset(-1, -1, -1));
        BlockPos blockpos2 = StructureTemplate.transform(blockpos1, Mirror.NONE, pStructureBlockEntity.getRotation(), blockpos);
        return BoundingBox.fromCorners(blockpos, blockpos2);
    }

    public static void addCommandBlockAndButtonToStartTest(BlockPos p_127876_, BlockPos p_127877_, Rotation p_127878_, ServerLevel p_127879_) {
        BlockPos blockpos = StructureTemplate.transform(p_127876_.offset(p_127877_), Mirror.NONE, p_127878_, p_127876_);
        p_127879_.setBlockAndUpdate(blockpos, Blocks.COMMAND_BLOCK.defaultBlockState());
        CommandBlockEntity commandblockentity = (CommandBlockEntity)p_127879_.getBlockEntity(blockpos);
        commandblockentity.getCommandBlock().setCommand("test runthis");
        BlockPos blockpos1 = StructureTemplate.transform(blockpos.offset(0, 0, -1), Mirror.NONE, p_127878_, blockpos);
        p_127879_.setBlockAndUpdate(blockpos1, Blocks.STONE_BUTTON.defaultBlockState().rotate(p_127878_));
    }

    public static void createNewEmptyStructureBlock(String pStructureName, BlockPos pPos, Vec3i pSize, Rotation pRotation, ServerLevel pServerLevel) {
        BoundingBox boundingbox = StructureUtils.getStructureBoundingBox(pPos, pSize, pRotation);
        StructureUtils.clearSpaceForStructure(boundingbox, pPos.getY(), pServerLevel);
        pServerLevel.setBlockAndUpdate(pPos, Blocks.STRUCTURE_BLOCK.defaultBlockState());
        StructureBlockEntity structureblockentity = (StructureBlockEntity)pServerLevel.getBlockEntity(pPos);
        structureblockentity.setIgnoreEntities(false);
        structureblockentity.setStructureName(new ResourceLocation(pStructureName));
        structureblockentity.setStructureSize(pSize);
        structureblockentity.setMode(StructureMode.SAVE);
        structureblockentity.setShowBoundingBox(true);
    }

    public static StructureBlockEntity spawnStructure(String p_127884_, BlockPos p_127885_, Rotation p_127886_, int p_127887_, ServerLevel p_127888_, boolean p_127889_) {
        BlockPos blockpos;
        Vec3i vec3i = StructureUtils.getStructureTemplate(p_127884_, p_127888_).getSize();
        BoundingBox boundingbox = StructureUtils.getStructureBoundingBox(p_127885_, vec3i, p_127886_);
        if (p_127886_ == Rotation.NONE) {
            blockpos = p_127885_;
        } else if (p_127886_ == Rotation.CLOCKWISE_90) {
            blockpos = p_127885_.offset(vec3i.getZ() - 1, 0, 0);
        } else if (p_127886_ == Rotation.CLOCKWISE_180) {
            blockpos = p_127885_.offset(vec3i.getX() - 1, 0, vec3i.getZ() - 1);
        } else {
            if (p_127886_ != Rotation.COUNTERCLOCKWISE_90) {
                throw new IllegalArgumentException("Invalid rotation: " + (Object)((Object)p_127886_));
            }
            blockpos = p_127885_.offset(0, 0, vec3i.getX() - 1);
        }
        StructureUtils.forceLoadChunks(p_127885_, p_127888_);
        StructureUtils.clearSpaceForStructure(boundingbox, p_127885_.getY(), p_127888_);
        StructureBlockEntity structureblockentity = StructureUtils.createStructureBlock(p_127884_, blockpos, p_127886_, p_127888_, p_127889_);
        ((LevelTicks)p_127888_.getBlockTicks()).clearArea(boundingbox);
        p_127888_.clearBlockEvents(boundingbox);
        return structureblockentity;
    }

    private static void forceLoadChunks(BlockPos pPos, ServerLevel pServerLevel) {
        ChunkPos chunkpos = new ChunkPos(pPos);
        int i = -1;
        while (i < 4) {
            int j = -1;
            while (j < 4) {
                int k = chunkpos.x + i;
                int l = chunkpos.z + j;
                pServerLevel.setChunkForced(k, l, true);
                ++j;
            }
            ++i;
        }
    }

    public static void clearSpaceForStructure(BoundingBox p_127850_, int p_127851_, ServerLevel p_127852_) {
        BoundingBox boundingbox = new BoundingBox(p_127850_.minX() - 2, p_127850_.minY() - 3, p_127850_.minZ() - 3, p_127850_.maxX() + 3, p_127850_.maxY() + 20, p_127850_.maxZ() + 3);
        BlockPos.betweenClosedStream(boundingbox).forEach(p_177748_ -> StructureUtils.clearBlock(p_127851_, p_177748_, p_127852_));
        ((LevelTicks)p_127852_.getBlockTicks()).clearArea(boundingbox);
        p_127852_.clearBlockEvents(boundingbox);
        AABB aabb = new AABB(boundingbox.minX(), boundingbox.minY(), boundingbox.minZ(), boundingbox.maxX(), boundingbox.maxY(), boundingbox.maxZ());
        List<Entity> list = p_127852_.getEntitiesOfClass(Entity.class, aabb, p_177750_ -> !(p_177750_ instanceof Player));
        list.forEach(Entity::discard);
    }

    public static BoundingBox getStructureBoundingBox(BlockPos pPos, Vec3i pOffset, Rotation pRotation) {
        BlockPos blockpos = pPos.offset(pOffset).offset(-1, -1, -1);
        BlockPos blockpos1 = StructureTemplate.transform(blockpos, Mirror.NONE, pRotation, pPos);
        BoundingBox boundingbox = BoundingBox.fromCorners(pPos, blockpos1);
        int i = Math.min(boundingbox.minX(), boundingbox.maxX());
        int j = Math.min(boundingbox.minZ(), boundingbox.maxZ());
        return boundingbox.move(pPos.getX() - i, 0, pPos.getZ() - j);
    }

    public static Optional<BlockPos> findStructureBlockContainingPos(BlockPos p_127854_, int p_127855_, ServerLevel p_127856_) {
        return StructureUtils.findStructureBlocks(p_127854_, p_127855_, p_127856_).stream().filter(p_177756_ -> StructureUtils.doesStructureContain(p_177756_, p_127854_, p_127856_)).findFirst();
    }

    @Nullable
    public static BlockPos findNearestStructureBlock(BlockPos p_127907_, int p_127908_, ServerLevel p_127909_) {
        Comparator<BlockPos> comparator = Comparator.comparingInt(p_177759_ -> p_177759_.distManhattan(p_127907_));
        Collection<BlockPos> collection = StructureUtils.findStructureBlocks(p_127907_, p_127908_, p_127909_);
        Optional<BlockPos> optional = collection.stream().min(comparator);
        return optional.orElse(null);
    }

    public static Collection<BlockPos> findStructureBlocks(BlockPos p_127911_, int p_127912_, ServerLevel p_127913_) {
        ArrayList collection = Lists.newArrayList();
        AABB aabb = new AABB(p_127911_);
        aabb = aabb.inflate(p_127912_);
        int i = (int)aabb.minX;
        while (i <= (int)aabb.maxX) {
            int j = (int)aabb.minY;
            while (j <= (int)aabb.maxY) {
                int k = (int)aabb.minZ;
                while (k <= (int)aabb.maxZ) {
                    BlockPos blockpos = new BlockPos(i, j, k);
                    BlockState blockstate = p_127913_.getBlockState(blockpos);
                    if (blockstate.is(Blocks.STRUCTURE_BLOCK)) {
                        collection.add(blockpos);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return collection;
    }

    private static StructureTemplate getStructureTemplate(String pStructureName, ServerLevel pServerLevel) {
        StructureManager structuremanager = pServerLevel.getStructureManager();
        Optional<StructureTemplate> optional = structuremanager.get(new ResourceLocation(pStructureName));
        if (optional.isPresent()) {
            return optional.get();
        }
        String s = String.valueOf(pStructureName) + ".snbt";
        Path path = Paths.get(testStructuresDir, s);
        CompoundTag compoundtag = StructureUtils.tryLoadStructure(path);
        if (compoundtag == null) {
            throw new RuntimeException("Could not find structure file " + path + ", and the structure is not available in the world structures either.");
        }
        return structuremanager.readStructure(compoundtag);
    }

    private static StructureBlockEntity createStructureBlock(String p_127891_, BlockPos p_127892_, Rotation p_127893_, ServerLevel p_127894_, boolean p_127895_) {
        p_127894_.setBlockAndUpdate(p_127892_, Blocks.STRUCTURE_BLOCK.defaultBlockState());
        StructureBlockEntity structureblockentity = (StructureBlockEntity)p_127894_.getBlockEntity(p_127892_);
        structureblockentity.setMode(StructureMode.LOAD);
        structureblockentity.setRotation(p_127893_);
        structureblockentity.setIgnoreEntities(false);
        structureblockentity.setStructureName(new ResourceLocation(p_127891_));
        structureblockentity.loadStructure(p_127894_, p_127895_);
        if (structureblockentity.getStructureSize() != Vec3i.ZERO) {
            return structureblockentity;
        }
        StructureTemplate structuretemplate = StructureUtils.getStructureTemplate(p_127891_, p_127894_);
        structureblockentity.loadStructure(p_127894_, p_127895_, structuretemplate);
        if (structureblockentity.getStructureSize() == Vec3i.ZERO) {
            throw new RuntimeException("Failed to load structure " + p_127891_);
        }
        return structureblockentity;
    }

    @Nullable
    private static CompoundTag tryLoadStructure(Path pPathToStructure) {
        try {
            BufferedReader bufferedreader = Files.newBufferedReader(pPathToStructure);
            String s = IOUtils.toString((Reader)bufferedreader);
            return NbtUtils.snbtToStructure(s);
        }
        catch (IOException ioexception) {
            return null;
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            throw new RuntimeException("Error while trying to load structure " + pPathToStructure, commandsyntaxexception);
        }
    }

    private static void clearBlock(int p_127842_, BlockPos p_127843_, ServerLevel p_127844_) {
        BlockState blockstate = null;
        FlatLevelGeneratorSettings flatlevelgeneratorsettings = FlatLevelGeneratorSettings.getDefault(p_127844_.registryAccess().registryOrThrow(Registry.BIOME_REGISTRY), p_127844_.registryAccess().registryOrThrow(Registry.STRUCTURE_SET_REGISTRY));
        List<BlockState> list = flatlevelgeneratorsettings.getLayers();
        int i = p_127843_.getY() - p_127844_.getMinBuildHeight();
        if (p_127843_.getY() < p_127842_ && i > 0 && i <= list.size()) {
            blockstate = list.get(i - 1);
        }
        if (blockstate == null) {
            blockstate = Blocks.AIR.defaultBlockState();
        }
        BlockInput blockinput = new BlockInput(blockstate, Collections.emptySet(), null);
        blockinput.place(p_127844_, p_127843_, 2);
        p_127844_.blockUpdated(p_127843_, blockstate.getBlock());
    }

    private static boolean doesStructureContain(BlockPos pStructureBlockPos, BlockPos pPosToTest, ServerLevel pServerLevel) {
        StructureBlockEntity structureblockentity = (StructureBlockEntity)pServerLevel.getBlockEntity(pStructureBlockPos);
        AABB aabb = StructureUtils.getStructureBounds(structureblockentity).inflate(1.0);
        return aabb.contains(Vec3.atCenterOf(pPosToTest));
    }
}

