/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.data.structures.NbtToSnbt;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestListener;
import net.minecraft.gametest.framework.GameTestRegistry;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.GameTestTicker;
import net.minecraft.gametest.framework.MultipleTestTracker;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestClassNameArgument;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.gametest.framework.TestFunctionArgument;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.commons.io.IOUtils;

public class TestCommand {
    private static final int DEFAULT_CLEAR_RADIUS = 200;
    private static final int MAX_CLEAR_RADIUS = 1024;
    private static final int STRUCTURE_BLOCK_NEARBY_SEARCH_RADIUS = 15;
    private static final int STRUCTURE_BLOCK_FULL_SEARCH_RADIUS = 200;
    private static final int TEST_POS_Z_OFFSET_FROM_PLAYER = 3;
    private static final int SHOW_POS_DURATION_MS = 10000;
    private static final int DEFAULT_X_SIZE = 5;
    private static final int DEFAULT_Y_SIZE = 5;
    private static final int DEFAULT_Z_SIZE = 5;

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("test").then(Commands.literal("runthis").executes(p_128057_ -> TestCommand.runNearbyTest((CommandSourceStack)p_128057_.getSource())))).then(Commands.literal("runthese").executes(p_128055_ -> TestCommand.runAllNearbyTests((CommandSourceStack)p_128055_.getSource())))).then(((LiteralArgumentBuilder)Commands.literal("runfailed").executes(p_128053_ -> TestCommand.runLastFailedTests((CommandSourceStack)p_128053_.getSource(), false, 0, 8))).then(((RequiredArgumentBuilder)Commands.argument("onlyRequiredTests", BoolArgumentType.bool()).executes(p_128051_ -> TestCommand.runLastFailedTests((CommandSourceStack)p_128051_.getSource(), BoolArgumentType.getBool((CommandContext)p_128051_, (String)"onlyRequiredTests"), 0, 8))).then(((RequiredArgumentBuilder)Commands.argument("rotationSteps", IntegerArgumentType.integer()).executes(p_128049_ -> TestCommand.runLastFailedTests((CommandSourceStack)p_128049_.getSource(), BoolArgumentType.getBool((CommandContext)p_128049_, (String)"onlyRequiredTests"), IntegerArgumentType.getInteger((CommandContext)p_128049_, (String)"rotationSteps"), 8))).then(Commands.argument("testsPerRow", IntegerArgumentType.integer()).executes(p_128047_ -> TestCommand.runLastFailedTests((CommandSourceStack)p_128047_.getSource(), BoolArgumentType.getBool((CommandContext)p_128047_, (String)"onlyRequiredTests"), IntegerArgumentType.getInteger((CommandContext)p_128047_, (String)"rotationSteps"), IntegerArgumentType.getInteger((CommandContext)p_128047_, (String)"testsPerRow")))))))).then(Commands.literal("run").then(((RequiredArgumentBuilder)Commands.argument("testName", TestFunctionArgument.testFunctionArgument()).executes(p_128045_ -> TestCommand.runTest((CommandSourceStack)p_128045_.getSource(), TestFunctionArgument.getTestFunction((CommandContext<CommandSourceStack>)p_128045_, "testName"), 0))).then(Commands.argument("rotationSteps", IntegerArgumentType.integer()).executes(p_128043_ -> TestCommand.runTest((CommandSourceStack)p_128043_.getSource(), TestFunctionArgument.getTestFunction((CommandContext<CommandSourceStack>)p_128043_, "testName"), IntegerArgumentType.getInteger((CommandContext)p_128043_, (String)"rotationSteps"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("runall").executes(p_128041_ -> TestCommand.runAllTests((CommandSourceStack)p_128041_.getSource(), 0, 8))).then(((RequiredArgumentBuilder)Commands.argument("testClassName", TestClassNameArgument.testClassName()).executes(p_128039_ -> TestCommand.runAllTestsInClass((CommandSourceStack)p_128039_.getSource(), TestClassNameArgument.getTestClassName((CommandContext<CommandSourceStack>)p_128039_, "testClassName"), 0, 8))).then(((RequiredArgumentBuilder)Commands.argument("rotationSteps", IntegerArgumentType.integer()).executes(p_128037_ -> TestCommand.runAllTestsInClass((CommandSourceStack)p_128037_.getSource(), TestClassNameArgument.getTestClassName((CommandContext<CommandSourceStack>)p_128037_, "testClassName"), IntegerArgumentType.getInteger((CommandContext)p_128037_, (String)"rotationSteps"), 8))).then(Commands.argument("testsPerRow", IntegerArgumentType.integer()).executes(p_128035_ -> TestCommand.runAllTestsInClass((CommandSourceStack)p_128035_.getSource(), TestClassNameArgument.getTestClassName((CommandContext<CommandSourceStack>)p_128035_, "testClassName"), IntegerArgumentType.getInteger((CommandContext)p_128035_, (String)"rotationSteps"), IntegerArgumentType.getInteger((CommandContext)p_128035_, (String)"testsPerRow"))))))).then(((RequiredArgumentBuilder)Commands.argument("rotationSteps", IntegerArgumentType.integer()).executes(p_128033_ -> TestCommand.runAllTests((CommandSourceStack)p_128033_.getSource(), IntegerArgumentType.getInteger((CommandContext)p_128033_, (String)"rotationSteps"), 8))).then(Commands.argument("testsPerRow", IntegerArgumentType.integer()).executes(p_128031_ -> TestCommand.runAllTests((CommandSourceStack)p_128031_.getSource(), IntegerArgumentType.getInteger((CommandContext)p_128031_, (String)"rotationSteps"), IntegerArgumentType.getInteger((CommandContext)p_128031_, (String)"testsPerRow"))))))).then(Commands.literal("export").then(Commands.argument("testName", StringArgumentType.word()).executes(p_128029_ -> TestCommand.exportTestStructure((CommandSourceStack)p_128029_.getSource(), StringArgumentType.getString((CommandContext)p_128029_, (String)"testName")))))).then(Commands.literal("exportthis").executes(p_128027_ -> TestCommand.exportNearestTestStructure((CommandSourceStack)p_128027_.getSource())))).then(Commands.literal("import").then(Commands.argument("testName", StringArgumentType.word()).executes(p_128025_ -> TestCommand.importTestStructure((CommandSourceStack)p_128025_.getSource(), StringArgumentType.getString((CommandContext)p_128025_, (String)"testName")))))).then(((LiteralArgumentBuilder)Commands.literal("pos").executes(p_128023_ -> TestCommand.showPos((CommandSourceStack)p_128023_.getSource(), "pos"))).then(Commands.argument("var", StringArgumentType.word()).executes(p_128021_ -> TestCommand.showPos((CommandSourceStack)p_128021_.getSource(), StringArgumentType.getString((CommandContext)p_128021_, (String)"var")))))).then(Commands.literal("create").then(((RequiredArgumentBuilder)Commands.argument("testName", StringArgumentType.word()).executes(p_128019_ -> TestCommand.createNewStructure((CommandSourceStack)p_128019_.getSource(), StringArgumentType.getString((CommandContext)p_128019_, (String)"testName"), 5, 5, 5))).then(((RequiredArgumentBuilder)Commands.argument("width", IntegerArgumentType.integer()).executes(p_128014_ -> TestCommand.createNewStructure((CommandSourceStack)p_128014_.getSource(), StringArgumentType.getString((CommandContext)p_128014_, (String)"testName"), IntegerArgumentType.getInteger((CommandContext)p_128014_, (String)"width"), IntegerArgumentType.getInteger((CommandContext)p_128014_, (String)"width"), IntegerArgumentType.getInteger((CommandContext)p_128014_, (String)"width")))).then(Commands.argument("height", IntegerArgumentType.integer()).then(Commands.argument("depth", IntegerArgumentType.integer()).executes(p_128007_ -> TestCommand.createNewStructure((CommandSourceStack)p_128007_.getSource(), StringArgumentType.getString((CommandContext)p_128007_, (String)"testName"), IntegerArgumentType.getInteger((CommandContext)p_128007_, (String)"width"), IntegerArgumentType.getInteger((CommandContext)p_128007_, (String)"height"), IntegerArgumentType.getInteger((CommandContext)p_128007_, (String)"depth"))))))))).then(((LiteralArgumentBuilder)Commands.literal("clearall").executes(p_128000_ -> TestCommand.clearAllTests((CommandSourceStack)p_128000_.getSource(), 200))).then(Commands.argument("radius", IntegerArgumentType.integer()).executes(p_127949_ -> TestCommand.clearAllTests((CommandSourceStack)p_127949_.getSource(), IntegerArgumentType.getInteger((CommandContext)p_127949_, (String)"radius"))))));
    }

    private static int createNewStructure(CommandSourceStack pSource, String pStructureName, int pX, int pY, int pZ) {
        if (pX <= 48 && pY <= 48 && pZ <= 48) {
            ServerLevel serverlevel = pSource.getLevel();
            BlockPos blockpos = new BlockPos(pSource.getPosition());
            BlockPos blockpos1 = new BlockPos(blockpos.getX(), pSource.getLevel().getHeightmapPos(Heightmap.Types.WORLD_SURFACE, blockpos).getY(), blockpos.getZ() + 3);
            StructureUtils.createNewEmptyStructureBlock(pStructureName.toLowerCase(), blockpos1, new Vec3i(pX, pY, pZ), Rotation.NONE, serverlevel);
            int i = 0;
            while (i < pX) {
                int j = 0;
                while (j < pZ) {
                    BlockPos blockpos2 = new BlockPos(blockpos1.getX() + i, blockpos1.getY() + 1, blockpos1.getZ() + j);
                    Block block = Blocks.POLISHED_ANDESITE;
                    BlockInput blockinput = new BlockInput(block.defaultBlockState(), Collections.emptySet(), null);
                    blockinput.place(serverlevel, blockpos2, 2);
                    ++j;
                }
                ++i;
            }
            StructureUtils.addCommandBlockAndButtonToStartTest(blockpos1, new BlockPos(1, 0, -1), Rotation.NONE, serverlevel);
            return 0;
        }
        throw new IllegalArgumentException("The structure must be less than 48 blocks big in each axis");
    }

    private static int showPos(CommandSourceStack p_127960_, String p_127961_) throws CommandSyntaxException {
        ServerLevel serverlevel;
        BlockHitResult blockhitresult = (BlockHitResult)p_127960_.getPlayerOrException().pick(10.0, 1.0f, false);
        BlockPos blockpos = blockhitresult.getBlockPos();
        Optional<BlockPos> optional = StructureUtils.findStructureBlockContainingPos(blockpos, 15, serverlevel = p_127960_.getLevel());
        if (!optional.isPresent()) {
            optional = StructureUtils.findStructureBlockContainingPos(blockpos, 200, serverlevel);
        }
        if (!optional.isPresent()) {
            p_127960_.sendFailure(new TextComponent("Can't find a structure block that contains the targeted pos " + blockpos));
            return 0;
        }
        StructureBlockEntity structureblockentity = (StructureBlockEntity)serverlevel.getBlockEntity(optional.get());
        BlockPos blockpos1 = blockpos.subtract(optional.get());
        String s = String.valueOf(blockpos1.getX()) + ", " + blockpos1.getY() + ", " + blockpos1.getZ();
        String s1 = structureblockentity.getStructurePath();
        MutableComponent component = new TextComponent(s).setStyle(Style.EMPTY.withBold(true).withColor(ChatFormatting.GREEN).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new TextComponent("Click to copy to clipboard"))).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, "final BlockPos " + p_127961_ + " = new BlockPos(" + s + ");")));
        p_127960_.sendSuccess(new TextComponent("Position relative to " + s1 + ": ").append(component), false);
        DebugPackets.sendGameTestAddMarker(serverlevel, new BlockPos(blockpos), s, -2147418368, 10000);
        return 1;
    }

    private static int runNearbyTest(CommandSourceStack pSource) {
        ServerLevel serverlevel;
        BlockPos blockpos = new BlockPos(pSource.getPosition());
        BlockPos blockpos1 = StructureUtils.findNearestStructureBlock(blockpos, 15, serverlevel = pSource.getLevel());
        if (blockpos1 == null) {
            TestCommand.say(serverlevel, "Couldn't find any structure block within 15 radius", ChatFormatting.RED);
            return 0;
        }
        GameTestRunner.clearMarkers(serverlevel);
        TestCommand.runTest(serverlevel, blockpos1, null);
        return 1;
    }

    private static int runAllNearbyTests(CommandSourceStack pSource) {
        ServerLevel serverlevel;
        BlockPos blockpos = new BlockPos(pSource.getPosition());
        Collection<BlockPos> collection = StructureUtils.findStructureBlocks(blockpos, 200, serverlevel = pSource.getLevel());
        if (collection.isEmpty()) {
            TestCommand.say(serverlevel, "Couldn't find any structure blocks within 200 block radius", ChatFormatting.RED);
            return 1;
        }
        GameTestRunner.clearMarkers(serverlevel);
        TestCommand.say(pSource, "Running " + collection.size() + " tests...");
        MultipleTestTracker multipletesttracker = new MultipleTestTracker();
        collection.forEach(p_127943_ -> TestCommand.runTest(serverlevel, p_127943_, multipletesttracker));
        return 1;
    }

    private static void runTest(ServerLevel pSource, BlockPos pFunction, @Nullable MultipleTestTracker pRotationSteps) {
        StructureBlockEntity structureblockentity = (StructureBlockEntity)pSource.getBlockEntity(pFunction);
        String s = structureblockentity.getStructurePath();
        TestFunction testfunction = GameTestRegistry.getTestFunction(s);
        GameTestInfo gametestinfo = new GameTestInfo(testfunction, structureblockentity.getRotation(), pSource);
        if (pRotationSteps != null) {
            pRotationSteps.addTestToTrack(gametestinfo);
            gametestinfo.addListener(new TestSummaryDisplayer(pSource, pRotationSteps));
        }
        TestCommand.runTestPreparation(testfunction, pSource);
        AABB aabb = StructureUtils.getStructureBounds(structureblockentity);
        BlockPos blockpos = new BlockPos(aabb.minX, aabb.minY, aabb.minZ);
        GameTestRunner.runTest(gametestinfo, blockpos, GameTestTicker.SINGLETON);
    }

    static void showTestSummaryIfAllDone(ServerLevel pServerLevel, MultipleTestTracker pTracker) {
        if (pTracker.isDone()) {
            TestCommand.say(pServerLevel, "GameTest done! " + pTracker.getTotalCount() + " tests were run", ChatFormatting.WHITE);
            if (pTracker.hasFailedRequired()) {
                TestCommand.say(pServerLevel, String.valueOf(pTracker.getFailedRequiredCount()) + " required tests failed :(", ChatFormatting.RED);
            } else {
                TestCommand.say(pServerLevel, "All required tests passed :)", ChatFormatting.GREEN);
            }
            if (pTracker.hasFailedOptional()) {
                TestCommand.say(pServerLevel, String.valueOf(pTracker.getFailedOptionalCount()) + " optional tests failed", ChatFormatting.GRAY);
            }
        }
    }

    private static int clearAllTests(CommandSourceStack pSource, int pRadius) {
        ServerLevel serverlevel = pSource.getLevel();
        GameTestRunner.clearMarkers(serverlevel);
        BlockPos blockpos = new BlockPos(pSource.getPosition().x, (double)pSource.getLevel().getHeightmapPos(Heightmap.Types.WORLD_SURFACE, new BlockPos(pSource.getPosition())).getY(), pSource.getPosition().z);
        GameTestRunner.clearAllTests(serverlevel, blockpos, GameTestTicker.SINGLETON, Mth.clamp(pRadius, 0, 1024));
        return 1;
    }

    private static int runTest(CommandSourceStack pSource, TestFunction pFunction, int pRotationSteps) {
        ServerLevel serverlevel = pSource.getLevel();
        BlockPos blockpos = new BlockPos(pSource.getPosition());
        int i = pSource.getLevel().getHeightmapPos(Heightmap.Types.WORLD_SURFACE, blockpos).getY();
        BlockPos blockpos1 = new BlockPos(blockpos.getX(), i, blockpos.getZ() + 3);
        GameTestRunner.clearMarkers(serverlevel);
        TestCommand.runTestPreparation(pFunction, serverlevel);
        Rotation rotation = StructureUtils.getRotationForRotationSteps(pRotationSteps);
        GameTestInfo gametestinfo = new GameTestInfo(pFunction, rotation, serverlevel);
        GameTestRunner.runTest(gametestinfo, blockpos1, GameTestTicker.SINGLETON);
        return 1;
    }

    private static void runTestPreparation(TestFunction pFunction, ServerLevel pServerLevel) {
        Consumer<ServerLevel> consumer = GameTestRegistry.getBeforeBatchFunction(pFunction.getBatchName());
        if (consumer != null) {
            consumer.accept(pServerLevel);
        }
    }

    private static int runAllTests(CommandSourceStack pSource, int pRotationSteps, int pTestsPerRow) {
        GameTestRunner.clearMarkers(pSource.getLevel());
        Collection<TestFunction> collection = GameTestRegistry.getAllTestFunctions();
        TestCommand.say(pSource, "Running all " + collection.size() + " tests...");
        GameTestRegistry.forgetFailedTests();
        TestCommand.runTests(pSource, collection, pRotationSteps, pTestsPerRow);
        return 1;
    }

    private static int runAllTestsInClass(CommandSourceStack pSource, String pTestClassName, int pRotationSteps, int pTestsPerRow) {
        Collection<TestFunction> collection = GameTestRegistry.getTestFunctionsForClassName(pTestClassName);
        GameTestRunner.clearMarkers(pSource.getLevel());
        TestCommand.say(pSource, "Running " + collection.size() + " tests from " + pTestClassName + "...");
        GameTestRegistry.forgetFailedTests();
        TestCommand.runTests(pSource, collection, pRotationSteps, pTestsPerRow);
        return 1;
    }

    private static int runLastFailedTests(CommandSourceStack pSource, boolean pRunOnlyRequired, int pRotationSteps, int pTestsPerRow) {
        Collection collection = pRunOnlyRequired ? (Collection)GameTestRegistry.getLastFailedTests().stream().filter(TestFunction::isRequired).collect(Collectors.toList()) : GameTestRegistry.getLastFailedTests();
        if (collection.isEmpty()) {
            TestCommand.say(pSource, "No failed tests to rerun");
            return 0;
        }
        GameTestRunner.clearMarkers(pSource.getLevel());
        TestCommand.say(pSource, "Rerunning " + collection.size() + " failed tests (" + (pRunOnlyRequired ? "only required tests" : "including optional tests") + ")");
        TestCommand.runTests(pSource, collection, pRotationSteps, pTestsPerRow);
        return 1;
    }

    private static void runTests(CommandSourceStack p_127974_, Collection<TestFunction> p_127975_, int p_127976_, int p_127977_) {
        BlockPos blockpos = new BlockPos(p_127974_.getPosition());
        BlockPos blockpos1 = new BlockPos(blockpos.getX(), p_127974_.getLevel().getHeightmapPos(Heightmap.Types.WORLD_SURFACE, blockpos).getY(), blockpos.getZ() + 3);
        ServerLevel serverlevel = p_127974_.getLevel();
        Rotation rotation = StructureUtils.getRotationForRotationSteps(p_127976_);
        Collection<GameTestInfo> collection = GameTestRunner.runTests(p_127975_, blockpos1, rotation, serverlevel, GameTestTicker.SINGLETON, p_127977_);
        MultipleTestTracker multipletesttracker = new MultipleTestTracker(collection);
        multipletesttracker.addListener(new TestSummaryDisplayer(serverlevel, multipletesttracker));
        multipletesttracker.addFailureListener(p_127992_ -> GameTestRegistry.rememberFailedTest(p_127992_.getTestFunction()));
    }

    private static void say(CommandSourceStack pSource, String pMessage) {
        pSource.sendSuccess(new TextComponent(pMessage), false);
    }

    private static int exportNearestTestStructure(CommandSourceStack pSource) {
        ServerLevel serverlevel;
        BlockPos blockpos = new BlockPos(pSource.getPosition());
        BlockPos blockpos1 = StructureUtils.findNearestStructureBlock(blockpos, 15, serverlevel = pSource.getLevel());
        if (blockpos1 == null) {
            TestCommand.say(serverlevel, "Couldn't find any structure block within 15 radius", ChatFormatting.RED);
            return 0;
        }
        StructureBlockEntity structureblockentity = (StructureBlockEntity)serverlevel.getBlockEntity(blockpos1);
        String s = structureblockentity.getStructurePath();
        return TestCommand.exportTestStructure(pSource, s);
    }

    private static int exportTestStructure(CommandSourceStack pSource, String pStructurePath) {
        Path path = Paths.get(StructureUtils.testStructuresDir, new String[0]);
        ResourceLocation resourcelocation = new ResourceLocation("minecraft", pStructurePath);
        Path path1 = pSource.getLevel().getStructureManager().createPathToStructure(resourcelocation, ".nbt");
        Path path2 = NbtToSnbt.convertStructure(path1, pStructurePath, path);
        if (path2 == null) {
            TestCommand.say(pSource, "Failed to export " + path1);
            return 1;
        }
        try {
            Files.createDirectories(path2.getParent(), new FileAttribute[0]);
        }
        catch (IOException ioexception) {
            TestCommand.say(pSource, "Could not create folder " + path2.getParent());
            ioexception.printStackTrace();
            return 1;
        }
        TestCommand.say(pSource, "Exported " + pStructurePath + " to " + path2.toAbsolutePath());
        return 0;
    }

    private static int importTestStructure(CommandSourceStack pSource, String pStructurePath) {
        Path path = Paths.get(StructureUtils.testStructuresDir, String.valueOf(pStructurePath) + ".snbt");
        ResourceLocation resourcelocation = new ResourceLocation("minecraft", pStructurePath);
        Path path1 = pSource.getLevel().getStructureManager().createPathToStructure(resourcelocation, ".nbt");
        try {
            BufferedReader bufferedreader = Files.newBufferedReader(path);
            String s = IOUtils.toString((Reader)bufferedreader);
            Files.createDirectories(path1.getParent(), new FileAttribute[0]);
            try (OutputStream outputstream = Files.newOutputStream(path1, new OpenOption[0]);){
                NbtIo.writeCompressed(NbtUtils.snbtToStructure(s), outputstream);
            }
            TestCommand.say(pSource, "Imported to " + path1.toAbsolutePath());
            return 0;
        }
        catch (CommandSyntaxException | IOException ioexception) {
            System.err.println("Failed to load structure " + pStructurePath);
            ioexception.printStackTrace();
            return 1;
        }
    }

    private static void say(ServerLevel pServerLevel, String pMessage, ChatFormatting pFormatting) {
        pServerLevel.getPlayers(p_127945_ -> true).forEach(p_127990_ -> p_127990_.sendMessage(new TextComponent((Object)((Object)pFormatting) + pMessage), Util.NIL_UUID));
    }

    static class TestSummaryDisplayer
    implements GameTestListener {
        private final ServerLevel level;
        private final MultipleTestTracker tracker;

        public TestSummaryDisplayer(ServerLevel pServerLevel, MultipleTestTracker pTracker) {
            this.level = pServerLevel;
            this.tracker = pTracker;
        }

        @Override
        public void testStructureLoaded(GameTestInfo pTestInfo) {
        }

        @Override
        public void testPassed(GameTestInfo pTestInfo) {
            TestCommand.showTestSummaryIfAllDone(this.level, this.tracker);
        }

        @Override
        public void testFailed(GameTestInfo pTestInfo) {
            TestCommand.showTestSummaryIfAllDone(this.level, this.tracker);
        }
    }
}

