/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.locale;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringDecomposer;
import org.slf4j.Logger;

public abstract class Language {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new Gson();
    private static final Pattern UNSUPPORTED_FORMAT_PATTERN = Pattern.compile("%(\\d+\\$)?[\\d.]*[df]");
    public static final String DEFAULT = "en_us";
    private static volatile Language instance = Language.loadDefault();

    private static Language loadDefault() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        BiConsumer<String, String> biconsumer = (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1);
        String s = "/assets/minecraft/lang/en_us.json";
        try (InputStream inputstream = Language.class.getResourceAsStream("/assets/minecraft/lang/en_us.json");){
            Language.loadFromJson(inputstream, biconsumer);
        }
        catch (JsonParseException | IOException ioexception) {
            LOGGER.error("Couldn't read strings from {}", (Object)"/assets/minecraft/lang/en_us.json", (Object)ioexception);
        }
        ImmutableMap map = builder.build();
        return new Language((Map)map){
            private final /* synthetic */ Map val$map;
            {
                this.val$map = map;
            }

            @Override
            public String getOrDefault(String p_128127_) {
                return this.val$map.getOrDefault(p_128127_, p_128127_);
            }

            @Override
            public boolean has(String p_128135_) {
                return this.val$map.containsKey(p_128135_);
            }

            @Override
            public boolean isDefaultRightToLeft() {
                return false;
            }

            @Override
            public FormattedCharSequence getVisualOrder(FormattedText p_128129_) {
                return p_128132_ -> p_128129_.visit((p_177835_, p_177836_) -> StringDecomposer.iterateFormatted(p_177836_, p_177835_, p_128132_) ? Optional.empty() : FormattedText.STOP_ITERATION, Style.EMPTY).isPresent();
            }
        };
    }

    public static void loadFromJson(InputStream p_128109_, BiConsumer<String, String> p_128110_) {
        JsonObject jsonobject = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(p_128109_, StandardCharsets.UTF_8), JsonObject.class);
        for (Map.Entry entry : jsonobject.entrySet()) {
            String s = UNSUPPORTED_FORMAT_PATTERN.matcher(GsonHelper.convertToString((JsonElement)entry.getValue(), (String)entry.getKey())).replaceAll("%$1s");
            p_128110_.accept((String)entry.getKey(), s);
        }
    }

    public static Language getInstance() {
        return instance;
    }

    public static void inject(Language p_128115_) {
        instance = p_128115_;
    }

    public abstract String getOrDefault(String var1);

    public abstract boolean has(String var1);

    public abstract boolean isDefaultRightToLeft();

    public abstract FormattedCharSequence getVisualOrder(FormattedText var1);

    public List<FormattedCharSequence> getVisualOrder(List<FormattedText> p_128113_) {
        return (List)p_128113_.stream().map(this::getVisualOrder).collect(ImmutableList.toImmutableList());
    }
}

