/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;

public class ByteArrayTag
extends CollectionTag<ByteTag> {
    private static final int SELF_SIZE_IN_BITS = 192;
    public static final TagType<ByteArrayTag> TYPE = new TagType.VariableSize<ByteArrayTag>(){

        @Override
        public ByteArrayTag load(DataInput p_128247_, int p_128248_, NbtAccounter p_128249_) throws IOException {
            p_128249_.accountBits(192L);
            int i = p_128247_.readInt();
            p_128249_.accountBits(8L * (long)i);
            byte[] abyte = new byte[i];
            p_128247_.readFully(abyte);
            return new ByteArrayTag(abyte);
        }

        @Override
        public StreamTagVisitor.ValueResult parse(DataInput p_197433_, StreamTagVisitor p_197434_) throws IOException {
            int i = p_197433_.readInt();
            byte[] abyte = new byte[i];
            p_197433_.readFully(abyte);
            return p_197434_.a(abyte);
        }

        @Override
        public void skip(DataInput p_197431_) throws IOException {
            p_197431_.skipBytes(p_197431_.readInt() * 1);
        }

        @Override
        public String getName() {
            return "BYTE[]";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Byte_Array";
        }
    };
    private byte[] data;

    public ByteArrayTag(byte[] pDataList) {
        this.data = pDataList;
    }

    public ByteArrayTag(List<Byte> pDataList) {
        this(ByteArrayTag.toArray(pDataList));
    }

    private static byte[] toArray(List<Byte> pDataList) {
        byte[] abyte = new byte[pDataList.size()];
        int i = 0;
        while (i < pDataList.size()) {
            Byte obyte = pDataList.get(i);
            abyte[i] = obyte == null ? (byte)0 : obyte;
            ++i;
        }
        return abyte;
    }

    @Override
    public void write(DataOutput pOutput) throws IOException {
        pOutput.writeInt(this.data.length);
        pOutput.write(this.data);
    }

    @Override
    public byte getId() {
        return 7;
    }

    public TagType<ByteArrayTag> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        return this.getAsString();
    }

    @Override
    public Tag copy() {
        byte[] abyte = new byte[this.data.length];
        System.arraycopy(this.data, 0, abyte, 0, this.data.length);
        return new ByteArrayTag(abyte);
    }

    @Override
    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        return pOther instanceof ByteArrayTag && Arrays.equals(this.data, ((ByteArrayTag)pOther).data);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    public void accept(TagVisitor pVisitor) {
        pVisitor.visitByteArray(this);
    }

    public byte[] getAsByteArray() {
        return this.data;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public ByteTag get(int p_128194_) {
        return ByteTag.valueOf(this.data[p_128194_]);
    }

    @Override
    public ByteTag set(int p_128196_, ByteTag p_128197_) {
        byte b0 = this.data[p_128196_];
        this.data[p_128196_] = p_128197_.getAsByte();
        return ByteTag.valueOf(b0);
    }

    @Override
    public void add(int p_128215_, ByteTag p_128216_) {
        this.data = ArrayUtils.add((byte[])this.data, (int)p_128215_, (byte)p_128216_.getAsByte());
    }

    @Override
    public boolean setTag(int pIndex, Tag pNbt) {
        if (pNbt instanceof NumericTag) {
            this.data[pIndex] = ((NumericTag)pNbt).getAsByte();
            return true;
        }
        return false;
    }

    @Override
    public boolean addTag(int pIndex, Tag pNbt) {
        if (pNbt instanceof NumericTag) {
            this.data = ArrayUtils.add((byte[])this.data, (int)pIndex, (byte)((NumericTag)pNbt).getAsByte());
            return true;
        }
        return false;
    }

    @Override
    public ByteTag remove(int p_128213_) {
        byte b0 = this.data[p_128213_];
        this.data = ArrayUtils.remove((byte[])this.data, (int)p_128213_);
        return ByteTag.valueOf(b0);
    }

    @Override
    public byte getElementType() {
        return 1;
    }

    @Override
    public void clear() {
        this.data = new byte[0];
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor pVisitor) {
        return pVisitor.a(this.data);
    }
}

