/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagTypes;
import net.minecraft.nbt.TagVisitor;

public class CompoundTag
implements Tag {
    public static final Codec<CompoundTag> CODEC = Codec.PASSTHROUGH.comapFlatMap(p_128336_ -> {
        Tag tag = (Tag)p_128336_.convert((DynamicOps)NbtOps.INSTANCE).getValue();
        return tag instanceof CompoundTag ? DataResult.success((Object)((CompoundTag)tag)) : DataResult.error((String)("Not a compound tag: " + tag));
    }, p_128412_ -> new Dynamic((DynamicOps)NbtOps.INSTANCE, p_128412_));
    private static final int SELF_SIZE_IN_BITS = 384;
    private static final int MAP_ENTRY_SIZE_IN_BITS = 256;
    public static final TagType<CompoundTag> TYPE = new TagType.VariableSize<CompoundTag>(){

        @Override
        public CompoundTag load(DataInput p_128485_, int p_128486_, NbtAccounter p_128487_) throws IOException {
            byte b0;
            p_128487_.accountBits(384L);
            if (p_128486_ > 512) {
                throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
            }
            HashMap map = Maps.newHashMap();
            while ((b0 = CompoundTag.readNamedTagType(p_128485_, p_128487_)) != 0) {
                String s = CompoundTag.readNamedTagName(p_128485_, p_128487_);
                p_128487_.accountBits(224 + 16 * s.length());
                Tag tag = CompoundTag.readNamedTagData(TagTypes.getType(b0), s, p_128485_, p_128486_ + 1, p_128487_);
                if (map.put(s, tag) == null) continue;
                p_128487_.accountBits(288L);
            }
            return new CompoundTag(map);
        }

        @Override
        public StreamTagVisitor.ValueResult parse(DataInput p_197446_, StreamTagVisitor p_197447_) throws IOException {
            byte b0;
            block13: while ((b0 = p_197446_.readByte()) != 0) {
                TagType<?> tagtype = TagTypes.getType(b0);
                switch (p_197447_.visitEntry(tagtype)) {
                    case HALT: {
                        return StreamTagVisitor.ValueResult.HALT;
                    }
                    case BREAK: {
                        StringTag.skipString(p_197446_);
                        tagtype.skip(p_197446_);
                        break block13;
                    }
                    case SKIP: {
                        StringTag.skipString(p_197446_);
                        tagtype.skip(p_197446_);
                        continue block13;
                    }
                    default: {
                        String s = p_197446_.readUTF();
                        switch (p_197447_.visitEntry(tagtype, s)) {
                            case HALT: {
                                return StreamTagVisitor.ValueResult.HALT;
                            }
                            case BREAK: {
                                tagtype.skip(p_197446_);
                                break block13;
                            }
                            case SKIP: {
                                tagtype.skip(p_197446_);
                                continue block13;
                            }
                        }
                        switch (tagtype.parse(p_197446_, p_197447_)) {
                            case HALT: {
                                return StreamTagVisitor.ValueResult.HALT;
                            }
                        }
                        continue block13;
                    }
                }
            }
            if (b0 != 0) {
                while ((b0 = p_197446_.readByte()) != 0) {
                    StringTag.skipString(p_197446_);
                    TagTypes.getType(b0).skip(p_197446_);
                }
            }
            return p_197447_.visitContainerEnd();
        }

        @Override
        public void skip(DataInput p_197444_) throws IOException {
            byte b0;
            while ((b0 = p_197444_.readByte()) != 0) {
                StringTag.skipString(p_197444_);
                TagTypes.getType(b0).skip(p_197444_);
            }
        }

        @Override
        public String getName() {
            return "COMPOUND";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Compound";
        }
    };
    private final Map<String, Tag> tags;

    protected CompoundTag(Map<String, Tag> pTags) {
        this.tags = pTags;
    }

    public CompoundTag() {
        this(Maps.newHashMap());
    }

    @Override
    public void write(DataOutput pOutput) throws IOException {
        for (String s : this.tags.keySet()) {
            Tag tag = this.tags.get(s);
            CompoundTag.writeNamedTag(s, tag, pOutput);
        }
        pOutput.writeByte(0);
    }

    public Set<String> getAllKeys() {
        return this.tags.keySet();
    }

    @Override
    public byte getId() {
        return 10;
    }

    public TagType<CompoundTag> getType() {
        return TYPE;
    }

    public int size() {
        return this.tags.size();
    }

    @Nullable
    public Tag put(String pKey, Tag pValue) {
        return this.tags.put(pKey, pValue);
    }

    public void putByte(String pKey, byte pValue) {
        this.tags.put(pKey, ByteTag.valueOf(pValue));
    }

    public void putShort(String pKey, short pValue) {
        this.tags.put(pKey, ShortTag.valueOf(pValue));
    }

    public void putInt(String pKey, int pValue) {
        this.tags.put(pKey, IntTag.valueOf(pValue));
    }

    public void putLong(String pKey, long pValue) {
        this.tags.put(pKey, LongTag.valueOf(pValue));
    }

    public void putUUID(String pKey, UUID pValue) {
        this.tags.put(pKey, NbtUtils.createUUID(pValue));
    }

    public UUID getUUID(String pKey) {
        return NbtUtils.loadUUID(this.get(pKey));
    }

    public boolean hasUUID(String pKey) {
        Tag tag = this.get(pKey);
        return tag != null && tag.getType() == IntArrayTag.TYPE && ((IntArrayTag)tag).getAsIntArray().length == 4;
    }

    public void putFloat(String pKey, float pValue) {
        this.tags.put(pKey, FloatTag.valueOf(pValue));
    }

    public void putDouble(String pKey, double pValue) {
        this.tags.put(pKey, DoubleTag.valueOf(pValue));
    }

    public void putString(String pKey, String pValue) {
        this.tags.put(pKey, StringTag.valueOf(pValue));
    }

    public void a(String p_128383_, byte[] p_128384_) {
        this.tags.put(p_128383_, new ByteArrayTag(p_128384_));
    }

    public void putByteArray(String pKey, List<Byte> pValue) {
        this.tags.put(pKey, new ByteArrayTag(pValue));
    }

    public void a(String p_128386_, int[] p_128387_) {
        this.tags.put(p_128386_, new IntArrayTag(p_128387_));
    }

    public void putIntArray(String pKey, List<Integer> pValue) {
        this.tags.put(pKey, new IntArrayTag(pValue));
    }

    public void a(String p_128389_, long[] p_128390_) {
        this.tags.put(p_128389_, new LongArrayTag(p_128390_));
    }

    public void putLongArray(String pKey, List<Long> pValue) {
        this.tags.put(pKey, new LongArrayTag(pValue));
    }

    public void putBoolean(String pKey, boolean pValue) {
        this.tags.put(pKey, ByteTag.valueOf(pValue));
    }

    @Nullable
    public Tag get(String pKey) {
        return this.tags.get(pKey);
    }

    public byte getTagType(String pKey) {
        Tag tag = this.tags.get(pKey);
        return tag == null ? (byte)0 : tag.getId();
    }

    public boolean contains(String pKey) {
        return this.tags.containsKey(pKey);
    }

    public boolean contains(String pKey, int pTagType) {
        byte i = this.getTagType(pKey);
        if (i == pTagType) {
            return true;
        }
        if (pTagType != 99) {
            return false;
        }
        return i == 1 || i == 2 || i == 3 || i == 4 || i == 5 || i == 6;
    }

    public byte getByte(String pKey) {
        try {
            if (this.contains(pKey, 99)) {
                return ((NumericTag)this.tags.get(pKey)).getAsByte();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public short getShort(String pKey) {
        try {
            if (this.contains(pKey, 99)) {
                return ((NumericTag)this.tags.get(pKey)).getAsShort();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public int getInt(String pKey) {
        try {
            if (this.contains(pKey, 99)) {
                return ((NumericTag)this.tags.get(pKey)).getAsInt();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public long getLong(String pKey) {
        try {
            if (this.contains(pKey, 99)) {
                return ((NumericTag)this.tags.get(pKey)).getAsLong();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0L;
    }

    public float getFloat(String pKey) {
        try {
            if (this.contains(pKey, 99)) {
                return ((NumericTag)this.tags.get(pKey)).getAsFloat();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0f;
    }

    public double getDouble(String pKey) {
        try {
            if (this.contains(pKey, 99)) {
                return ((NumericTag)this.tags.get(pKey)).getAsDouble();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0;
    }

    public String getString(String pKey) {
        try {
            if (this.contains(pKey, 8)) {
                return this.tags.get(pKey).getAsString();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return "";
    }

    public byte[] getByteArray(String pKey) {
        try {
            if (this.contains(pKey, 7)) {
                return ((ByteArrayTag)this.tags.get(pKey)).getAsByteArray();
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.createReport(pKey, ByteArrayTag.TYPE, classcastexception));
        }
        return new byte[0];
    }

    public int[] getIntArray(String pKey) {
        try {
            if (this.contains(pKey, 11)) {
                return ((IntArrayTag)this.tags.get(pKey)).getAsIntArray();
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.createReport(pKey, IntArrayTag.TYPE, classcastexception));
        }
        return new int[0];
    }

    public long[] getLongArray(String pKey) {
        try {
            if (this.contains(pKey, 12)) {
                return ((LongArrayTag)this.tags.get(pKey)).getAsLongArray();
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.createReport(pKey, LongArrayTag.TYPE, classcastexception));
        }
        return new long[0];
    }

    public CompoundTag getCompound(String pKey) {
        try {
            if (this.contains(pKey, 10)) {
                return (CompoundTag)this.tags.get(pKey);
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.createReport(pKey, TYPE, classcastexception));
        }
        return new CompoundTag();
    }

    public ListTag getList(String pKey, int pTagType) {
        try {
            if (this.getTagType(pKey) == 9) {
                ListTag listtag = (ListTag)this.tags.get(pKey);
                if (!listtag.isEmpty() && listtag.getElementType() != pTagType) {
                    return new ListTag();
                }
                return listtag;
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.createReport(pKey, ListTag.TYPE, classcastexception));
        }
        return new ListTag();
    }

    public boolean getBoolean(String pKey) {
        return this.getByte(pKey) != 0;
    }

    public void remove(String pKey) {
        this.tags.remove(pKey);
    }

    @Override
    public String toString() {
        return this.getAsString();
    }

    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    private CrashReport createReport(String pTagName, TagType<?> pType, ClassCastException pException) {
        CrashReport crashreport = CrashReport.forThrowable(pException, "Reading NBT data");
        CrashReportCategory crashreportcategory = crashreport.addCategory("Corrupt NBT tag", 1);
        crashreportcategory.setDetail("Tag type found", () -> this.tags.get(pTagName).getType().getName());
        crashreportcategory.setDetail("Tag type expected", pType::getName);
        crashreportcategory.setDetail("Tag name", pTagName);
        return crashreport;
    }

    @Override
    public CompoundTag copy() {
        HashMap map = Maps.newHashMap((Map)Maps.transformValues(this.tags, Tag::copy));
        return new CompoundTag(map);
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        return pOther instanceof CompoundTag && Objects.equals(this.tags, ((CompoundTag)pOther).tags);
    }

    public int hashCode() {
        return this.tags.hashCode();
    }

    private static void writeNamedTag(String pName, Tag pTag, DataOutput pOutput) throws IOException {
        pOutput.writeByte(pTag.getId());
        if (pTag.getId() != 0) {
            pOutput.writeUTF(pName);
            pTag.write(pOutput);
        }
    }

    static byte readNamedTagType(DataInput pInput, NbtAccounter pAccounter) throws IOException {
        return pInput.readByte();
    }

    static String readNamedTagName(DataInput pInput, NbtAccounter pAccounter) throws IOException {
        return pInput.readUTF();
    }

    static Tag readNamedTagData(TagType<?> pType, String pName, DataInput pInput, int pDepth, NbtAccounter pAccounter) {
        try {
            return pType.load(pInput, pDepth, pAccounter);
        }
        catch (IOException ioexception) {
            CrashReport crashreport = CrashReport.forThrowable(ioexception, "Loading NBT data");
            CrashReportCategory crashreportcategory = crashreport.addCategory("NBT Tag");
            crashreportcategory.setDetail("Tag name", pName);
            crashreportcategory.setDetail("Tag type", pType.getName());
            throw new ReportedException(crashreport);
        }
    }

    public CompoundTag merge(CompoundTag pOther) {
        for (String s : pOther.tags.keySet()) {
            Tag tag = pOther.tags.get(s);
            if (tag.getId() == 10) {
                if (this.contains(s, 10)) {
                    CompoundTag compoundtag = this.getCompound(s);
                    compoundtag.merge((CompoundTag)tag);
                    continue;
                }
                this.put(s, tag.copy());
                continue;
            }
            this.put(s, tag.copy());
        }
        return this;
    }

    @Override
    public void accept(TagVisitor pVisitor) {
        pVisitor.visitCompound(this);
    }

    protected Map<String, Tag> entries() {
        return Collections.unmodifiableMap(this.tags);
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor pVisitor) {
        for (Map.Entry<String, Tag> entry : this.tags.entrySet()) {
            Tag tag = entry.getValue();
            TagType<?> tagtype = tag.getType();
            StreamTagVisitor.EntryResult streamtagvisitor$entryresult = pVisitor.visitEntry(tagtype);
            block0 : switch (streamtagvisitor$entryresult) {
                case HALT: {
                    return StreamTagVisitor.ValueResult.HALT;
                }
                case BREAK: {
                    return pVisitor.visitContainerEnd();
                }
                case SKIP: {
                    break;
                }
                default: {
                    streamtagvisitor$entryresult = pVisitor.visitEntry(tagtype, entry.getKey());
                    switch (streamtagvisitor$entryresult) {
                        case HALT: {
                            return StreamTagVisitor.ValueResult.HALT;
                        }
                        case BREAK: {
                            return pVisitor.visitContainerEnd();
                        }
                        case SKIP: {
                            break block0;
                        }
                    }
                    StreamTagVisitor.ValueResult streamtagvisitor$valueresult = tag.accept(pVisitor);
                    switch (streamtagvisitor$valueresult) {
                        case HALT: {
                            return StreamTagVisitor.ValueResult.HALT;
                        }
                        case BREAK: {
                            return pVisitor.visitContainerEnd();
                        }
                    }
                }
            }
        }
        return pVisitor.visitContainerEnd();
    }
}

