/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;

public class IntArrayTag
extends CollectionTag<IntTag> {
    private static final int SELF_SIZE_IN_BITS = 192;
    public static final TagType<IntArrayTag> TYPE = new TagType.VariableSize<IntArrayTag>(){

        @Override
        public IntArrayTag load(DataInput p_128662_, int p_128663_, NbtAccounter p_128664_) throws IOException {
            p_128664_.accountBits(192L);
            int i = p_128662_.readInt();
            p_128664_.accountBits(32L * (long)i);
            int[] aint = new int[i];
            int j = 0;
            while (j < i) {
                aint[j] = p_128662_.readInt();
                ++j;
            }
            return new IntArrayTag(aint);
        }

        @Override
        public StreamTagVisitor.ValueResult parse(DataInput p_197478_, StreamTagVisitor p_197479_) throws IOException {
            int i = p_197478_.readInt();
            int[] aint = new int[i];
            int j = 0;
            while (j < i) {
                aint[j] = p_197478_.readInt();
                ++j;
            }
            return p_197479_.a(aint);
        }

        @Override
        public void skip(DataInput p_197476_) throws IOException {
            p_197476_.skipBytes(p_197476_.readInt() * 4);
        }

        @Override
        public String getName() {
            return "INT[]";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Int_Array";
        }
    };
    private int[] data;

    public IntArrayTag(int[] pDataList) {
        this.data = pDataList;
    }

    public IntArrayTag(List<Integer> pDataList) {
        this(IntArrayTag.toArray(pDataList));
    }

    private static int[] toArray(List<Integer> pDataList) {
        int[] aint = new int[pDataList.size()];
        int i = 0;
        while (i < pDataList.size()) {
            Integer integer = pDataList.get(i);
            aint[i] = integer == null ? 0 : integer;
            ++i;
        }
        return aint;
    }

    @Override
    public void write(DataOutput pOutput) throws IOException {
        pOutput.writeInt(this.data.length);
        int[] nArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            pOutput.writeInt(i);
            ++n2;
        }
    }

    @Override
    public byte getId() {
        return 11;
    }

    public TagType<IntArrayTag> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        return this.getAsString();
    }

    @Override
    public IntArrayTag copy() {
        int[] aint = new int[this.data.length];
        System.arraycopy(this.data, 0, aint, 0, this.data.length);
        return new IntArrayTag(aint);
    }

    @Override
    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        return pOther instanceof IntArrayTag && Arrays.equals(this.data, ((IntArrayTag)pOther).data);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public int[] getAsIntArray() {
        return this.data;
    }

    @Override
    public void accept(TagVisitor pVisitor) {
        pVisitor.visitIntArray(this);
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public IntTag get(int p_128608_) {
        return IntTag.valueOf(this.data[p_128608_]);
    }

    @Override
    public IntTag set(int p_128610_, IntTag p_128611_) {
        int i = this.data[p_128610_];
        this.data[p_128610_] = p_128611_.getAsInt();
        return IntTag.valueOf(i);
    }

    @Override
    public void add(int p_128629_, IntTag p_128630_) {
        this.data = ArrayUtils.add((int[])this.data, (int)p_128629_, (int)p_128630_.getAsInt());
    }

    @Override
    public boolean setTag(int pIndex, Tag pNbt) {
        if (pNbt instanceof NumericTag) {
            this.data[pIndex] = ((NumericTag)pNbt).getAsInt();
            return true;
        }
        return false;
    }

    @Override
    public boolean addTag(int pIndex, Tag pNbt) {
        if (pNbt instanceof NumericTag) {
            this.data = ArrayUtils.add((int[])this.data, (int)pIndex, (int)((NumericTag)pNbt).getAsInt());
            return true;
        }
        return false;
    }

    @Override
    public IntTag remove(int p_128627_) {
        int i = this.data[p_128627_];
        this.data = ArrayUtils.remove((int[])this.data, (int)p_128627_);
        return IntTag.valueOf(i);
    }

    @Override
    public byte getElementType() {
        return 3;
    }

    @Override
    public void clear() {
        this.data = new int[0];
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor pVisitor) {
        return pVisitor.a(this.data);
    }
}

