/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagTypes;
import net.minecraft.nbt.TagVisitor;

public class ListTag
extends CollectionTag<Tag> {
    private static final int SELF_SIZE_IN_BITS = 296;
    public static final TagType<ListTag> TYPE = new TagType.VariableSize<ListTag>(){

        @Override
        public ListTag load(DataInput p_128792_, int p_128793_, NbtAccounter p_128794_) throws IOException {
            p_128794_.accountBits(296L);
            if (p_128793_ > 512) {
                throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
            }
            byte b0 = p_128792_.readByte();
            int i = p_128792_.readInt();
            if (b0 == 0 && i > 0) {
                throw new RuntimeException("Missing type on ListTag");
            }
            p_128794_.accountBits(32L * (long)i);
            TagType<?> tagtype = TagTypes.getType(b0);
            ArrayList list = Lists.newArrayListWithCapacity((int)i);
            int j = 0;
            while (j < i) {
                list.add(tagtype.load(p_128792_, p_128793_ + 1, p_128794_));
                ++j;
            }
            return new ListTag(list, b0);
        }

        @Override
        public StreamTagVisitor.ValueResult parse(DataInput p_197491_, StreamTagVisitor p_197492_) throws IOException {
            TagType<?> tagtype = TagTypes.getType(p_197491_.readByte());
            int i = p_197491_.readInt();
            switch (p_197492_.visitList(tagtype, i)) {
                case HALT: {
                    return StreamTagVisitor.ValueResult.HALT;
                }
                case BREAK: {
                    tagtype.skip(p_197491_, i);
                    return p_197492_.visitContainerEnd();
                }
            }
            int j = 0;
            while (true) {
                block16: {
                    int k;
                    block15: {
                        if (j >= i) break block15;
                        block4 : switch (p_197492_.visitElement(tagtype, j)) {
                            case HALT: {
                                return StreamTagVisitor.ValueResult.HALT;
                            }
                            case BREAK: {
                                tagtype.skip(p_197491_);
                                break;
                            }
                            case SKIP: {
                                tagtype.skip(p_197491_);
                                break block16;
                            }
                            default: {
                                switch (tagtype.parse(p_197491_, p_197492_)) {
                                    case HALT: {
                                        return StreamTagVisitor.ValueResult.HALT;
                                    }
                                    case BREAK: {
                                        break block4;
                                    }
                                }
                                break block16;
                            }
                        }
                    }
                    if ((k = i - 1 - j) > 0) {
                        tagtype.skip(p_197491_, k);
                    }
                    return p_197492_.visitContainerEnd();
                }
                ++j;
            }
        }

        @Override
        public void skip(DataInput p_197489_) throws IOException {
            TagType<?> tagtype = TagTypes.getType(p_197489_.readByte());
            int i = p_197489_.readInt();
            tagtype.skip(p_197489_, i);
        }

        @Override
        public String getName() {
            return "LIST";
        }

        @Override
        public String getPrettyName() {
            return "TAG_List";
        }
    };
    private final List<Tag> list;
    private byte type;

    ListTag(List<Tag> pList, byte pType) {
        this.list = pList;
        this.type = pType;
    }

    public ListTag() {
        this(Lists.newArrayList(), 0);
    }

    @Override
    public void write(DataOutput pOutput) throws IOException {
        this.type = this.list.isEmpty() ? (byte)0 : this.list.get(0).getId();
        pOutput.writeByte(this.type);
        pOutput.writeInt(this.list.size());
        for (Tag tag : this.list) {
            tag.write(pOutput);
        }
    }

    @Override
    public byte getId() {
        return 9;
    }

    public TagType<ListTag> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        return this.getAsString();
    }

    private void updateTypeAfterRemove() {
        if (this.list.isEmpty()) {
            this.type = 0;
        }
    }

    @Override
    public Tag remove(int p_128751_) {
        Tag tag = this.list.remove(p_128751_);
        this.updateTypeAfterRemove();
        return tag;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public CompoundTag getCompound(int pIndex) {
        Tag tag;
        if (pIndex >= 0 && pIndex < this.list.size() && (tag = this.list.get(pIndex)).getId() == 10) {
            return (CompoundTag)tag;
        }
        return new CompoundTag();
    }

    public ListTag getList(int pIndex) {
        Tag tag;
        if (pIndex >= 0 && pIndex < this.list.size() && (tag = this.list.get(pIndex)).getId() == 9) {
            return (ListTag)tag;
        }
        return new ListTag();
    }

    public short getShort(int pIndex) {
        Tag tag;
        if (pIndex >= 0 && pIndex < this.list.size() && (tag = this.list.get(pIndex)).getId() == 2) {
            return ((ShortTag)tag).getAsShort();
        }
        return 0;
    }

    public int getInt(int pIndex) {
        Tag tag;
        if (pIndex >= 0 && pIndex < this.list.size() && (tag = this.list.get(pIndex)).getId() == 3) {
            return ((IntTag)tag).getAsInt();
        }
        return 0;
    }

    public int[] getIntArray(int pIndex) {
        Tag tag;
        if (pIndex >= 0 && pIndex < this.list.size() && (tag = this.list.get(pIndex)).getId() == 11) {
            return ((IntArrayTag)tag).getAsIntArray();
        }
        return new int[0];
    }

    public long[] getLongArray(int pIndex) {
        Tag tag;
        if (pIndex >= 0 && pIndex < this.list.size() && (tag = this.list.get(pIndex)).getId() == 11) {
            return ((LongArrayTag)tag).getAsLongArray();
        }
        return new long[0];
    }

    public double getDouble(int pIndex) {
        Tag tag;
        if (pIndex >= 0 && pIndex < this.list.size() && (tag = this.list.get(pIndex)).getId() == 6) {
            return ((DoubleTag)tag).getAsDouble();
        }
        return 0.0;
    }

    public float getFloat(int pIndex) {
        Tag tag;
        if (pIndex >= 0 && pIndex < this.list.size() && (tag = this.list.get(pIndex)).getId() == 5) {
            return ((FloatTag)tag).getAsFloat();
        }
        return 0.0f;
    }

    public String getString(int pIndex) {
        if (pIndex >= 0 && pIndex < this.list.size()) {
            Tag tag = this.list.get(pIndex);
            return tag.getId() == 8 ? tag.getAsString() : tag.toString();
        }
        return "";
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Tag get(int p_128781_) {
        return this.list.get(p_128781_);
    }

    @Override
    public Tag set(int p_128760_, Tag p_128761_) {
        Tag tag = this.get(p_128760_);
        if (!this.setTag(p_128760_, p_128761_)) {
            throw new UnsupportedOperationException(String.format("Trying to add tag of type %d to list of %d", p_128761_.getId(), this.type));
        }
        return tag;
    }

    @Override
    public void add(int p_128753_, Tag p_128754_) {
        if (!this.addTag(p_128753_, p_128754_)) {
            throw new UnsupportedOperationException(String.format("Trying to add tag of type %d to list of %d", p_128754_.getId(), this.type));
        }
    }

    @Override
    public boolean setTag(int pIndex, Tag pNbt) {
        if (this.updateType(pNbt)) {
            this.list.set(pIndex, pNbt);
            return true;
        }
        return false;
    }

    @Override
    public boolean addTag(int pIndex, Tag pNbt) {
        if (this.updateType(pNbt)) {
            this.list.add(pIndex, pNbt);
            return true;
        }
        return false;
    }

    private boolean updateType(Tag pTag) {
        if (pTag.getId() == 0) {
            return false;
        }
        if (this.type == 0) {
            this.type = pTag.getId();
            return true;
        }
        return this.type == pTag.getId();
    }

    @Override
    public ListTag copy() {
        List<Tag> iterable = TagTypes.getType(this.type).isValue() ? this.list : Iterables.transform(this.list, Tag::copy);
        ArrayList list = Lists.newArrayList(iterable);
        return new ListTag(list, this.type);
    }

    @Override
    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        return pOther instanceof ListTag && Objects.equals(this.list, ((ListTag)pOther).list);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public void accept(TagVisitor pVisitor) {
        pVisitor.visitList(this);
    }

    @Override
    public byte getElementType() {
        return this.type;
    }

    @Override
    public void clear() {
        this.list.clear();
        this.type = 0;
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor pVisitor) {
        switch (pVisitor.visitList(TagTypes.getType(this.type), this.list.size())) {
            case HALT: {
                return StreamTagVisitor.ValueResult.HALT;
            }
            case BREAK: {
                return pVisitor.visitContainerEnd();
            }
        }
        int i = 0;
        while (i < this.list.size()) {
            Tag tag = this.list.get(i);
            switch (pVisitor.visitElement(tag.getType(), i)) {
                case HALT: {
                    return StreamTagVisitor.ValueResult.HALT;
                }
                case BREAK: {
                    return pVisitor.visitContainerEnd();
                }
                default: {
                    switch (tag.accept(pVisitor)) {
                        case HALT: {
                            return StreamTagVisitor.ValueResult.HALT;
                        }
                        case BREAK: {
                            return pVisitor.visitContainerEnd();
                        }
                    }
                }
                case SKIP: 
            }
            ++i;
        }
        return pVisitor.visitContainerEnd();
    }
}

