/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;

public class LongArrayTag
extends CollectionTag<LongTag> {
    private static final int SELF_SIZE_IN_BITS = 192;
    public static final TagType<LongArrayTag> TYPE = new TagType.VariableSize<LongArrayTag>(){

        @Override
        public LongArrayTag load(DataInput p_128865_, int p_128866_, NbtAccounter p_128867_) throws IOException {
            p_128867_.accountBits(192L);
            int i = p_128865_.readInt();
            p_128867_.accountBits(64L * (long)i);
            long[] along = new long[i];
            int j = 0;
            while (j < i) {
                along[j] = p_128865_.readLong();
                ++j;
            }
            return new LongArrayTag(along);
        }

        @Override
        public StreamTagVisitor.ValueResult parse(DataInput p_197501_, StreamTagVisitor p_197502_) throws IOException {
            int i = p_197501_.readInt();
            long[] along = new long[i];
            int j = 0;
            while (j < i) {
                along[j] = p_197501_.readLong();
                ++j;
            }
            return p_197502_.a(along);
        }

        @Override
        public void skip(DataInput p_197499_) throws IOException {
            p_197499_.skipBytes(p_197499_.readInt() * 8);
        }

        @Override
        public String getName() {
            return "LONG[]";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Long_Array";
        }
    };
    private long[] data;

    public LongArrayTag(long[] pDataSet) {
        this.data = pDataSet;
    }

    public LongArrayTag(LongSet pDataSet) {
        this.data = pDataSet.toLongArray();
    }

    public LongArrayTag(List<Long> pDataSet) {
        this(LongArrayTag.toArray(pDataSet));
    }

    private static long[] toArray(List<Long> pDataList) {
        long[] along = new long[pDataList.size()];
        int i = 0;
        while (i < pDataList.size()) {
            Long olong = pDataList.get(i);
            along[i] = olong == null ? 0L : olong;
            ++i;
        }
        return along;
    }

    @Override
    public void write(DataOutput pOutput) throws IOException {
        pOutput.writeInt(this.data.length);
        long[] lArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            long i = lArray[n2];
            pOutput.writeLong(i);
            ++n2;
        }
    }

    @Override
    public byte getId() {
        return 12;
    }

    public TagType<LongArrayTag> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        return this.getAsString();
    }

    @Override
    public LongArrayTag copy() {
        long[] along = new long[this.data.length];
        System.arraycopy(this.data, 0, along, 0, this.data.length);
        return new LongArrayTag(along);
    }

    @Override
    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        return pOther instanceof LongArrayTag && Arrays.equals(this.data, ((LongArrayTag)pOther).data);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    public void accept(TagVisitor pVisitor) {
        pVisitor.visitLongArray(this);
    }

    public long[] getAsLongArray() {
        return this.data;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public LongTag get(int p_128811_) {
        return LongTag.valueOf(this.data[p_128811_]);
    }

    @Override
    public LongTag set(int p_128813_, LongTag p_128814_) {
        long i = this.data[p_128813_];
        this.data[p_128813_] = p_128814_.getAsLong();
        return LongTag.valueOf(i);
    }

    @Override
    public void add(int p_128832_, LongTag p_128833_) {
        this.data = ArrayUtils.add((long[])this.data, (int)p_128832_, (long)p_128833_.getAsLong());
    }

    @Override
    public boolean setTag(int pIndex, Tag pNbt) {
        if (pNbt instanceof NumericTag) {
            this.data[pIndex] = ((NumericTag)pNbt).getAsLong();
            return true;
        }
        return false;
    }

    @Override
    public boolean addTag(int pIndex, Tag pNbt) {
        if (pNbt instanceof NumericTag) {
            this.data = ArrayUtils.add((long[])this.data, (int)pIndex, (long)((NumericTag)pNbt).getAsLong());
            return true;
        }
        return false;
    }

    @Override
    public LongTag remove(int p_128830_) {
        long i = this.data[p_128830_];
        this.data = ArrayUtils.remove((long[])this.data, (int)p_128830_);
        return LongTag.valueOf(i);
    }

    @Override
    public byte getElementType() {
        return 4;
    }

    @Override
    public void clear() {
        this.data = new long[0];
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor pVisitor) {
        return pVisitor.a(this.data);
    }
}

