/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagTypes;
import net.minecraft.util.FastBufferedInputStream;

public class NbtIo {
    public static CompoundTag readCompressed(File pFile) throws IOException {
        CompoundTag compoundtag;
        try (FileInputStream inputstream = new FileInputStream(pFile);){
            compoundtag = NbtIo.readCompressed(inputstream);
        }
        return compoundtag;
    }

    private static DataInputStream createDecompressorStream(InputStream p_202494_) throws IOException {
        return new DataInputStream(new FastBufferedInputStream(new GZIPInputStream(p_202494_)));
    }

    public static CompoundTag readCompressed(InputStream pFile) throws IOException {
        CompoundTag compoundtag;
        try (DataInputStream datainputstream = NbtIo.createDecompressorStream(pFile);){
            compoundtag = NbtIo.read(datainputstream, NbtAccounter.UNLIMITED);
        }
        return compoundtag;
    }

    public static void parseCompressed(File p_202488_, StreamTagVisitor p_202489_) throws IOException {
        try (FileInputStream inputstream = new FileInputStream(p_202488_);){
            NbtIo.parseCompressed(inputstream, p_202489_);
        }
    }

    public static void parseCompressed(InputStream p_202491_, StreamTagVisitor p_202492_) throws IOException {
        try (DataInputStream datainputstream = NbtIo.createDecompressorStream(p_202491_);){
            NbtIo.parse(datainputstream, p_202492_);
        }
    }

    public static void writeCompressed(CompoundTag pCompoundTag, File pFile) throws IOException {
        try (FileOutputStream outputstream = new FileOutputStream(pFile);){
            NbtIo.writeCompressed(pCompoundTag, outputstream);
        }
    }

    public static void writeCompressed(CompoundTag pCompoundTag, OutputStream pFile) throws IOException {
        try (DataOutputStream dataoutputstream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(pFile)));){
            NbtIo.write(pCompoundTag, dataoutputstream);
        }
    }

    public static void write(CompoundTag pCompoundTag, File pOutput) throws IOException {
        try (FileOutputStream fileoutputstream = new FileOutputStream(pOutput);
             DataOutputStream dataoutputstream = new DataOutputStream(fileoutputstream);){
            NbtIo.write(pCompoundTag, dataoutputstream);
        }
    }

    @Nullable
    public static CompoundTag read(File pInput) throws IOException {
        CompoundTag compoundtag;
        if (!pInput.exists()) {
            return null;
        }
        try (FileInputStream fileinputstream = new FileInputStream(pInput);
             DataInputStream datainputstream = new DataInputStream(fileinputstream);){
            compoundtag = NbtIo.read(datainputstream, NbtAccounter.UNLIMITED);
        }
        return compoundtag;
    }

    public static CompoundTag read(DataInput pInput) throws IOException {
        return NbtIo.read(pInput, NbtAccounter.UNLIMITED);
    }

    public static CompoundTag read(DataInput pInput, NbtAccounter pAccounter) throws IOException {
        Tag tag = NbtIo.readUnnamedTag(pInput, 0, pAccounter);
        if (tag instanceof CompoundTag) {
            return (CompoundTag)tag;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void write(CompoundTag pCompoundTag, DataOutput pOutput) throws IOException {
        NbtIo.writeUnnamedTag(pCompoundTag, pOutput);
    }

    public static void parse(DataInput p_197510_, StreamTagVisitor p_197511_) throws IOException {
        TagType<?> tagtype = TagTypes.getType(p_197510_.readByte());
        if (tagtype == EndTag.TYPE) {
            if (p_197511_.visitRootEntry(EndTag.TYPE) == StreamTagVisitor.ValueResult.CONTINUE) {
                p_197511_.visitEnd();
            }
        } else {
            switch (p_197511_.visitRootEntry(tagtype)) {
                default: {
                    break;
                }
                case BREAK: {
                    StringTag.skipString(p_197510_);
                    tagtype.skip(p_197510_);
                    break;
                }
                case CONTINUE: {
                    StringTag.skipString(p_197510_);
                    tagtype.parse(p_197510_, p_197511_);
                }
            }
        }
    }

    public static void writeUnnamedTag(Tag pTag, DataOutput pOutput) throws IOException {
        pOutput.writeByte(pTag.getId());
        if (pTag.getId() != 0) {
            pOutput.writeUTF("");
            pTag.write(pOutput);
        }
    }

    private static Tag readUnnamedTag(DataInput pInput, int pDepth, NbtAccounter pAccounter) throws IOException {
        byte b0 = pInput.readByte();
        if (b0 == 0) {
            return EndTag.INSTANCE;
        }
        StringTag.skipString(pInput);
        try {
            return TagTypes.getType(b0).load(pInput, pDepth, pAccounter);
        }
        catch (IOException ioexception) {
            CrashReport crashreport = CrashReport.forThrowable(ioexception, "Loading NBT data");
            CrashReportCategory crashreportcategory = crashreport.addCategory("NBT Tag");
            crashreportcategory.setDetail("Tag type", b0);
            throw new ReportedException(crashreport);
        }
    }
}

