/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.PeekingIterator;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class NbtOps
implements DynamicOps<Tag> {
    public static final NbtOps INSTANCE = new NbtOps();

    protected NbtOps() {
    }

    public Tag empty() {
        return EndTag.INSTANCE;
    }

    public <U> U convertTo(DynamicOps<U> p_128980_, Tag p_128981_) {
        switch (p_128981_.getId()) {
            case 0: {
                return (U)p_128980_.empty();
            }
            case 1: {
                return (U)p_128980_.createByte(((NumericTag)p_128981_).getAsByte());
            }
            case 2: {
                return (U)p_128980_.createShort(((NumericTag)p_128981_).getAsShort());
            }
            case 3: {
                return (U)p_128980_.createInt(((NumericTag)p_128981_).getAsInt());
            }
            case 4: {
                return (U)p_128980_.createLong(((NumericTag)p_128981_).getAsLong());
            }
            case 5: {
                return (U)p_128980_.createFloat(((NumericTag)p_128981_).getAsFloat());
            }
            case 6: {
                return (U)p_128980_.createDouble(((NumericTag)p_128981_).getAsDouble());
            }
            case 7: {
                return (U)p_128980_.createByteList(ByteBuffer.wrap(((ByteArrayTag)p_128981_).getAsByteArray()));
            }
            case 8: {
                return (U)p_128980_.createString(p_128981_.getAsString());
            }
            case 9: {
                return (U)this.convertList(p_128980_, p_128981_);
            }
            case 10: {
                return (U)this.convertMap(p_128980_, p_128981_);
            }
            case 11: {
                return (U)p_128980_.createIntList(Arrays.stream(((IntArrayTag)p_128981_).getAsIntArray()));
            }
            case 12: {
                return (U)p_128980_.createLongList(Arrays.stream(((LongArrayTag)p_128981_).getAsLongArray()));
            }
        }
        throw new IllegalStateException("Unknown tag type: " + p_128981_);
    }

    public DataResult<Number> getNumberValue(Tag p_129030_) {
        return p_129030_ instanceof NumericTag ? DataResult.success((Object)((NumericTag)p_129030_).getAsNumber()) : DataResult.error((String)"Not a number");
    }

    public Tag createNumeric(Number p_128983_) {
        return DoubleTag.valueOf(p_128983_.doubleValue());
    }

    public Tag createByte(byte p_128963_) {
        return ByteTag.valueOf(p_128963_);
    }

    public Tag createShort(short p_129048_) {
        return ShortTag.valueOf(p_129048_);
    }

    public Tag createInt(int p_128976_) {
        return IntTag.valueOf(p_128976_);
    }

    public Tag createLong(long p_128978_) {
        return LongTag.valueOf(p_128978_);
    }

    public Tag createFloat(float p_128974_) {
        return FloatTag.valueOf(p_128974_);
    }

    public Tag createDouble(double p_128972_) {
        return DoubleTag.valueOf(p_128972_);
    }

    public Tag createBoolean(boolean p_129050_) {
        return ByteTag.valueOf(p_129050_);
    }

    public DataResult<String> getStringValue(Tag p_129061_) {
        return p_129061_ instanceof StringTag ? DataResult.success((Object)p_129061_.getAsString()) : DataResult.error((String)"Not a string");
    }

    public Tag createString(String p_128985_) {
        return StringTag.valueOf(p_128985_);
    }

    private static CollectionTag<?> createGenericList(byte pCollectionElementId, byte pNewElementId) {
        if (NbtOps.typesMatch(pCollectionElementId, pNewElementId, (byte)4)) {
            return new LongArrayTag(new long[0]);
        }
        if (NbtOps.typesMatch(pCollectionElementId, pNewElementId, (byte)1)) {
            return new ByteArrayTag(new byte[0]);
        }
        return NbtOps.typesMatch(pCollectionElementId, pNewElementId, (byte)3) ? new IntArrayTag(new int[0]) : new ListTag();
    }

    private static boolean typesMatch(byte pCollectionElementId, byte pNewElementId, byte pNewCollectionElementId) {
        return pCollectionElementId == pNewCollectionElementId && (pNewElementId == pNewCollectionElementId || pNewElementId == 0);
    }

    private static <T extends Tag> void fillOne(CollectionTag<T> pCollectionTag, Tag pMergingCollectionTag, Tag pElementTag) {
        if (pMergingCollectionTag instanceof CollectionTag) {
            CollectionTag collectiontag = (CollectionTag)pMergingCollectionTag;
            collectiontag.forEach(p_129064_ -> pCollectionTag.add(p_129064_));
        }
        pCollectionTag.add(pElementTag);
    }

    private static <T extends Tag> void fillMany(CollectionTag<T> pCollectionTag, Tag pMergingCollectionTag, List<Tag> pElementTags) {
        if (pMergingCollectionTag instanceof CollectionTag) {
            CollectionTag collectiontag = (CollectionTag)pMergingCollectionTag;
            collectiontag.forEach(p_129055_ -> pCollectionTag.add(p_129055_));
        }
        pElementTags.forEach(p_129007_ -> pCollectionTag.add(p_129007_));
    }

    public DataResult<Tag> mergeToList(Tag p_129041_, Tag p_129042_) {
        if (!(p_129041_ instanceof CollectionTag) && !(p_129041_ instanceof EndTag)) {
            return DataResult.error((String)("mergeToList called with not a list: " + p_129041_), (Object)p_129041_);
        }
        CollectionTag<?> collectiontag = NbtOps.createGenericList(p_129041_ instanceof CollectionTag ? ((CollectionTag)p_129041_).getElementType() : (byte)0, p_129042_.getId());
        NbtOps.fillOne(collectiontag, p_129041_, p_129042_);
        return DataResult.success(collectiontag);
    }

    public DataResult<Tag> mergeToList(Tag p_129038_, List<Tag> p_129039_) {
        if (!(p_129038_ instanceof CollectionTag) && !(p_129038_ instanceof EndTag)) {
            return DataResult.error((String)("mergeToList called with not a list: " + p_129038_), (Object)p_129038_);
        }
        CollectionTag<?> collectiontag = NbtOps.createGenericList(p_129038_ instanceof CollectionTag ? ((CollectionTag)p_129038_).getElementType() : (byte)0, p_129039_.stream().findFirst().map(Tag::getId).orElse((byte)0));
        NbtOps.fillMany(collectiontag, p_129038_, p_129039_);
        return DataResult.success(collectiontag);
    }

    public DataResult<Tag> mergeToMap(Tag p_129044_, Tag p_129045_, Tag p_129046_) {
        if (!(p_129044_ instanceof CompoundTag) && !(p_129044_ instanceof EndTag)) {
            return DataResult.error((String)("mergeToMap called with not a map: " + p_129044_), (Object)p_129044_);
        }
        if (!(p_129045_ instanceof StringTag)) {
            return DataResult.error((String)("key is not a string: " + p_129045_), (Object)p_129044_);
        }
        CompoundTag compoundtag = new CompoundTag();
        if (p_129044_ instanceof CompoundTag) {
            CompoundTag compoundtag1 = (CompoundTag)p_129044_;
            compoundtag1.getAllKeys().forEach(p_129068_ -> compoundtag.put((String)p_129068_, compoundtag1.get((String)p_129068_)));
        }
        compoundtag.put(p_129045_.getAsString(), p_129046_);
        return DataResult.success((Object)compoundtag);
    }

    public DataResult<Tag> mergeToMap(Tag p_129032_, MapLike<Tag> p_129033_) {
        if (!(p_129032_ instanceof CompoundTag) && !(p_129032_ instanceof EndTag)) {
            return DataResult.error((String)("mergeToMap called with not a map: " + p_129032_), (Object)p_129032_);
        }
        CompoundTag compoundtag = new CompoundTag();
        if (p_129032_ instanceof CompoundTag) {
            CompoundTag compoundtag1 = (CompoundTag)p_129032_;
            compoundtag1.getAllKeys().forEach(p_129059_ -> compoundtag.put((String)p_129059_, compoundtag1.get((String)p_129059_)));
        }
        ArrayList list = Lists.newArrayList();
        p_129033_.entries().forEach(p_128994_ -> {
            Tag tag = (Tag)p_128994_.getFirst();
            if (!(tag instanceof StringTag)) {
                list.add(tag);
            } else {
                compoundtag.put(tag.getAsString(), (Tag)p_128994_.getSecond());
            }
        });
        return !list.isEmpty() ? DataResult.error((String)("some keys are not strings: " + list), (Object)compoundtag) : DataResult.success((Object)compoundtag);
    }

    public DataResult<Stream<Pair<Tag, Tag>>> getMapValues(Tag p_129070_) {
        if (!(p_129070_ instanceof CompoundTag)) {
            return DataResult.error((String)("Not a map: " + p_129070_));
        }
        CompoundTag compoundtag = (CompoundTag)p_129070_;
        return DataResult.success(compoundtag.getAllKeys().stream().map(p_129021_ -> Pair.of((Object)this.createString((String)p_129021_), (Object)compoundtag.get((String)p_129021_))));
    }

    public DataResult<Consumer<BiConsumer<Tag, Tag>>> getMapEntries(Tag p_129103_) {
        if (!(p_129103_ instanceof CompoundTag)) {
            return DataResult.error((String)("Not a map: " + p_129103_));
        }
        CompoundTag compoundtag = (CompoundTag)p_129103_;
        return DataResult.success(p_129024_ -> compoundtag.getAllKeys().forEach(p_178006_ -> p_129024_.accept(this.createString((String)p_178006_), compoundtag.get((String)p_178006_))));
    }

    public DataResult<MapLike<Tag>> getMap(Tag p_129105_) {
        if (!(p_129105_ instanceof CompoundTag)) {
            return DataResult.error((String)("Not a map: " + p_129105_));
        }
        CompoundTag compoundtag = (CompoundTag)p_129105_;
        return DataResult.success((Object)new MapLike<Tag>(){

            @Nullable
            public Tag get(Tag p_129174_) {
                return compoundtag.get(p_129174_.getAsString());
            }

            @Nullable
            public Tag get(String p_129169_) {
                return compoundtag.get(p_129169_);
            }

            public Stream<Pair<Tag, Tag>> entries() {
                return compoundtag.getAllKeys().stream().map(p_129172_ -> Pair.of((Object)NbtOps.this.createString((String)p_129172_), (Object)compoundtag.get((String)p_129172_)));
            }

            public String toString() {
                return "MapLike[" + compoundtag + "]";
            }
        });
    }

    public Tag createMap(Stream<Pair<Tag, Tag>> p_129004_) {
        CompoundTag compoundtag = new CompoundTag();
        p_129004_.forEach(p_129018_ -> compoundtag.put(((Tag)p_129018_.getFirst()).getAsString(), (Tag)p_129018_.getSecond()));
        return compoundtag;
    }

    public DataResult<Stream<Tag>> getStream(Tag p_129108_) {
        return p_129108_ instanceof CollectionTag ? DataResult.success(((CollectionTag)p_129108_).stream().map(p_129158_ -> p_129158_)) : DataResult.error((String)"Not a list");
    }

    public DataResult<Consumer<Consumer<Tag>>> getList(Tag p_129110_) {
        if (p_129110_ instanceof CollectionTag) {
            CollectionTag collectiontag = (CollectionTag)p_129110_;
            return DataResult.success(collectiontag::forEach);
        }
        return DataResult.error((String)("Not a list: " + p_129110_));
    }

    public DataResult<ByteBuffer> getByteBuffer(Tag p_129132_) {
        return p_129132_ instanceof ByteArrayTag ? DataResult.success((Object)ByteBuffer.wrap(((ByteArrayTag)p_129132_).getAsByteArray())) : super.getByteBuffer((Object)p_129132_);
    }

    public Tag createByteList(ByteBuffer p_128990_) {
        return new ByteArrayTag(DataFixUtils.toArray((ByteBuffer)p_128990_));
    }

    public DataResult<IntStream> getIntStream(Tag p_129134_) {
        return p_129134_ instanceof IntArrayTag ? DataResult.success((Object)Arrays.stream(((IntArrayTag)p_129134_).getAsIntArray())) : super.getIntStream((Object)p_129134_);
    }

    public Tag createIntList(IntStream p_129000_) {
        return new IntArrayTag(p_129000_.toArray());
    }

    public DataResult<LongStream> getLongStream(Tag p_129136_) {
        return p_129136_ instanceof LongArrayTag ? DataResult.success((Object)Arrays.stream(((LongArrayTag)p_129136_).getAsLongArray())) : super.getLongStream((Object)p_129136_);
    }

    public Tag createLongList(LongStream p_129002_) {
        return new LongArrayTag(p_129002_.toArray());
    }

    public Tag createList(Stream<Tag> p_129052_) {
        PeekingIterator peekingiterator = Iterators.peekingIterator(p_129052_.iterator());
        if (!peekingiterator.hasNext()) {
            return new ListTag();
        }
        Tag tag = (Tag)peekingiterator.peek();
        if (tag instanceof ByteTag) {
            ArrayList list2 = Lists.newArrayList((Iterator)Iterators.transform((Iterator)peekingiterator, p_129142_ -> ((ByteTag)p_129142_).getAsByte()));
            return new ByteArrayTag(list2);
        }
        if (tag instanceof IntTag) {
            ArrayList list1 = Lists.newArrayList((Iterator)Iterators.transform((Iterator)peekingiterator, p_129140_ -> ((IntTag)p_129140_).getAsInt()));
            return new IntArrayTag(list1);
        }
        if (tag instanceof LongTag) {
            ArrayList list = Lists.newArrayList((Iterator)Iterators.transform((Iterator)peekingiterator, p_129138_ -> ((LongTag)p_129138_).getAsLong()));
            return new LongArrayTag(list);
        }
        ListTag listtag = new ListTag();
        while (peekingiterator.hasNext()) {
            Tag tag1 = (Tag)peekingiterator.next();
            if (tag1 instanceof EndTag) continue;
            listtag.add(tag1);
        }
        return listtag;
    }

    public Tag remove(Tag p_129035_, String p_129036_) {
        if (p_129035_ instanceof CompoundTag) {
            CompoundTag compoundtag = (CompoundTag)p_129035_;
            CompoundTag compoundtag1 = new CompoundTag();
            compoundtag.getAllKeys().stream().filter(p_128988_ -> !Objects.equals(p_128988_, p_129036_)).forEach(p_129028_ -> compoundtag1.put((String)p_129028_, compoundtag.get((String)p_129028_)));
            return compoundtag1;
        }
        return p_129035_;
    }

    public String toString() {
        return "NBT";
    }

    public RecordBuilder<Tag> mapBuilder() {
        return new NbtRecordBuilder();
    }

    class NbtRecordBuilder
    extends RecordBuilder.AbstractStringBuilder<Tag, CompoundTag> {
        protected NbtRecordBuilder() {
            super((DynamicOps)NbtOps.this);
        }

        protected CompoundTag initBuilder() {
            return new CompoundTag();
        }

        protected CompoundTag append(String p_129186_, Tag p_129187_, CompoundTag p_129188_) {
            p_129188_.put(p_129186_, p_129187_);
            return p_129188_;
        }

        protected DataResult<Tag> build(CompoundTag p_129190_, Tag p_129191_) {
            if (p_129191_ != null && p_129191_ != EndTag.INSTANCE) {
                if (!(p_129191_ instanceof CompoundTag)) {
                    return DataResult.error((String)("mergeToMap called with not a map: " + p_129191_), (Object)p_129191_);
                }
                CompoundTag compoundtag = new CompoundTag(Maps.newHashMap(((CompoundTag)p_129191_).entries()));
                for (Map.Entry<String, Tag> entry : p_129190_.entries().entrySet()) {
                    compoundtag.put(entry.getKey(), entry.getValue());
                }
                return DataResult.success((Object)compoundtag);
            }
            return DataResult.success((Object)p_129190_);
        }
    }
}

