/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.SerializableUUID;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.nbt.TagTypes;
import net.minecraft.nbt.TextComponentTagVisitor;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.material.FluidState;
import org.slf4j.Logger;

public final class NbtUtils {
    private static final Comparator<ListTag> YXZ_LISTTAG_INT_COMPARATOR = Comparator.comparingInt(p_178074_ -> p_178074_.getInt(1)).thenComparingInt(p_178070_ -> p_178070_.getInt(0)).thenComparingInt(p_178066_ -> p_178066_.getInt(2));
    private static final Comparator<ListTag> YXZ_LISTTAG_DOUBLE_COMPARATOR = Comparator.comparingDouble(p_178060_ -> p_178060_.getDouble(1)).thenComparingDouble(p_178056_ -> p_178056_.getDouble(0)).thenComparingDouble(p_178042_ -> p_178042_.getDouble(2));
    public static final String SNBT_DATA_TAG = "data";
    private static final char PROPERTIES_START = '{';
    private static final char PROPERTIES_END = '}';
    private static final String ELEMENT_SEPARATOR = ",";
    private static final char KEY_VALUE_SEPARATOR = ':';
    private static final Splitter COMMA_SPLITTER = Splitter.on((String)",");
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':').limit(2);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int INDENT = 2;
    private static final int NOT_FOUND = -1;

    private NbtUtils() {
    }

    @Nullable
    public static GameProfile readGameProfile(CompoundTag pTag) {
        String s = null;
        UUID uuid = null;
        if (pTag.contains("Name", 8)) {
            s = pTag.getString("Name");
        }
        if (pTag.hasUUID("Id")) {
            uuid = pTag.getUUID("Id");
        }
        try {
            GameProfile gameprofile = new GameProfile(uuid, s);
            if (pTag.contains("Properties", 10)) {
                CompoundTag compoundtag = pTag.getCompound("Properties");
                for (String s1 : compoundtag.getAllKeys()) {
                    ListTag listtag = compoundtag.getList(s1, 10);
                    int i = 0;
                    while (i < listtag.size()) {
                        CompoundTag compoundtag1 = listtag.getCompound(i);
                        String s2 = compoundtag1.getString("Value");
                        if (compoundtag1.contains("Signature", 8)) {
                            gameprofile.getProperties().put((Object)s1, (Object)new Property(s1, s2, compoundtag1.getString("Signature")));
                        } else {
                            gameprofile.getProperties().put((Object)s1, (Object)new Property(s1, s2));
                        }
                        ++i;
                    }
                }
            }
            return gameprofile;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static CompoundTag writeGameProfile(CompoundTag pTag, GameProfile pProfile) {
        if (!StringUtil.isNullOrEmpty(pProfile.getName())) {
            pTag.putString("Name", pProfile.getName());
        }
        if (pProfile.getId() != null) {
            pTag.putUUID("Id", pProfile.getId());
        }
        if (!pProfile.getProperties().isEmpty()) {
            CompoundTag compoundtag = new CompoundTag();
            for (String s : pProfile.getProperties().keySet()) {
                ListTag listtag = new ListTag();
                for (Property property : pProfile.getProperties().get((Object)s)) {
                    CompoundTag compoundtag1 = new CompoundTag();
                    compoundtag1.putString("Value", property.getValue());
                    if (property.hasSignature()) {
                        compoundtag1.putString("Signature", property.getSignature());
                    }
                    listtag.add(compoundtag1);
                }
                compoundtag.put(s, listtag);
            }
            pTag.put("Properties", compoundtag);
        }
        return pTag;
    }

    @VisibleForTesting
    public static boolean compareNbt(@Nullable Tag pTag, @Nullable Tag pOther, boolean pCompareListTag) {
        if (pTag == pOther) {
            return true;
        }
        if (pTag == null) {
            return true;
        }
        if (pOther == null) {
            return false;
        }
        if (!pTag.getClass().equals(pOther.getClass())) {
            return false;
        }
        if (pTag instanceof CompoundTag) {
            CompoundTag compoundtag = (CompoundTag)pTag;
            CompoundTag compoundtag1 = (CompoundTag)pOther;
            for (String s : compoundtag.getAllKeys()) {
                Tag tag1 = compoundtag.get(s);
                if (NbtUtils.compareNbt(tag1, compoundtag1.get(s), pCompareListTag)) continue;
                return false;
            }
            return true;
        }
        if (pTag instanceof ListTag && pCompareListTag) {
            ListTag listtag = (ListTag)pTag;
            ListTag listtag1 = (ListTag)pOther;
            if (listtag.isEmpty()) {
                return listtag1.isEmpty();
            }
            int i = 0;
            while (i < listtag.size()) {
                Tag tag = listtag.get(i);
                boolean flag = false;
                int j = 0;
                while (j < listtag1.size()) {
                    if (NbtUtils.compareNbt(tag, listtag1.get(j), pCompareListTag)) {
                        flag = true;
                        break;
                    }
                    ++j;
                }
                if (!flag) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return pTag.equals(pOther);
    }

    public static IntArrayTag createUUID(UUID pUuid) {
        return new IntArrayTag(SerializableUUID.uuidToIntArray(pUuid));
    }

    public static UUID loadUUID(Tag pTag) {
        if (pTag.getType() != IntArrayTag.TYPE) {
            throw new IllegalArgumentException("Expected UUID-Tag to be of type " + IntArrayTag.TYPE.getName() + ", but found " + pTag.getType().getName() + ".");
        }
        int[] aint = ((IntArrayTag)pTag).getAsIntArray();
        if (aint.length != 4) {
            throw new IllegalArgumentException("Expected UUID-Array to be of length 4, but found " + aint.length + ".");
        }
        return SerializableUUID.a(aint);
    }

    public static BlockPos readBlockPos(CompoundTag pTag) {
        return new BlockPos(pTag.getInt("X"), pTag.getInt("Y"), pTag.getInt("Z"));
    }

    public static CompoundTag writeBlockPos(BlockPos pPos) {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.putInt("X", pPos.getX());
        compoundtag.putInt("Y", pPos.getY());
        compoundtag.putInt("Z", pPos.getZ());
        return compoundtag;
    }

    public static BlockState readBlockState(CompoundTag pTag) {
        if (!pTag.contains("Name", 8)) {
            return Blocks.AIR.defaultBlockState();
        }
        Block block = Registry.BLOCK.get(new ResourceLocation(pTag.getString("Name")));
        BlockState blockstate = block.defaultBlockState();
        if (pTag.contains("Properties", 10)) {
            CompoundTag compoundtag = pTag.getCompound("Properties");
            StateDefinition<Block, BlockState> statedefinition = block.getStateDefinition();
            for (String s : compoundtag.getAllKeys()) {
                net.minecraft.world.level.block.state.properties.Property<?> property = statedefinition.getProperty(s);
                if (property == null) continue;
                blockstate = NbtUtils.setValueHelper(blockstate, property, s, compoundtag, pTag);
            }
        }
        return blockstate;
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> S setValueHelper(S pStateHolder, net.minecraft.world.level.block.state.properties.Property<T> pProperty, String pPropertyName, CompoundTag pPropertiesTag, CompoundTag pBlockStateTag) {
        Optional<T> optional = pProperty.getValue(pPropertiesTag.getString(pPropertyName));
        if (optional.isPresent()) {
            return (S)((StateHolder)pStateHolder.setValue(pProperty, (Comparable)((Comparable)optional.get())));
        }
        LOGGER.warn("Unable to read property: {} with value: {} for blockstate: {}", new Object[]{pPropertyName, pPropertiesTag.getString(pPropertyName), pBlockStateTag.toString()});
        return pStateHolder;
    }

    public static CompoundTag writeBlockState(BlockState pState) {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.putString("Name", Registry.BLOCK.getKey(pState.getBlock()).toString());
        ImmutableMap<net.minecraft.world.level.block.state.properties.Property<?>, Comparable<?>> immutablemap = pState.getValues();
        if (!immutablemap.isEmpty()) {
            CompoundTag compoundtag1 = new CompoundTag();
            for (Map.Entry entry : immutablemap.entrySet()) {
                net.minecraft.world.level.block.state.properties.Property property = (net.minecraft.world.level.block.state.properties.Property)entry.getKey();
                compoundtag1.putString(property.getName(), NbtUtils.getName(property, (Comparable)entry.getValue()));
            }
            compoundtag.put("Properties", compoundtag1);
        }
        return compoundtag;
    }

    public static CompoundTag writeFluidState(FluidState pState) {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.putString("Name", Registry.FLUID.getKey(pState.getType()).toString());
        ImmutableMap<net.minecraft.world.level.block.state.properties.Property<?>, Comparable<?>> immutablemap = pState.getValues();
        if (!immutablemap.isEmpty()) {
            CompoundTag compoundtag1 = new CompoundTag();
            for (Map.Entry entry : immutablemap.entrySet()) {
                net.minecraft.world.level.block.state.properties.Property property = (net.minecraft.world.level.block.state.properties.Property)entry.getKey();
                compoundtag1.putString(property.getName(), NbtUtils.getName(property, (Comparable)entry.getValue()));
            }
            compoundtag.put("Properties", compoundtag1);
        }
        return compoundtag;
    }

    private static <T extends Comparable<T>> String getName(net.minecraft.world.level.block.state.properties.Property<T> pProperty, Comparable<?> pValue) {
        return pProperty.getName(pValue);
    }

    public static String prettyPrint(Tag pTag) {
        return NbtUtils.prettyPrint(pTag, false);
    }

    public static String prettyPrint(Tag pTag, boolean pPrettyPrintArray) {
        return NbtUtils.prettyPrint(new StringBuilder(), pTag, 0, pPrettyPrintArray).toString();
    }

    public static StringBuilder prettyPrint(StringBuilder pStringBuilder, Tag pTag, int pIndentLevel, boolean pPrettyPrintArray) {
        switch (pTag.getId()) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                pStringBuilder.append(pTag);
                break;
            }
            case 7: {
                ByteArrayTag bytearraytag = (ByteArrayTag)pTag;
                byte[] abyte = bytearraytag.getAsByteArray();
                int k1 = abyte.length;
                NbtUtils.indent(pIndentLevel, pStringBuilder).append("byte[").append(k1).append("] {\n");
                if (!pPrettyPrintArray) {
                    NbtUtils.indent(pIndentLevel + 1, pStringBuilder).append(" // Skipped, supply withBinaryBlobs true");
                } else {
                    NbtUtils.indent(pIndentLevel + 1, pStringBuilder);
                    int i2 = 0;
                    while (i2 < abyte.length) {
                        if (i2 != 0) {
                            pStringBuilder.append(',');
                        }
                        if (i2 % 16 == 0 && i2 / 16 > 0) {
                            pStringBuilder.append('\n');
                            if (i2 < abyte.length) {
                                NbtUtils.indent(pIndentLevel + 1, pStringBuilder);
                            }
                        } else if (i2 != 0) {
                            pStringBuilder.append(' ');
                        }
                        pStringBuilder.append(String.format("0x%02X", abyte[i2] & 0xFF));
                        ++i2;
                    }
                }
                pStringBuilder.append('\n');
                NbtUtils.indent(pIndentLevel, pStringBuilder).append('}');
                break;
            }
            case 9: {
                ListTag listtag = (ListTag)pTag;
                int k = listtag.size();
                byte j1 = listtag.getElementType();
                String s1 = j1 == 0 ? "undefined" : TagTypes.getType(j1).getPrettyName();
                NbtUtils.indent(pIndentLevel, pStringBuilder).append("list<").append(s1).append(">[").append(k).append("] [");
                if (k != 0) {
                    pStringBuilder.append('\n');
                }
                int i3 = 0;
                while (i3 < k) {
                    if (i3 != 0) {
                        pStringBuilder.append(",\n");
                    }
                    NbtUtils.indent(pIndentLevel + 1, pStringBuilder);
                    NbtUtils.prettyPrint(pStringBuilder, listtag.get(i3), pIndentLevel + 1, pPrettyPrintArray);
                    ++i3;
                }
                if (k != 0) {
                    pStringBuilder.append('\n');
                }
                NbtUtils.indent(pIndentLevel, pStringBuilder).append(']');
                break;
            }
            case 10: {
                CompoundTag compoundtag = (CompoundTag)pTag;
                ArrayList list = Lists.newArrayList(compoundtag.getAllKeys());
                Collections.sort(list);
                NbtUtils.indent(pIndentLevel, pStringBuilder).append('{');
                if (pStringBuilder.length() - pStringBuilder.lastIndexOf("\n") > 2 * (pIndentLevel + 1)) {
                    pStringBuilder.append('\n');
                    NbtUtils.indent(pIndentLevel + 1, pStringBuilder);
                }
                int i1 = list.stream().mapToInt(String::length).max().orElse(0);
                String s = Strings.repeat((String)" ", (int)i1);
                int l2 = 0;
                while (l2 < list.size()) {
                    if (l2 != 0) {
                        pStringBuilder.append(",\n");
                    }
                    String s2 = (String)list.get(l2);
                    NbtUtils.indent(pIndentLevel + 1, pStringBuilder).append('\"').append(s2).append('\"').append(s, 0, s.length() - s2.length()).append(": ");
                    NbtUtils.prettyPrint(pStringBuilder, compoundtag.get(s2), pIndentLevel + 1, pPrettyPrintArray);
                    ++l2;
                }
                if (!list.isEmpty()) {
                    pStringBuilder.append('\n');
                }
                NbtUtils.indent(pIndentLevel, pStringBuilder).append('}');
                break;
            }
            case 11: {
                IntArrayTag intarraytag = (IntArrayTag)pTag;
                int[] aint = intarraytag.getAsIntArray();
                int l = 0;
                int[] nArray = aint;
                int n = aint.length;
                int n2 = 0;
                while (n2 < n) {
                    int k3 = nArray[n2];
                    l = Math.max(l, String.format("%X", k3).length());
                    ++n2;
                }
                int l1 = aint.length;
                NbtUtils.indent(pIndentLevel, pStringBuilder).append("int[").append(l1).append("] {\n");
                if (!pPrettyPrintArray) {
                    NbtUtils.indent(pIndentLevel + 1, pStringBuilder).append(" // Skipped, supply withBinaryBlobs true");
                } else {
                    NbtUtils.indent(pIndentLevel + 1, pStringBuilder);
                    int k2 = 0;
                    while (k2 < aint.length) {
                        if (k2 != 0) {
                            pStringBuilder.append(',');
                        }
                        if (k2 % 16 == 0 && k2 / 16 > 0) {
                            pStringBuilder.append('\n');
                            if (k2 < aint.length) {
                                NbtUtils.indent(pIndentLevel + 1, pStringBuilder);
                            }
                        } else if (k2 != 0) {
                            pStringBuilder.append(' ');
                        }
                        pStringBuilder.append(String.format("0x%0" + l + "X", aint[k2]));
                        ++k2;
                    }
                }
                pStringBuilder.append('\n');
                NbtUtils.indent(pIndentLevel, pStringBuilder).append('}');
                break;
            }
            case 12: {
                LongArrayTag longarraytag = (LongArrayTag)pTag;
                long[] along = longarraytag.getAsLongArray();
                long i = 0L;
                long[] lArray = along;
                int n = along.length;
                int n3 = 0;
                while (n3 < n) {
                    long j = lArray[n3];
                    i = Math.max(i, (long)String.format("%X", j).length());
                    ++n3;
                }
                long j2 = along.length;
                NbtUtils.indent(pIndentLevel, pStringBuilder).append("long[").append(j2).append("] {\n");
                if (!pPrettyPrintArray) {
                    NbtUtils.indent(pIndentLevel + 1, pStringBuilder).append(" // Skipped, supply withBinaryBlobs true");
                } else {
                    NbtUtils.indent(pIndentLevel + 1, pStringBuilder);
                    int j3 = 0;
                    while (j3 < along.length) {
                        if (j3 != 0) {
                            pStringBuilder.append(',');
                        }
                        if (j3 % 16 == 0 && j3 / 16 > 0) {
                            pStringBuilder.append('\n');
                            if (j3 < along.length) {
                                NbtUtils.indent(pIndentLevel + 1, pStringBuilder);
                            }
                        } else if (j3 != 0) {
                            pStringBuilder.append(' ');
                        }
                        pStringBuilder.append(String.format("0x%0" + i + "X", along[j3]));
                        ++j3;
                    }
                }
                pStringBuilder.append('\n');
                NbtUtils.indent(pIndentLevel, pStringBuilder).append('}');
                break;
            }
            default: {
                pStringBuilder.append("<UNKNOWN :(>");
            }
        }
        return pStringBuilder;
    }

    private static StringBuilder indent(int pIndentLevel, StringBuilder pStringBuilder) {
        int i = pStringBuilder.lastIndexOf("\n") + 1;
        int j = pStringBuilder.length() - i;
        int k = 0;
        while (k < 2 * pIndentLevel - j) {
            pStringBuilder.append(' ');
            ++k;
        }
        return pStringBuilder;
    }

    public static CompoundTag update(DataFixer pDataFixer, DataFixTypes pType, CompoundTag pCompoundTag, int pVersion) {
        return NbtUtils.update(pDataFixer, pType, pCompoundTag, pVersion, SharedConstants.getCurrentVersion().getWorldVersion());
    }

    public static CompoundTag update(DataFixer pDataFixer, DataFixTypes pType, CompoundTag pCompoundTag, int pVersion, int pNewVersion) {
        return (CompoundTag)pDataFixer.update(pType.getType(), new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)pCompoundTag), pVersion, pNewVersion).getValue();
    }

    public static Component toPrettyComponent(Tag pTag) {
        return new TextComponentTagVisitor("", 0).visit(pTag);
    }

    public static String structureToSnbt(CompoundTag pTag) {
        return new SnbtPrinterTagVisitor().visit(NbtUtils.packStructureTemplate(pTag));
    }

    public static CompoundTag snbtToStructure(String pText) throws CommandSyntaxException {
        return NbtUtils.unpackStructureTemplate(TagParser.parseTag(pText));
    }

    @VisibleForTesting
    static CompoundTag packStructureTemplate(CompoundTag pTag) {
        boolean flag = pTag.contains("palettes", 9);
        ListTag listtag = flag ? pTag.getList("palettes", 9).getList(0) : pTag.getList("palette", 10);
        ListTag listtag1 = listtag.stream().map(CompoundTag.class::cast).map(NbtUtils::packBlockState).map(StringTag::valueOf).collect(Collectors.toCollection(ListTag::new));
        pTag.put("palette", listtag1);
        if (flag) {
            ListTag listtag2 = new ListTag();
            ListTag listtag3 = pTag.getList("palettes", 9);
            listtag3.stream().map(ListTag.class::cast).forEach(p_178049_ -> {
                CompoundTag compoundtag = new CompoundTag();
                int i = 0;
                while (i < p_178049_.size()) {
                    compoundtag.putString(listtag1.getString(i), NbtUtils.packBlockState(p_178049_.getCompound(i)));
                    ++i;
                }
                listtag2.add(compoundtag);
            });
            pTag.put("palettes", listtag2);
        }
        if (pTag.contains("entities", 10)) {
            ListTag listtag4 = pTag.getList("entities", 10);
            ListTag listtag6 = listtag4.stream().map(CompoundTag.class::cast).sorted(Comparator.comparing(p_178080_ -> p_178080_.getList("pos", 6), YXZ_LISTTAG_DOUBLE_COMPARATOR)).collect(Collectors.toCollection(ListTag::new));
            pTag.put("entities", listtag6);
        }
        ListTag listtag5 = pTag.getList("blocks", 10).stream().map(CompoundTag.class::cast).sorted(Comparator.comparing(p_178078_ -> p_178078_.getList("pos", 3), YXZ_LISTTAG_INT_COMPARATOR)).peek(p_178045_ -> p_178045_.putString("state", listtag1.getString(p_178045_.getInt("state")))).collect(Collectors.toCollection(ListTag::new));
        pTag.put(SNBT_DATA_TAG, listtag5);
        pTag.remove("blocks");
        return pTag;
    }

    @VisibleForTesting
    static CompoundTag unpackStructureTemplate(CompoundTag pTag) {
        ListTag listtag = pTag.getList("palette", 8);
        Map map = (Map)listtag.stream().map(StringTag.class::cast).map(StringTag::getAsString).collect(ImmutableMap.toImmutableMap(Function.identity(), NbtUtils::unpackBlockState));
        if (pTag.contains("palettes", 9)) {
            pTag.put("palettes", pTag.getList("palettes", 10).stream().map(CompoundTag.class::cast).map(p_178033_ -> map.keySet().stream().map(p_178033_::getString).map(NbtUtils::unpackBlockState).collect(Collectors.toCollection(ListTag::new))).collect(Collectors.toCollection(ListTag::new)));
            pTag.remove("palette");
        } else {
            pTag.put("palette", map.values().stream().collect(Collectors.toCollection(ListTag::new)));
        }
        if (pTag.contains(SNBT_DATA_TAG, 9)) {
            Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
            object2intmap.defaultReturnValue(-1);
            int i = 0;
            while (i < listtag.size()) {
                object2intmap.put((Object)listtag.getString(i), i);
                ++i;
            }
            ListTag listtag1 = pTag.getList(SNBT_DATA_TAG, 10);
            int j = 0;
            while (j < listtag1.size()) {
                CompoundTag compoundtag = listtag1.getCompound(j);
                String s = compoundtag.getString("state");
                int k = object2intmap.getInt((Object)s);
                if (k == -1) {
                    throw new IllegalStateException("Entry " + s + " missing from palette");
                }
                compoundtag.putInt("state", k);
                ++j;
            }
            pTag.put("blocks", listtag1);
            pTag.remove(SNBT_DATA_TAG);
        }
        return pTag;
    }

    @VisibleForTesting
    static String packBlockState(CompoundTag p_178076_) {
        StringBuilder stringbuilder = new StringBuilder(p_178076_.getString("Name"));
        if (p_178076_.contains("Properties", 10)) {
            CompoundTag compoundtag = p_178076_.getCompound("Properties");
            String s = compoundtag.getAllKeys().stream().sorted().map(p_178036_ -> String.valueOf(p_178036_) + ":" + compoundtag.get((String)p_178036_).getAsString()).collect(Collectors.joining(ELEMENT_SEPARATOR));
            stringbuilder.append('{').append(s).append('}');
        }
        return stringbuilder.toString();
    }

    @VisibleForTesting
    static CompoundTag unpackBlockState(String p_178054_) {
        String s;
        CompoundTag compoundtag = new CompoundTag();
        int i = p_178054_.indexOf(123);
        if (i >= 0) {
            s = p_178054_.substring(0, i);
            CompoundTag compoundtag1 = new CompoundTag();
            if (i + 2 <= p_178054_.length()) {
                String s1 = p_178054_.substring(i + 1, p_178054_.indexOf(125, i));
                COMMA_SPLITTER.split((CharSequence)s1).forEach(p_178040_ -> {
                    List list = COLON_SPLITTER.splitToList((CharSequence)p_178040_);
                    if (list.size() == 2) {
                        compoundtag1.putString((String)list.get(0), (String)list.get(1));
                    } else {
                        LOGGER.error("Something went wrong parsing: '{}' -- incorrect gamedata!", (Object)p_178054_);
                    }
                });
                compoundtag.put("Properties", compoundtag1);
            }
        } else {
            s = p_178054_;
        }
        compoundtag.putString("Name", s);
        return compoundtag;
    }
}

