/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagVisitor;

public class StringTag
implements Tag {
    private static final int SELF_SIZE_IN_BITS = 288;
    public static final TagType<StringTag> TYPE = new TagType.VariableSize<StringTag>(){

        @Override
        public StringTag load(DataInput p_129315_, int p_129316_, NbtAccounter p_129317_) throws IOException {
            p_129317_.accountBits(288L);
            String s = p_129315_.readUTF();
            p_129317_.accountBits(16 * s.length());
            return StringTag.valueOf(s);
        }

        @Override
        public StreamTagVisitor.ValueResult parse(DataInput p_197570_, StreamTagVisitor p_197571_) throws IOException {
            return p_197571_.visit(p_197570_.readUTF());
        }

        @Override
        public void skip(DataInput p_197568_) throws IOException {
            StringTag.skipString(p_197568_);
        }

        @Override
        public String getName() {
            return "STRING";
        }

        @Override
        public String getPrettyName() {
            return "TAG_String";
        }

        @Override
        public boolean isValue() {
            return true;
        }
    };
    private static final StringTag EMPTY = new StringTag("");
    private static final char DOUBLE_QUOTE = '\"';
    private static final char SINGLE_QUOTE = '\'';
    private static final char ESCAPE = '\\';
    private static final char NOT_SET = '\u0000';
    private final String data;

    public static void skipString(DataInput p_197564_) throws IOException {
        p_197564_.skipBytes(p_197564_.readUnsignedShort());
    }

    private StringTag(String pData) {
        Objects.requireNonNull(pData, "Null string not allowed");
        this.data = pData;
    }

    public static StringTag valueOf(String pData) {
        return pData.isEmpty() ? EMPTY : new StringTag(pData);
    }

    @Override
    public void write(DataOutput pOutput) throws IOException {
        pOutput.writeUTF(this.data);
    }

    @Override
    public byte getId() {
        return 8;
    }

    public TagType<StringTag> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        return Tag.super.getAsString();
    }

    @Override
    public StringTag copy() {
        return this;
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        return pOther instanceof StringTag && Objects.equals(this.data, ((StringTag)pOther).data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public String getAsString() {
        return this.data;
    }

    @Override
    public void accept(TagVisitor pVisitor) {
        pVisitor.visitString(this);
    }

    public static String quoteAndEscape(String pText) {
        StringBuilder stringbuilder = new StringBuilder(" ");
        char c0 = '\u0000';
        int i = 0;
        while (i < pText.length()) {
            char c1 = pText.charAt(i);
            if (c1 == '\\') {
                stringbuilder.append('\\');
            } else if (c1 == '\"' || c1 == '\'') {
                if (c0 == '\u0000') {
                    c0 = (char)(c1 == '\"' ? 39 : 34);
                }
                if (c0 == c1) {
                    stringbuilder.append('\\');
                }
            }
            stringbuilder.append(c1);
            ++i;
        }
        if (c0 == '\u0000') {
            c0 = '\"';
        }
        stringbuilder.setCharAt(0, c0);
        stringbuilder.append(c0);
        return stringbuilder.toString();
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor pVisitor) {
        return pVisitor.visit(this.data);
    }
}

