/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagVisitor;

public class StringTagVisitor
implements TagVisitor {
    private static final Pattern SIMPLE_VALUE = Pattern.compile("[A-Za-z0-9._+-]+");
    private final StringBuilder builder = new StringBuilder();

    public String visit(Tag pTag) {
        pTag.accept(this);
        return this.builder.toString();
    }

    @Override
    public void visitString(StringTag pTag) {
        this.builder.append(StringTag.quoteAndEscape(pTag.getAsString()));
    }

    @Override
    public void visitByte(ByteTag pTag) {
        this.builder.append(pTag.getAsNumber()).append('b');
    }

    @Override
    public void visitShort(ShortTag pTag) {
        this.builder.append(pTag.getAsNumber()).append('s');
    }

    @Override
    public void visitInt(IntTag pTag) {
        this.builder.append(pTag.getAsNumber());
    }

    @Override
    public void visitLong(LongTag pTag) {
        this.builder.append(pTag.getAsNumber()).append('L');
    }

    @Override
    public void visitFloat(FloatTag pTag) {
        this.builder.append(pTag.getAsFloat()).append('f');
    }

    @Override
    public void visitDouble(DoubleTag pTag) {
        this.builder.append(pTag.getAsDouble()).append('d');
    }

    @Override
    public void visitByteArray(ByteArrayTag pTag) {
        this.builder.append("[B;");
        byte[] abyte = pTag.getAsByteArray();
        int i = 0;
        while (i < abyte.length) {
            if (i != 0) {
                this.builder.append(',');
            }
            this.builder.append(abyte[i]).append('B');
            ++i;
        }
        this.builder.append(']');
    }

    @Override
    public void visitIntArray(IntArrayTag pTag) {
        this.builder.append("[I;");
        int[] aint = pTag.getAsIntArray();
        int i = 0;
        while (i < aint.length) {
            if (i != 0) {
                this.builder.append(',');
            }
            this.builder.append(aint[i]);
            ++i;
        }
        this.builder.append(']');
    }

    @Override
    public void visitLongArray(LongArrayTag pTag) {
        this.builder.append("[L;");
        long[] along = pTag.getAsLongArray();
        int i = 0;
        while (i < along.length) {
            if (i != 0) {
                this.builder.append(',');
            }
            this.builder.append(along[i]).append('L');
            ++i;
        }
        this.builder.append(']');
    }

    @Override
    public void visitList(ListTag pTag) {
        this.builder.append('[');
        int i = 0;
        while (i < pTag.size()) {
            if (i != 0) {
                this.builder.append(',');
            }
            this.builder.append(new StringTagVisitor().visit(pTag.get(i)));
            ++i;
        }
        this.builder.append(']');
    }

    @Override
    public void visitCompound(CompoundTag pTag) {
        this.builder.append('{');
        ArrayList list = Lists.newArrayList(pTag.getAllKeys());
        Collections.sort(list);
        for (String s : list) {
            if (this.builder.length() != 1) {
                this.builder.append(',');
            }
            this.builder.append(StringTagVisitor.handleEscape(s)).append(':').append(new StringTagVisitor().visit(pTag.get(s)));
        }
        this.builder.append('}');
    }

    protected static String handleEscape(String pText) {
        return SIMPLE_VALUE.matcher(pText).matches() ? pText : StringTag.quoteAndEscape(pText);
    }

    @Override
    public void visitEnd(EndTag pTag) {
        this.builder.append("END");
    }
}

