/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.IOException;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;

public interface TagType<T extends Tag> {
    public static final /* synthetic */ int[] $SWITCH_TABLE$net$minecraft$nbt$StreamTagVisitor$ValueResult;

    public T load(DataInput var1, int var2, NbtAccounter var3) throws IOException;

    public StreamTagVisitor.ValueResult parse(DataInput var1, StreamTagVisitor var2) throws IOException;

    default public void parseRoot(DataInput p_197581_, StreamTagVisitor p_197582_) throws IOException {
        switch (p_197582_.visitRootEntry(this)) {
            case CONTINUE: {
                this.parse(p_197581_, p_197582_);
            }
            default: {
                break;
            }
            case BREAK: {
                this.skip(p_197581_);
            }
        }
    }

    public void skip(DataInput var1, int var2) throws IOException;

    public void skip(DataInput var1) throws IOException;

    default public boolean isValue() {
        return false;
    }

    public String getName();

    public String getPrettyName();

    public static TagType<EndTag> createInvalid(int pId) {
        return new TagType<EndTag>(){

            private IOException createException() {
                return new IOException("Invalid tag id: " + pId);
            }

            @Override
            public EndTag load(DataInput p_129387_, int p_129388_, NbtAccounter p_129389_) throws IOException {
                throw this.createException();
            }

            @Override
            public StreamTagVisitor.ValueResult parse(DataInput p_197589_, StreamTagVisitor p_197590_) throws IOException {
                throw this.createException();
            }

            @Override
            public void skip(DataInput p_197586_, int p_197587_) throws IOException {
                throw this.createException();
            }

            @Override
            public void skip(DataInput p_197584_) throws IOException {
                throw this.createException();
            }

            @Override
            public String getName() {
                return "INVALID[" + pId + "]";
            }

            @Override
            public String getPrettyName() {
                return "UNKNOWN_" + pId;
            }
        };
    }

    public static interface StaticSize<T extends Tag>
    extends TagType<T> {
        @Override
        default public void skip(DataInput p_197595_) throws IOException {
            p_197595_.skipBytes(this.size());
        }

        @Override
        default public void skip(DataInput p_197597_, int p_197598_) throws IOException {
            p_197597_.skipBytes(this.size() * p_197598_);
        }

        public int size();
    }

    public static interface VariableSize<T extends Tag>
    extends TagType<T> {
        @Override
        default public void skip(DataInput p_197600_, int p_197601_) throws IOException {
            int i = 0;
            while (i < p_197601_) {
                this.skip(p_197600_);
                ++i;
            }
        }
    }
}

