/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagVisitor;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import org.slf4j.Logger;

public class TextComponentTagVisitor
implements TagVisitor {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int INLINE_LIST_THRESHOLD = 8;
    private static final ByteCollection INLINE_ELEMENT_TYPES = new ByteOpenHashSet(Arrays.asList((byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6));
    private static final ChatFormatting SYNTAX_HIGHLIGHTING_KEY = ChatFormatting.AQUA;
    private static final ChatFormatting SYNTAX_HIGHLIGHTING_STRING = ChatFormatting.GREEN;
    private static final ChatFormatting SYNTAX_HIGHLIGHTING_NUMBER = ChatFormatting.GOLD;
    private static final ChatFormatting SYNTAX_HIGHLIGHTING_NUMBER_TYPE = ChatFormatting.RED;
    private static final Pattern SIMPLE_VALUE = Pattern.compile("[A-Za-z0-9._+-]+");
    private static final String NAME_VALUE_SEPARATOR = String.valueOf(':');
    private static final String ELEMENT_SEPARATOR = String.valueOf(',');
    private static final String LIST_OPEN = "[";
    private static final String LIST_CLOSE = "]";
    private static final String LIST_TYPE_SEPARATOR = ";";
    private static final String ELEMENT_SPACING = " ";
    private static final String STRUCT_OPEN = "{";
    private static final String STRUCT_CLOSE = "}";
    private static final String NEWLINE = "\n";
    private final String indentation;
    private final int depth;
    private Component result = TextComponent.EMPTY;

    public TextComponentTagVisitor(String pIndentation, int pDepth) {
        this.indentation = pIndentation;
        this.depth = pDepth;
    }

    public Component visit(Tag pTag) {
        pTag.accept(this);
        return this.result;
    }

    @Override
    public void visitString(StringTag pTag) {
        String s = StringTag.quoteAndEscape(pTag.getAsString());
        String s1 = s.substring(0, 1);
        MutableComponent component = new TextComponent(s.substring(1, s.length() - 1)).withStyle(SYNTAX_HIGHLIGHTING_STRING);
        this.result = new TextComponent(s1).append(component).append(s1);
    }

    @Override
    public void visitByte(ByteTag pTag) {
        MutableComponent component = new TextComponent("b").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        this.result = new TextComponent(String.valueOf(pTag.getAsNumber())).append(component).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    public void visitShort(ShortTag pTag) {
        MutableComponent component = new TextComponent("s").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        this.result = new TextComponent(String.valueOf(pTag.getAsNumber())).append(component).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    public void visitInt(IntTag pTag) {
        this.result = new TextComponent(String.valueOf(pTag.getAsNumber())).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    public void visitLong(LongTag pTag) {
        MutableComponent component = new TextComponent("L").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        this.result = new TextComponent(String.valueOf(pTag.getAsNumber())).append(component).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    public void visitFloat(FloatTag pTag) {
        MutableComponent component = new TextComponent("f").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        this.result = new TextComponent(String.valueOf(pTag.getAsFloat())).append(component).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    public void visitDouble(DoubleTag pTag) {
        MutableComponent component = new TextComponent("d").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        this.result = new TextComponent(String.valueOf(pTag.getAsDouble())).append(component).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
    }

    @Override
    public void visitByteArray(ByteArrayTag pTag) {
        MutableComponent component = new TextComponent("B").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        MutableComponent mutablecomponent = new TextComponent(LIST_OPEN).append(component).append(LIST_TYPE_SEPARATOR);
        byte[] abyte = pTag.getAsByteArray();
        int i = 0;
        while (i < abyte.length) {
            MutableComponent mutablecomponent1 = new TextComponent(String.valueOf(abyte[i])).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
            mutablecomponent.append(ELEMENT_SPACING).append(mutablecomponent1).append(component);
            if (i != abyte.length - 1) {
                mutablecomponent.append(ELEMENT_SEPARATOR);
            }
            ++i;
        }
        mutablecomponent.append(LIST_CLOSE);
        this.result = mutablecomponent;
    }

    @Override
    public void visitIntArray(IntArrayTag pTag) {
        MutableComponent component = new TextComponent("I").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        MutableComponent mutablecomponent = new TextComponent(LIST_OPEN).append(component).append(LIST_TYPE_SEPARATOR);
        int[] aint = pTag.getAsIntArray();
        int i = 0;
        while (i < aint.length) {
            mutablecomponent.append(ELEMENT_SPACING).append(new TextComponent(String.valueOf(aint[i])).withStyle(SYNTAX_HIGHLIGHTING_NUMBER));
            if (i != aint.length - 1) {
                mutablecomponent.append(ELEMENT_SEPARATOR);
            }
            ++i;
        }
        mutablecomponent.append(LIST_CLOSE);
        this.result = mutablecomponent;
    }

    @Override
    public void visitLongArray(LongArrayTag pTag) {
        MutableComponent component = new TextComponent("L").withStyle(SYNTAX_HIGHLIGHTING_NUMBER_TYPE);
        MutableComponent mutablecomponent = new TextComponent(LIST_OPEN).append(component).append(LIST_TYPE_SEPARATOR);
        long[] along = pTag.getAsLongArray();
        int i = 0;
        while (i < along.length) {
            MutableComponent component1 = new TextComponent(String.valueOf(along[i])).withStyle(SYNTAX_HIGHLIGHTING_NUMBER);
            mutablecomponent.append(ELEMENT_SPACING).append(component1).append(component);
            if (i != along.length - 1) {
                mutablecomponent.append(ELEMENT_SEPARATOR);
            }
            ++i;
        }
        mutablecomponent.append(LIST_CLOSE);
        this.result = mutablecomponent;
    }

    @Override
    public void visitList(ListTag pTag) {
        if (pTag.isEmpty()) {
            this.result = new TextComponent("[]");
        } else if (INLINE_ELEMENT_TYPES.contains(pTag.getElementType()) && pTag.size() <= 8) {
            String s = String.valueOf(ELEMENT_SEPARATOR) + ELEMENT_SPACING;
            TextComponent mutablecomponent2 = new TextComponent(LIST_OPEN);
            int j = 0;
            while (j < pTag.size()) {
                if (j != 0) {
                    mutablecomponent2.append(s);
                }
                mutablecomponent2.append(new TextComponentTagVisitor(this.indentation, this.depth).visit(pTag.get(j)));
                ++j;
            }
            mutablecomponent2.append(LIST_CLOSE);
            this.result = mutablecomponent2;
        } else {
            TextComponent mutablecomponent = new TextComponent(LIST_OPEN);
            if (!this.indentation.isEmpty()) {
                mutablecomponent.append(NEWLINE);
            }
            int i = 0;
            while (i < pTag.size()) {
                TextComponent mutablecomponent1 = new TextComponent(Strings.repeat((String)this.indentation, (int)(this.depth + 1)));
                mutablecomponent1.append(new TextComponentTagVisitor(this.indentation, this.depth + 1).visit(pTag.get(i)));
                if (i != pTag.size() - 1) {
                    mutablecomponent1.append(ELEMENT_SEPARATOR).append(this.indentation.isEmpty() ? ELEMENT_SPACING : NEWLINE);
                }
                mutablecomponent.append(mutablecomponent1);
                ++i;
            }
            if (!this.indentation.isEmpty()) {
                mutablecomponent.append(NEWLINE).append(Strings.repeat((String)this.indentation, (int)this.depth));
            }
            mutablecomponent.append(LIST_CLOSE);
            this.result = mutablecomponent;
        }
    }

    @Override
    public void visitCompound(CompoundTag pTag) {
        if (pTag.isEmpty()) {
            this.result = new TextComponent("{}");
        } else {
            TextComponent mutablecomponent = new TextComponent(STRUCT_OPEN);
            Collection<String> collection = pTag.getAllKeys();
            if (LOGGER.isDebugEnabled()) {
                ArrayList list = Lists.newArrayList(pTag.getAllKeys());
                Collections.sort(list);
                collection = list;
            }
            if (!this.indentation.isEmpty()) {
                mutablecomponent.append(NEWLINE);
            }
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                MutableComponent mutablecomponent1 = new TextComponent(Strings.repeat((String)this.indentation, (int)(this.depth + 1))).append(TextComponentTagVisitor.handleEscapePretty(s)).append(NAME_VALUE_SEPARATOR).append(ELEMENT_SPACING).append(new TextComponentTagVisitor(this.indentation, this.depth + 1).visit(pTag.get(s)));
                if (iterator.hasNext()) {
                    mutablecomponent1.append(ELEMENT_SEPARATOR).append(this.indentation.isEmpty() ? ELEMENT_SPACING : NEWLINE);
                }
                mutablecomponent.append(mutablecomponent1);
            }
            if (!this.indentation.isEmpty()) {
                mutablecomponent.append(NEWLINE).append(Strings.repeat((String)this.indentation, (int)this.depth));
            }
            mutablecomponent.append(STRUCT_CLOSE);
            this.result = mutablecomponent;
        }
    }

    protected static Component handleEscapePretty(String pText) {
        if (SIMPLE_VALUE.matcher(pText).matches()) {
            return new TextComponent(pText).withStyle(SYNTAX_HIGHLIGHTING_KEY);
        }
        String s = StringTag.quoteAndEscape(pText);
        String s1 = s.substring(0, 1);
        MutableComponent component = new TextComponent(s.substring(1, s.length() - 1)).withStyle(SYNTAX_HIGHLIGHTING_KEY);
        return new TextComponent(s1).append(component).append(s1);
    }

    @Override
    public void visitEnd(EndTag pTag) {
        this.result = TextComponent.EMPTY;
    }
}

