/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt.visitors;

import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.visitors.CollectToTag;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.nbt.visitors.FieldTree;

public class SkipFields
extends CollectToTag {
    private final Deque<FieldTree> stack = new ArrayDeque<FieldTree>();

    public SkipFields(FieldSelector ... p_202549_) {
        FieldTree fieldtree = FieldTree.createRoot();
        FieldSelector[] fieldSelectorArray = p_202549_;
        int n = p_202549_.length;
        int n2 = 0;
        while (n2 < n) {
            FieldSelector fieldselector = fieldSelectorArray[n2];
            fieldtree.addEntry(fieldselector);
            ++n2;
        }
        this.stack.push(fieldtree);
    }

    @Override
    public StreamTagVisitor.EntryResult visitEntry(TagType<?> p_202551_, String p_202552_) {
        FieldTree fieldtree1;
        FieldTree fieldtree = this.stack.element();
        if (fieldtree.isSelected(p_202551_, p_202552_)) {
            return StreamTagVisitor.EntryResult.SKIP;
        }
        if (p_202551_ == CompoundTag.TYPE && (fieldtree1 = fieldtree.fieldsToRecurse().get(p_202552_)) != null) {
            this.stack.push(fieldtree1);
        }
        return super.visitEntry(p_202551_, p_202552_);
    }

    @Override
    public StreamTagVisitor.ValueResult visitContainerEnd() {
        if (this.depth() == this.stack.element().depth()) {
            this.stack.pop();
        }
        return super.visitContainerEnd();
    }
}

