/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.IOException;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.SkipPacketException;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import org.slf4j.Logger;

public class PacketEncoder
extends MessageToByteEncoder<Packet<?>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PacketFlow flow;

    public PacketEncoder(PacketFlow pFlow) {
        this.flow = pFlow;
    }

    protected void encode(ChannelHandlerContext p_130545_, Packet<?> p_130546_, ByteBuf p_130547_) throws Exception {
        ConnectionProtocol connectionprotocol = (ConnectionProtocol)((Object)p_130545_.channel().attr(Connection.ATTRIBUTE_PROTOCOL).get());
        if (connectionprotocol == null) {
            throw new RuntimeException("ConnectionProtocol unknown: " + p_130546_);
        }
        Integer integer = connectionprotocol.getPacketId(this.flow, p_130546_);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(Connection.PACKET_SENT_MARKER, "OUT: [{}:{}] {}", new Object[]{p_130545_.channel().attr(Connection.ATTRIBUTE_PROTOCOL).get(), integer, p_130546_.getClass().getName()});
        }
        if (integer == null) {
            throw new IOException("Can't serialize unregistered packet");
        }
        FriendlyByteBuf friendlybytebuf = new FriendlyByteBuf(p_130547_);
        friendlybytebuf.writeVarInt(integer);
        try {
            int i = friendlybytebuf.writerIndex();
            p_130546_.write(friendlybytebuf);
            int j = friendlybytebuf.writerIndex() - i;
            if (j > 0x800000) {
                throw new IllegalArgumentException("Packet too big (is " + j + ", should be less than 8388608): " + p_130546_);
            }
            int k = ((ConnectionProtocol)((Object)p_130545_.channel().attr(Connection.ATTRIBUTE_PROTOCOL).get())).getId();
            JvmProfiler.INSTANCE.onPacketSent(k, integer, p_130545_.channel().remoteAddress(), j);
        }
        catch (Throwable throwable) {
            LOGGER.error("Error receiving packet {}", (Object)integer, (Object)throwable);
            if (p_130546_.isSkippable()) {
                throw new SkipPacketException(throwable);
            }
            throw throwable;
        }
    }
}

