/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.mojang.logging.LogUtils;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientboundDisconnectPacket;
import org.slf4j.Logger;

public class RateKickingConnection
extends Connection {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Component EXCEED_REASON = new TranslatableComponent("disconnect.exceeded_packet_rate");
    private final int rateLimitPacketsPerSecond;

    public RateKickingConnection(int pRateLimitPacketsPerSecond) {
        super(PacketFlow.SERVERBOUND);
        this.rateLimitPacketsPerSecond = pRateLimitPacketsPerSecond;
    }

    @Override
    protected void tickSecond() {
        super.tickSecond();
        float f = this.getAverageReceivedPackets();
        if (f > (float)this.rateLimitPacketsPerSecond) {
            LOGGER.warn("Player exceeded rate-limit (sent {} packets per second)", (Object)Float.valueOf(f));
            this.send(new ClientboundDisconnectPacket(EXCEED_REASON), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)p_130560_ -> this.disconnect(EXCEED_REASON)));
            this.setReadOnly();
        }
    }
}

