/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public abstract class BaseComponent
implements MutableComponent {
    protected final List<Component> siblings = Lists.newArrayList();
    private FormattedCharSequence visualOrderText = FormattedCharSequence.EMPTY;
    @Nullable
    private Language decomposedWith;
    private Style style = Style.EMPTY;

    @Override
    public MutableComponent append(Component pSibling) {
        this.siblings.add(pSibling);
        return this;
    }

    @Override
    public String getContents() {
        return "";
    }

    @Override
    public List<Component> getSiblings() {
        return this.siblings;
    }

    @Override
    public MutableComponent setStyle(Style pStyle) {
        this.style = pStyle;
        return this;
    }

    @Override
    public Style getStyle() {
        return this.style;
    }

    @Override
    public abstract BaseComponent plainCopy();

    @Override
    public final MutableComponent copy() {
        BaseComponent basecomponent = this.plainCopy();
        basecomponent.siblings.addAll(this.siblings);
        basecomponent.setStyle(this.style);
        return basecomponent;
    }

    @Override
    public FormattedCharSequence getVisualOrderText() {
        Language language = Language.getInstance();
        if (this.decomposedWith != language) {
            this.visualOrderText = language.getVisualOrder(this);
            this.decomposedWith = language;
        }
        return this.visualOrderText;
    }

    public boolean equals(Object p_130593_) {
        if (this == p_130593_) {
            return true;
        }
        if (!(p_130593_ instanceof BaseComponent)) {
            return false;
        }
        BaseComponent basecomponent = (BaseComponent)p_130593_;
        return this.siblings.equals(basecomponent.siblings) && Objects.equals(this.getStyle(), basecomponent.getStyle());
    }

    public int hashCode() {
        return Objects.hash(this.getStyle(), this.siblings);
    }

    public String toString() {
        return "BaseComponent{style=" + this.style + ", siblings=" + this.siblings + "}";
    }
}

