/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public class ClickEvent {
    private final Action action;
    private final String value;

    public ClickEvent(Action pAction, String pValue) {
        this.action = pAction;
        this.value = pValue;
    }

    public Action getAction() {
        return this.action;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object p_130625_) {
        if (this == p_130625_) {
            return true;
        }
        if (p_130625_ != null && this.getClass() == p_130625_.getClass()) {
            ClickEvent clickevent = (ClickEvent)p_130625_;
            if (this.action != clickevent.action) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(clickevent.value) : clickevent.value != null);
        }
        return false;
    }

    public String toString() {
        return "ClickEvent{action=" + (Object)((Object)this.action) + ", value='" + this.value + "'}";
    }

    public int hashCode() {
        int i = this.action.hashCode();
        return 31 * i + (this.value != null ? this.value.hashCode() : 0);
    }

    public static enum Action {
        OPEN_URL("open_url", true),
        OPEN_FILE("open_file", false),
        RUN_COMMAND("run_command", true),
        SUGGEST_COMMAND("suggest_command", true),
        CHANGE_PAGE("change_page", true),
        COPY_TO_CLIPBOARD("copy_to_clipboard", true);

        private static final Map<String, Action> LOOKUP;
        private final boolean allowFromServer;
        private final String name;

        static {
            LOOKUP = Arrays.stream(Action.values()).collect(Collectors.toMap(Action::getName, p_130648_ -> p_130648_));
        }

        private Action(String p_130642_, boolean p_130643_) {
            this.name = p_130642_;
            this.allowFromServer = p_130643_;
        }

        public boolean isAllowedFromServer() {
            return this.allowFromServer;
        }

        public String getName() {
            return this.name;
        }

        public static Action getByName(String pCanonicalName) {
            return LOOKUP.get(pCanonicalName);
        }
    }
}

