/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.Message;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.KeybindComponent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.NbtComponent;
import net.minecraft.network.chat.ScoreComponent;
import net.minecraft.network.chat.SelectorComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.LowerCaseEnumTypeAdapterFactory;

public interface Component
extends Message,
FormattedText {
    public Style getStyle();

    public String getContents();

    @Override
    default public String getString() {
        return FormattedText.super.getString();
    }

    default public String getString(int pMaxLength) {
        StringBuilder stringbuilder = new StringBuilder();
        this.visit(p_130673_ -> {
            int i = pMaxLength - stringbuilder.length();
            if (i <= 0) {
                return STOP_ITERATION;
            }
            stringbuilder.append(p_130673_.length() <= i ? p_130673_ : p_130673_.substring(0, i));
            return Optional.empty();
        });
        return stringbuilder.toString();
    }

    public List<Component> getSiblings();

    public MutableComponent plainCopy();

    public MutableComponent copy();

    public FormattedCharSequence getVisualOrderText();

    @Override
    default public <T> Optional<T> visit(FormattedText.StyledContentConsumer<T> pAcceptor, Style pStyle) {
        Style style = this.getStyle().applyTo(pStyle);
        Optional<T> optional = this.visitSelf(pAcceptor, style);
        if (optional.isPresent()) {
            return optional;
        }
        for (Component component : this.getSiblings()) {
            Optional<T> optional1 = component.visit(pAcceptor, style);
            if (!optional1.isPresent()) continue;
            return optional1;
        }
        return Optional.empty();
    }

    @Override
    default public <T> Optional<T> visit(FormattedText.ContentConsumer<T> pAcceptor) {
        Optional<T> optional = this.visitSelf(pAcceptor);
        if (optional.isPresent()) {
            return optional;
        }
        for (Component component : this.getSiblings()) {
            Optional<T> optional1 = component.visit(pAcceptor);
            if (!optional1.isPresent()) continue;
            return optional1;
        }
        return Optional.empty();
    }

    default public <T> Optional<T> visitSelf(FormattedText.StyledContentConsumer<T> pConsumer, Style pStyle) {
        return pConsumer.accept(pStyle, this.getContents());
    }

    default public <T> Optional<T> visitSelf(FormattedText.ContentConsumer<T> pConsumer) {
        return pConsumer.accept(this.getContents());
    }

    default public List<Component> toFlatList(Style p_178406_) {
        ArrayList list = Lists.newArrayList();
        this.visit((p_178403_, p_178404_) -> {
            if (!p_178404_.isEmpty()) {
                list.add(new TextComponent(p_178404_).withStyle(p_178403_));
            }
            return Optional.empty();
        }, p_178406_);
        return list;
    }

    public static Component nullToEmpty(@Nullable String pText) {
        return pText != null ? new TextComponent(pText) : TextComponent.EMPTY;
    }

    public static class Serializer
    implements JsonDeserializer<MutableComponent>,
    JsonSerializer<Component> {
        private static final Gson GSON = Util.make(() -> {
            GsonBuilder gsonbuilder = new GsonBuilder();
            gsonbuilder.disableHtmlEscaping();
            gsonbuilder.registerTypeHierarchyAdapter(Component.class, (Object)new Serializer());
            gsonbuilder.registerTypeHierarchyAdapter(Style.class, (Object)new Style.Serializer());
            gsonbuilder.registerTypeAdapterFactory((TypeAdapterFactory)new LowerCaseEnumTypeAdapterFactory());
            return gsonbuilder.create();
        });
        private static final Field JSON_READER_POS = Util.make(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field field = JsonReader.class.getDeclaredField("pos");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException nosuchfieldexception) {
                throw new IllegalStateException("Couldn't get field 'pos' for JsonReader", nosuchfieldexception);
            }
        });
        private static final Field JSON_READER_LINESTART = Util.make(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field field = JsonReader.class.getDeclaredField("lineStart");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException nosuchfieldexception) {
                throw new IllegalStateException("Couldn't get field 'lineStart' for JsonReader", nosuchfieldexception);
            }
        });

        public MutableComponent deserialize(JsonElement p_130694_, Type p_130695_, JsonDeserializationContext p_130696_) throws JsonParseException {
            BaseComponent mutablecomponent;
            if (p_130694_.isJsonPrimitive()) {
                return new TextComponent(p_130694_.getAsString());
            }
            if (!p_130694_.isJsonObject()) {
                if (p_130694_.isJsonArray()) {
                    JsonArray jsonarray1 = p_130694_.getAsJsonArray();
                    MutableComponent mutablecomponent1 = null;
                    for (JsonElement jsonelement : jsonarray1) {
                        MutableComponent mutablecomponent2 = this.deserialize(jsonelement, jsonelement.getClass(), p_130696_);
                        if (mutablecomponent1 == null) {
                            mutablecomponent1 = mutablecomponent2;
                            continue;
                        }
                        mutablecomponent1.append(mutablecomponent2);
                    }
                    return mutablecomponent1;
                }
                throw new JsonParseException("Don't know how to turn " + p_130694_ + " into a Component");
            }
            JsonObject jsonobject = p_130694_.getAsJsonObject();
            if (jsonobject.has("text")) {
                mutablecomponent = new TextComponent(GsonHelper.getAsString(jsonobject, "text"));
            } else if (jsonobject.has("translate")) {
                String s = GsonHelper.getAsString(jsonobject, "translate");
                if (jsonobject.has("with")) {
                    JsonArray jsonarray = GsonHelper.getAsJsonArray(jsonobject, "with");
                    Object[] aobject = new Object[jsonarray.size()];
                    int i = 0;
                    while (i < aobject.length) {
                        TextComponent textcomponent;
                        aobject[i] = this.deserialize(jsonarray.get(i), p_130695_, p_130696_);
                        if (aobject[i] instanceof TextComponent && (textcomponent = (TextComponent)aobject[i]).getStyle().isEmpty() && textcomponent.getSiblings().isEmpty()) {
                            aobject[i] = textcomponent.getText();
                        }
                        ++i;
                    }
                    mutablecomponent = new TranslatableComponent(s, aobject);
                } else {
                    mutablecomponent = new TranslatableComponent(s);
                }
            } else if (jsonobject.has("score")) {
                JsonObject jsonobject1 = GsonHelper.getAsJsonObject(jsonobject, "score");
                if (!jsonobject1.has("name") || !jsonobject1.has("objective")) {
                    throw new JsonParseException("A score component needs a least a name and an objective");
                }
                mutablecomponent = new ScoreComponent(GsonHelper.getAsString(jsonobject1, "name"), GsonHelper.getAsString(jsonobject1, "objective"));
            } else if (jsonobject.has("selector")) {
                Optional<Component> optional = this.parseSeparator(p_130695_, p_130696_, jsonobject);
                mutablecomponent = new SelectorComponent(GsonHelper.getAsString(jsonobject, "selector"), optional);
            } else if (jsonobject.has("keybind")) {
                mutablecomponent = new KeybindComponent(GsonHelper.getAsString(jsonobject, "keybind"));
            } else {
                if (!jsonobject.has("nbt")) {
                    throw new JsonParseException("Don't know how to turn " + p_130694_ + " into a Component");
                }
                String s1 = GsonHelper.getAsString(jsonobject, "nbt");
                Optional<Component> optional1 = this.parseSeparator(p_130695_, p_130696_, jsonobject);
                boolean flag = GsonHelper.getAsBoolean(jsonobject, "interpret", false);
                if (jsonobject.has("block")) {
                    mutablecomponent = new NbtComponent.BlockNbtComponent(s1, flag, GsonHelper.getAsString(jsonobject, "block"), optional1);
                } else if (jsonobject.has("entity")) {
                    mutablecomponent = new NbtComponent.EntityNbtComponent(s1, flag, GsonHelper.getAsString(jsonobject, "entity"), optional1);
                } else {
                    if (!jsonobject.has("storage")) {
                        throw new JsonParseException("Don't know how to turn " + p_130694_ + " into a Component");
                    }
                    mutablecomponent = new NbtComponent.StorageNbtComponent(s1, flag, new ResourceLocation(GsonHelper.getAsString(jsonobject, "storage")), optional1);
                }
            }
            if (jsonobject.has("extra")) {
                JsonArray jsonarray2 = GsonHelper.getAsJsonArray(jsonobject, "extra");
                if (jsonarray2.size() <= 0) {
                    throw new JsonParseException("Unexpected empty array of components");
                }
                int j = 0;
                while (j < jsonarray2.size()) {
                    mutablecomponent.append(this.deserialize(jsonarray2.get(j), p_130695_, p_130696_));
                    ++j;
                }
            }
            mutablecomponent.setStyle((Style)p_130696_.deserialize(p_130694_, Style.class));
            return mutablecomponent;
        }

        private Optional<Component> parseSeparator(Type pType, JsonDeserializationContext pJsonContext, JsonObject pJsonObject) {
            return pJsonObject.has("separator") ? Optional.of(this.deserialize(pJsonObject.get("separator"), pType, pJsonContext)) : Optional.empty();
        }

        private void serializeStyle(Style pStyle, JsonObject pObject, JsonSerializationContext pCtx) {
            JsonElement jsonelement = pCtx.serialize((Object)pStyle);
            if (jsonelement.isJsonObject()) {
                JsonObject jsonobject = (JsonObject)jsonelement;
                for (Map.Entry entry : jsonobject.entrySet()) {
                    pObject.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
        }

        public JsonElement serialize(Component p_130706_, Type p_130707_, JsonSerializationContext p_130708_) {
            JsonObject jsonobject = new JsonObject();
            if (!p_130706_.getStyle().isEmpty()) {
                this.serializeStyle(p_130706_.getStyle(), jsonobject, p_130708_);
            }
            if (!p_130706_.getSiblings().isEmpty()) {
                JsonArray jsonarray = new JsonArray();
                for (Component component : p_130706_.getSiblings()) {
                    jsonarray.add(this.serialize(component, component.getClass(), p_130708_));
                }
                jsonobject.add("extra", (JsonElement)jsonarray);
            }
            if (p_130706_ instanceof TextComponent) {
                jsonobject.addProperty("text", ((TextComponent)p_130706_).getText());
            } else if (p_130706_ instanceof TranslatableComponent) {
                TranslatableComponent translatablecomponent = (TranslatableComponent)p_130706_;
                jsonobject.addProperty("translate", translatablecomponent.getKey());
                if (translatablecomponent.getArgs() != null && translatablecomponent.getArgs().length > 0) {
                    JsonArray jsonarray1 = new JsonArray();
                    Object[] objectArray = translatablecomponent.getArgs();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        if (object instanceof Component) {
                            jsonarray1.add(this.serialize((Component)object, object.getClass(), p_130708_));
                        } else {
                            jsonarray1.add((JsonElement)new JsonPrimitive(String.valueOf(object)));
                        }
                        ++n2;
                    }
                    jsonobject.add("with", (JsonElement)jsonarray1);
                }
            } else if (p_130706_ instanceof ScoreComponent) {
                ScoreComponent scorecomponent = (ScoreComponent)p_130706_;
                JsonObject jsonobject1 = new JsonObject();
                jsonobject1.addProperty("name", scorecomponent.getName());
                jsonobject1.addProperty("objective", scorecomponent.getObjective());
                jsonobject.add("score", (JsonElement)jsonobject1);
            } else if (p_130706_ instanceof SelectorComponent) {
                SelectorComponent selectorcomponent = (SelectorComponent)p_130706_;
                jsonobject.addProperty("selector", selectorcomponent.getPattern());
                this.serializeSeparator(p_130708_, jsonobject, selectorcomponent.getSeparator());
            } else if (p_130706_ instanceof KeybindComponent) {
                KeybindComponent keybindcomponent = (KeybindComponent)p_130706_;
                jsonobject.addProperty("keybind", keybindcomponent.getName());
            } else {
                if (!(p_130706_ instanceof NbtComponent)) {
                    throw new IllegalArgumentException("Don't know how to serialize " + p_130706_ + " as a Component");
                }
                NbtComponent nbtcomponent = (NbtComponent)p_130706_;
                jsonobject.addProperty("nbt", nbtcomponent.getNbtPath());
                jsonobject.addProperty("interpret", Boolean.valueOf(nbtcomponent.isInterpreting()));
                this.serializeSeparator(p_130708_, jsonobject, nbtcomponent.separator);
                if (p_130706_ instanceof NbtComponent.BlockNbtComponent) {
                    NbtComponent.BlockNbtComponent nbtcomponent$blocknbtcomponent = (NbtComponent.BlockNbtComponent)p_130706_;
                    jsonobject.addProperty("block", nbtcomponent$blocknbtcomponent.getPos());
                } else if (p_130706_ instanceof NbtComponent.EntityNbtComponent) {
                    NbtComponent.EntityNbtComponent nbtcomponent$entitynbtcomponent = (NbtComponent.EntityNbtComponent)p_130706_;
                    jsonobject.addProperty("entity", nbtcomponent$entitynbtcomponent.getSelector());
                } else {
                    if (!(p_130706_ instanceof NbtComponent.StorageNbtComponent)) {
                        throw new IllegalArgumentException("Don't know how to serialize " + p_130706_ + " as a Component");
                    }
                    NbtComponent.StorageNbtComponent nbtcomponent$storagenbtcomponent = (NbtComponent.StorageNbtComponent)p_130706_;
                    jsonobject.addProperty("storage", nbtcomponent$storagenbtcomponent.getId().toString());
                }
            }
            return jsonobject;
        }

        private void serializeSeparator(JsonSerializationContext p_178412_, JsonObject p_178413_, Optional<Component> p_178414_) {
            p_178414_.ifPresent(p_178410_ -> p_178413_.add("separator", this.serialize((Component)p_178410_, (Type)p_178410_.getClass(), p_178412_)));
        }

        public static String toJson(Component pComponent) {
            return GSON.toJson((Object)pComponent);
        }

        public static JsonElement toJsonTree(Component pComponent) {
            return GSON.toJsonTree((Object)pComponent);
        }

        @Nullable
        public static MutableComponent fromJson(String pJson) {
            return GsonHelper.fromJson(GSON, pJson, MutableComponent.class, false);
        }

        @Nullable
        public static MutableComponent fromJson(JsonElement pJson) {
            return (MutableComponent)GSON.fromJson(pJson, MutableComponent.class);
        }

        @Nullable
        public static MutableComponent fromJsonLenient(String p_130715_) {
            return GsonHelper.fromJson(GSON, p_130715_, MutableComponent.class, true);
        }

        public static MutableComponent fromJson(com.mojang.brigadier.StringReader pJson) {
            try {
                JsonReader jsonreader = new JsonReader((Reader)new StringReader(pJson.getRemaining()));
                jsonreader.setLenient(false);
                MutableComponent mutablecomponent = (MutableComponent)GSON.getAdapter(MutableComponent.class).read(jsonreader);
                pJson.setCursor(pJson.getCursor() + Serializer.getPos(jsonreader));
                return mutablecomponent;
            }
            catch (IOException | StackOverflowError ioexception) {
                throw new JsonParseException(ioexception);
            }
        }

        private static int getPos(JsonReader pReader) {
            try {
                return JSON_READER_POS.getInt(pReader) - JSON_READER_LINESTART.getInt(pReader) + 1;
            }
            catch (IllegalAccessException illegalaccessexception) {
                throw new IllegalStateException("Couldn't read position of JsonReader", illegalaccessexception);
            }
        }
    }
}

