/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Unit;

public interface FormattedText {
    public static final Optional<Unit> STOP_ITERATION = Optional.of(Unit.INSTANCE);
    public static final FormattedText EMPTY = new FormattedText(){

        @Override
        public <T> Optional<T> visit(ContentConsumer<T> p_130779_) {
            return Optional.empty();
        }

        @Override
        public <T> Optional<T> visit(StyledContentConsumer<T> p_130781_, Style p_130782_) {
            return Optional.empty();
        }
    };

    public <T> Optional<T> visit(ContentConsumer<T> var1);

    public <T> Optional<T> visit(StyledContentConsumer<T> var1, Style var2);

    public static FormattedText of(String p_130776_) {
        return new FormattedText(){

            @Override
            public <T> Optional<T> visit(ContentConsumer<T> p_130787_) {
                return p_130787_.accept(p_130776_);
            }

            @Override
            public <T> Optional<T> visit(StyledContentConsumer<T> p_130789_, Style p_130790_) {
                return p_130789_.accept(p_130790_, p_130776_);
            }
        };
    }

    public static FormattedText of(String pText, Style pStyle) {
        return new FormattedText(){

            @Override
            public <T> Optional<T> visit(ContentConsumer<T> p_130797_) {
                return p_130797_.accept(pText);
            }

            @Override
            public <T> Optional<T> visit(StyledContentConsumer<T> p_130799_, Style p_130800_) {
                return p_130799_.accept(pStyle.applyTo(p_130800_), pText);
            }
        };
    }

    public static FormattedText a(FormattedText ... p_130774_) {
        return FormattedText.composite((List<? extends FormattedText>)ImmutableList.copyOf((Object[])p_130774_));
    }

    public static FormattedText composite(List<? extends FormattedText> pElements) {
        return new FormattedText(){

            @Override
            public <T> Optional<T> visit(ContentConsumer<T> p_130805_) {
                for (FormattedText formattedtext : pElements) {
                    Optional<T> optional = formattedtext.visit(p_130805_);
                    if (!optional.isPresent()) continue;
                    return optional;
                }
                return Optional.empty();
            }

            @Override
            public <T> Optional<T> visit(StyledContentConsumer<T> p_130807_, Style p_130808_) {
                for (FormattedText formattedtext : pElements) {
                    Optional<T> optional = formattedtext.visit(p_130807_, p_130808_);
                    if (!optional.isPresent()) continue;
                    return optional;
                }
                return Optional.empty();
            }
        };
    }

    default public String getString() {
        StringBuilder stringbuilder = new StringBuilder();
        this.visit(p_130767_ -> {
            stringbuilder.append(p_130767_);
            return Optional.empty();
        });
        return stringbuilder.toString();
    }

    public static interface ContentConsumer<T> {
        public Optional<T> accept(String var1);
    }

    public static interface StyledContentConsumer<T> {
        public Optional<T> accept(Style var1, String var2);
    }
}

