/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;

public class KeybindComponent
extends BaseComponent {
    private static Function<String, Supplier<Component>> keyResolver = p_130928_ -> () -> new TextComponent((String)p_130928_);
    private final String name;
    private Supplier<Component> nameResolver;

    public KeybindComponent(String pName) {
        this.name = pName;
    }

    public static void setKeyResolver(Function<String, Supplier<Component>> pKeyResolver) {
        keyResolver = pKeyResolver;
    }

    private Component getNestedComponent() {
        if (this.nameResolver == null) {
            this.nameResolver = keyResolver.apply(this.name);
        }
        return this.nameResolver.get();
    }

    @Override
    public <T> Optional<T> visitSelf(FormattedText.ContentConsumer<T> pConsumer) {
        return this.getNestedComponent().visit(pConsumer);
    }

    @Override
    public <T> Optional<T> visitSelf(FormattedText.StyledContentConsumer<T> pConsumer, Style pStyle) {
        return this.getNestedComponent().visit(pConsumer, pStyle);
    }

    @Override
    public KeybindComponent plainCopy() {
        return new KeybindComponent(this.name);
    }

    @Override
    public boolean equals(Object p_130932_) {
        if (this == p_130932_) {
            return true;
        }
        if (!(p_130932_ instanceof KeybindComponent)) {
            return false;
        }
        KeybindComponent keybindcomponent = (KeybindComponent)p_130932_;
        return this.name.equals(keybindcomponent.name) && super.equals(p_130932_);
    }

    @Override
    public String toString() {
        return "KeybindComponent{keybind='" + this.name + "', siblings=" + this.siblings + ", style=" + this.getStyle() + "}";
    }

    public String getName() {
        return this.name;
    }
}

