/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.ContextAwareComponent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import org.slf4j.Logger;

public class SelectorComponent
extends BaseComponent
implements ContextAwareComponent {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String pattern;
    @Nullable
    private final EntitySelector selector;
    protected final Optional<Component> separator;

    public SelectorComponent(String pPattern, Optional<Component> pSeparator) {
        this.pattern = pPattern;
        this.separator = pSeparator;
        EntitySelector entityselector = null;
        try {
            EntitySelectorParser entityselectorparser = new EntitySelectorParser(new StringReader(pPattern));
            entityselector = entityselectorparser.parse();
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            LOGGER.warn("Invalid selector component: {}: {}", (Object)pPattern, (Object)commandsyntaxexception.getMessage());
        }
        this.selector = entityselector;
    }

    public String getPattern() {
        return this.pattern;
    }

    @Nullable
    public EntitySelector getSelector() {
        return this.selector;
    }

    public Optional<Component> getSeparator() {
        return this.separator;
    }

    @Override
    public MutableComponent resolve(@Nullable CommandSourceStack pCommandSourceStack, @Nullable Entity pEntity, int pRecursionDepth) throws CommandSyntaxException {
        if (pCommandSourceStack != null && this.selector != null) {
            Optional<MutableComponent> optional = ComponentUtils.updateForEntity(pCommandSourceStack, this.separator, pEntity, pRecursionDepth);
            return ComponentUtils.formatList(this.selector.findEntities(pCommandSourceStack), optional, Entity::getDisplayName);
        }
        return new TextComponent("");
    }

    @Override
    public String getContents() {
        return this.pattern;
    }

    @Override
    public SelectorComponent plainCopy() {
        return new SelectorComponent(this.pattern, this.separator);
    }

    @Override
    public boolean equals(Object p_131094_) {
        if (this == p_131094_) {
            return true;
        }
        if (!(p_131094_ instanceof SelectorComponent)) {
            return false;
        }
        SelectorComponent selectorcomponent = (SelectorComponent)p_131094_;
        return this.pattern.equals(selectorcomponent.pattern) && super.equals(p_131094_);
    }

    @Override
    public String toString() {
        return "SelectorComponent{pattern='" + this.pattern + "', siblings=" + this.siblings + ", style=" + this.getStyle() + "}";
    }
}

