/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.ContextAwareComponent;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableFormatException;
import net.minecraft.world.entity.Entity;

public class TranslatableComponent
extends BaseComponent
implements ContextAwareComponent {
    private static final Object[] NO_ARGS = new Object[0];
    private static final FormattedText TEXT_PERCENT = FormattedText.of("%");
    private static final FormattedText TEXT_NULL = FormattedText.of("null");
    private final String key;
    private final Object[] args;
    @Nullable
    private Language decomposedWith;
    private List<FormattedText> decomposedParts = ImmutableList.of();
    private static final Pattern FORMAT_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    public TranslatableComponent(String pKey) {
        this.key = pKey;
        this.args = NO_ARGS;
    }

    public TranslatableComponent(String pKey, Object ... pArgs) {
        this.key = pKey;
        this.args = pArgs;
    }

    private void decompose() {
        Language language = Language.getInstance();
        if (language != this.decomposedWith) {
            this.decomposedWith = language;
            String s = language.getOrDefault(this.key);
            try {
                ImmutableList.Builder builder = ImmutableList.builder();
                this.decomposeTemplate(s, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                this.decomposedParts = builder.build();
            }
            catch (TranslatableFormatException translatableformatexception) {
                this.decomposedParts = ImmutableList.of((Object)FormattedText.of(s));
            }
        }
    }

    private void decomposeTemplate(String p_200006_, Consumer<FormattedText> p_200007_) {
        Matcher matcher = FORMAT_PATTERN.matcher(p_200006_);
        try {
            int i = 0;
            int j = 0;
            while (matcher.find(j)) {
                int k = matcher.start();
                int l = matcher.end();
                if (k > j) {
                    String s = p_200006_.substring(j, k);
                    if (s.indexOf(37) != -1) {
                        throw new IllegalArgumentException();
                    }
                    p_200007_.accept(FormattedText.of(s));
                }
                String s4 = matcher.group(2);
                String s1 = p_200006_.substring(k, l);
                if ("%".equals(s4) && "%%".equals(s1)) {
                    p_200007_.accept(TEXT_PERCENT);
                } else {
                    int i1;
                    if (!"s".equals(s4)) {
                        throw new TranslatableFormatException(this, "Unsupported format: '" + s1 + "'");
                    }
                    String s2 = matcher.group(1);
                    int n = i1 = s2 != null ? Integer.parseInt(s2) - 1 : i++;
                    if (i1 < this.args.length) {
                        p_200007_.accept(this.getArgument(i1));
                    }
                }
                j = l;
            }
            if (j < p_200006_.length()) {
                String s3 = p_200006_.substring(j);
                if (s3.indexOf(37) != -1) {
                    throw new IllegalArgumentException();
                }
                p_200007_.accept(FormattedText.of(s3));
            }
        }
        catch (IllegalArgumentException illegalargumentexception) {
            throw new TranslatableFormatException(this, (Throwable)illegalargumentexception);
        }
    }

    private FormattedText getArgument(int pIndex) {
        if (pIndex >= this.args.length) {
            throw new TranslatableFormatException(this, pIndex);
        }
        Object object = this.args[pIndex];
        if (object instanceof Component) {
            return (Component)object;
        }
        return object == null ? TEXT_NULL : FormattedText.of(object.toString());
    }

    @Override
    public TranslatableComponent plainCopy() {
        return new TranslatableComponent(this.key, this.args);
    }

    @Override
    public <T> Optional<T> visitSelf(FormattedText.StyledContentConsumer<T> pConsumer, Style pStyle) {
        this.decompose();
        for (FormattedText formattedtext : this.decomposedParts) {
            Optional<T> optional = formattedtext.visit(pConsumer, pStyle);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<T> visitSelf(FormattedText.ContentConsumer<T> pConsumer) {
        this.decompose();
        for (FormattedText formattedtext : this.decomposedParts) {
            Optional<T> optional = formattedtext.visit(pConsumer);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    public MutableComponent resolve(@Nullable CommandSourceStack pCommandSourceStack, @Nullable Entity pEntity, int pRecursionDepth) throws CommandSyntaxException {
        Object[] aobject = new Object[this.args.length];
        int i = 0;
        while (i < aobject.length) {
            Object object = this.args[i];
            aobject[i] = object instanceof Component ? ComponentUtils.updateForEntity(pCommandSourceStack, (Component)object, pEntity, pRecursionDepth) : object;
            ++i;
        }
        return new TranslatableComponent(this.key, aobject);
    }

    @Override
    public boolean equals(Object p_131324_) {
        if (this == p_131324_) {
            return true;
        }
        if (!(p_131324_ instanceof TranslatableComponent)) {
            return false;
        }
        TranslatableComponent translatablecomponent = (TranslatableComponent)p_131324_;
        return Arrays.equals(this.args, translatablecomponent.args) && this.key.equals(translatablecomponent.key) && super.equals(p_131324_);
    }

    @Override
    public int hashCode() {
        int i = super.hashCode();
        i = 31 * i + this.key.hashCode();
        return 31 * i + Arrays.hashCode(this.args);
    }

    @Override
    public String toString() {
        return "TranslatableComponent{key='" + this.key + "', args=" + Arrays.toString(this.args) + ", siblings=" + this.siblings + ", style=" + this.getStyle() + "}";
    }

    public String getKey() {
        return this.key;
    }

    public Object[] getArgs() {
        return this.args;
    }
}

