/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public record ClientboundBlockBreakAckPacket(BlockPos pos, BlockState state, ServerboundPlayerActionPacket.Action action, boolean allGood) implements Packet<ClientGamePacketListener>
{
    private static final Logger LOGGER = LogUtils.getLogger();

    public ClientboundBlockBreakAckPacket(BlockPos pPos, BlockState pState, ServerboundPlayerActionPacket.Action pAction, boolean pAllGood, String pReason) {
        this(pPos, pState, pAction, pAllGood);
    }

    public ClientboundBlockBreakAckPacket(BlockPos pos, BlockState state, ServerboundPlayerActionPacket.Action action, boolean allGood) {
        this.pos = pos = pos.immutable();
        this.state = state;
        this.action = action;
        this.allGood = allGood;
    }

    public ClientboundBlockBreakAckPacket(FriendlyByteBuf pBuffer) {
        this(pBuffer.readBlockPos(), Block.BLOCK_STATE_REGISTRY.byId(pBuffer.readVarInt()), pBuffer.readEnum(ServerboundPlayerActionPacket.Action.class), pBuffer.readBoolean());
    }

    @Override
    public void write(FriendlyByteBuf pBuffer) {
        pBuffer.writeBlockPos(this.pos);
        pBuffer.writeVarInt(Block.getId(this.state));
        pBuffer.writeEnum(this.action);
        pBuffer.writeBoolean(this.allGood);
    }

    @Override
    public void handle(ClientGamePacketListener pHandler) {
        pHandler.handleBlockBreakAck(this);
    }
}

