/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.UUID;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.BossEvent;

public class ClientboundBossEventPacket
implements Packet<ClientGamePacketListener> {
    private static final int FLAG_DARKEN = 1;
    private static final int FLAG_MUSIC = 2;
    private static final int FLAG_FOG = 4;
    private final UUID id;
    private final Operation operation;
    static final Operation REMOVE_OPERATION = new Operation(){

        @Override
        public OperationType getType() {
            return OperationType.REMOVE;
        }

        @Override
        public void dispatch(UUID p_178660_, Handler p_178661_) {
            p_178661_.remove(p_178660_);
        }

        @Override
        public void write(FriendlyByteBuf p_178663_) {
        }
    };

    private ClientboundBossEventPacket(UUID pId, Operation pOperation) {
        this.id = pId;
        this.operation = pOperation;
    }

    public ClientboundBossEventPacket(FriendlyByteBuf pBuffer) {
        this.id = pBuffer.readUUID();
        OperationType clientboundbosseventpacket$operationtype = pBuffer.readEnum(OperationType.class);
        this.operation = clientboundbosseventpacket$operationtype.reader.apply(pBuffer);
    }

    public static ClientboundBossEventPacket createAddPacket(BossEvent pEvent) {
        return new ClientboundBossEventPacket(pEvent.getId(), new AddOperation(pEvent));
    }

    public static ClientboundBossEventPacket createRemovePacket(UUID pId) {
        return new ClientboundBossEventPacket(pId, REMOVE_OPERATION);
    }

    public static ClientboundBossEventPacket createUpdateProgressPacket(BossEvent pEvent) {
        return new ClientboundBossEventPacket(pEvent.getId(), new UpdateProgressOperation(pEvent.getProgress()));
    }

    public static ClientboundBossEventPacket createUpdateNamePacket(BossEvent pEvent) {
        return new ClientboundBossEventPacket(pEvent.getId(), new UpdateNameOperation(pEvent.getName()));
    }

    public static ClientboundBossEventPacket createUpdateStylePacket(BossEvent pEvent) {
        return new ClientboundBossEventPacket(pEvent.getId(), new UpdateStyleOperation(pEvent.getColor(), pEvent.getOverlay()));
    }

    public static ClientboundBossEventPacket createUpdatePropertiesPacket(BossEvent pEvent) {
        return new ClientboundBossEventPacket(pEvent.getId(), new UpdatePropertiesOperation(pEvent.shouldDarkenScreen(), pEvent.shouldPlayBossMusic(), pEvent.shouldCreateWorldFog()));
    }

    @Override
    public void write(FriendlyByteBuf pBuffer) {
        pBuffer.writeUUID(this.id);
        pBuffer.writeEnum(this.operation.getType());
        this.operation.write(pBuffer);
    }

    static int encodeProperties(boolean pDarkenScreen, boolean pPlayMusic, boolean pCreateWorldFog) {
        int i = 0;
        if (pDarkenScreen) {
            i |= 1;
        }
        if (pPlayMusic) {
            i |= 2;
        }
        if (pCreateWorldFog) {
            i |= 4;
        }
        return i;
    }

    @Override
    public void handle(ClientGamePacketListener pHandler) {
        pHandler.handleBossUpdate(this);
    }

    public void dispatch(Handler pHandler) {
        this.operation.dispatch(this.id, pHandler);
    }

    static class AddOperation
    implements Operation {
        private final Component name;
        private final float progress;
        private final BossEvent.BossBarColor color;
        private final BossEvent.BossBarOverlay overlay;
        private final boolean darkenScreen;
        private final boolean playMusic;
        private final boolean createWorldFog;

        AddOperation(BossEvent pBuffer) {
            this.name = pBuffer.getName();
            this.progress = pBuffer.getProgress();
            this.color = pBuffer.getColor();
            this.overlay = pBuffer.getOverlay();
            this.darkenScreen = pBuffer.shouldDarkenScreen();
            this.playMusic = pBuffer.shouldPlayBossMusic();
            this.createWorldFog = pBuffer.shouldCreateWorldFog();
        }

        private AddOperation(FriendlyByteBuf pBuffer) {
            this.name = pBuffer.readComponent();
            this.progress = pBuffer.readFloat();
            this.color = pBuffer.readEnum(BossEvent.BossBarColor.class);
            this.overlay = pBuffer.readEnum(BossEvent.BossBarOverlay.class);
            short i = pBuffer.readUnsignedByte();
            this.darkenScreen = (i & 1) > 0;
            this.playMusic = (i & 2) > 0;
            this.createWorldFog = (i & 4) > 0;
        }

        @Override
        public OperationType getType() {
            return OperationType.ADD;
        }

        @Override
        public void dispatch(UUID pId, Handler pHandler) {
            pHandler.add(pId, this.name, this.progress, this.color, this.overlay, this.darkenScreen, this.playMusic, this.createWorldFog);
        }

        @Override
        public void write(FriendlyByteBuf pBuffer) {
            pBuffer.writeComponent(this.name);
            pBuffer.writeFloat(this.progress);
            pBuffer.writeEnum(this.color);
            pBuffer.writeEnum(this.overlay);
            pBuffer.writeByte(ClientboundBossEventPacket.encodeProperties(this.darkenScreen, this.playMusic, this.createWorldFog));
        }
    }

    public static interface Handler {
        default public void add(UUID pId, Component pName, float pProgress, BossEvent.BossBarColor pColor, BossEvent.BossBarOverlay pOverlay, boolean pDarkenScreen, boolean pPlayMusic, boolean pCreateWorldFog) {
        }

        default public void remove(UUID pId) {
        }

        default public void updateProgress(UUID pId, float pProgress) {
        }

        default public void updateName(UUID pId, Component pName) {
        }

        default public void updateStyle(UUID pId, BossEvent.BossBarColor pColor, BossEvent.BossBarOverlay pOverlay) {
        }

        default public void updateProperties(UUID pId, boolean pDarkenScreen, boolean pPlayMusic, boolean pCreateWorldFog) {
        }
    }

    static interface Operation {
        public OperationType getType();

        public void dispatch(UUID var1, Handler var2);

        public void write(FriendlyByteBuf var1);
    }

    static enum OperationType {
        ADD(friendlyByteBuf -> new AddOperation((FriendlyByteBuf)((Object)friendlyByteBuf))),
        REMOVE(p_178719_ -> REMOVE_OPERATION),
        UPDATE_PROGRESS(friendlyByteBuf -> new UpdateProgressOperation((FriendlyByteBuf)((Object)friendlyByteBuf))),
        UPDATE_NAME(friendlyByteBuf -> new UpdateNameOperation((FriendlyByteBuf)((Object)friendlyByteBuf))),
        UPDATE_STYLE(friendlyByteBuf -> new UpdateStyleOperation((FriendlyByteBuf)((Object)friendlyByteBuf))),
        UPDATE_PROPERTIES(friendlyByteBuf -> new UpdatePropertiesOperation((FriendlyByteBuf)((Object)friendlyByteBuf)));

        final Function<FriendlyByteBuf, Operation> reader;

        private OperationType(Function<FriendlyByteBuf, Operation> p_178716_) {
            this.reader = p_178716_;
        }
    }

    static class UpdateNameOperation
    implements Operation {
        private final Component name;

        UpdateNameOperation(Component pBuffer) {
            this.name = pBuffer;
        }

        private UpdateNameOperation(FriendlyByteBuf pBuffer) {
            this.name = pBuffer.readComponent();
        }

        @Override
        public OperationType getType() {
            return OperationType.UPDATE_NAME;
        }

        @Override
        public void dispatch(UUID pId, Handler pHandler) {
            pHandler.updateName(pId, this.name);
        }

        @Override
        public void write(FriendlyByteBuf pBuffer) {
            pBuffer.writeComponent(this.name);
        }
    }

    static class UpdateProgressOperation
    implements Operation {
        private final float progress;

        UpdateProgressOperation(float pProgress) {
            this.progress = pProgress;
        }

        private UpdateProgressOperation(FriendlyByteBuf pProgress) {
            this.progress = pProgress.readFloat();
        }

        @Override
        public OperationType getType() {
            return OperationType.UPDATE_PROGRESS;
        }

        @Override
        public void dispatch(UUID pId, Handler pHandler) {
            pHandler.updateProgress(pId, this.progress);
        }

        @Override
        public void write(FriendlyByteBuf pBuffer) {
            pBuffer.writeFloat(this.progress);
        }
    }

    static class UpdatePropertiesOperation
    implements Operation {
        private final boolean darkenScreen;
        private final boolean playMusic;
        private final boolean createWorldFog;

        UpdatePropertiesOperation(boolean pDarkenScreen, boolean pPlayMusic, boolean pCreateWorldFog) {
            this.darkenScreen = pDarkenScreen;
            this.playMusic = pPlayMusic;
            this.createWorldFog = pCreateWorldFog;
        }

        private UpdatePropertiesOperation(FriendlyByteBuf pBuffer) {
            short i = pBuffer.readUnsignedByte();
            this.darkenScreen = (i & 1) > 0;
            this.playMusic = (i & 2) > 0;
            this.createWorldFog = (i & 4) > 0;
        }

        @Override
        public OperationType getType() {
            return OperationType.UPDATE_PROPERTIES;
        }

        @Override
        public void dispatch(UUID pId, Handler pHandler) {
            pHandler.updateProperties(pId, this.darkenScreen, this.playMusic, this.createWorldFog);
        }

        @Override
        public void write(FriendlyByteBuf pBuffer) {
            pBuffer.writeByte(ClientboundBossEventPacket.encodeProperties(this.darkenScreen, this.playMusic, this.createWorldFog));
        }
    }

    static class UpdateStyleOperation
    implements Operation {
        private final BossEvent.BossBarColor color;
        private final BossEvent.BossBarOverlay overlay;

        UpdateStyleOperation(BossEvent.BossBarColor pColor, BossEvent.BossBarOverlay pOverlay) {
            this.color = pColor;
            this.overlay = pOverlay;
        }

        private UpdateStyleOperation(FriendlyByteBuf pBuffer) {
            this.color = pBuffer.readEnum(BossEvent.BossBarColor.class);
            this.overlay = pBuffer.readEnum(BossEvent.BossBarOverlay.class);
        }

        @Override
        public OperationType getType() {
            return OperationType.UPDATE_STYLE;
        }

        @Override
        public void dispatch(UUID pId, Handler pHandler) {
            pHandler.updateStyle(pId, this.color, this.overlay);
        }

        @Override
        public void write(FriendlyByteBuf pBuffer) {
            pBuffer.writeEnum(this.color);
            pBuffer.writeEnum(this.overlay);
        }
    }
}

