/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.Difficulty;

public class ClientboundChangeDifficultyPacket
implements Packet<ClientGamePacketListener> {
    private final Difficulty difficulty;
    private final boolean locked;

    public ClientboundChangeDifficultyPacket(Difficulty pDifficulty, boolean pLocked) {
        this.difficulty = pDifficulty;
        this.locked = pLocked;
    }

    public ClientboundChangeDifficultyPacket(FriendlyByteBuf pBuffer) {
        this.difficulty = Difficulty.byId(pBuffer.readUnsignedByte());
        this.locked = pBuffer.readBoolean();
    }

    @Override
    public void write(FriendlyByteBuf pBuffer) {
        pBuffer.writeByte(this.difficulty.getId());
        pBuffer.writeBoolean(this.locked);
    }

    @Override
    public void handle(ClientGamePacketListener pHandler) {
        pHandler.handleChangeDifficulty(this);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public Difficulty getDifficulty() {
        return this.difficulty;
    }
}

