/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;

public class ClientboundChatPacket
implements Packet<ClientGamePacketListener> {
    private final Component message;
    private final ChatType type;
    private final UUID sender;

    public ClientboundChatPacket(Component pMessage, ChatType pType, UUID pSender) {
        this.message = pMessage;
        this.type = pType;
        this.sender = pSender;
    }

    public ClientboundChatPacket(FriendlyByteBuf pBuffer) {
        this.message = pBuffer.readComponent();
        this.type = ChatType.getForIndex(pBuffer.readByte());
        this.sender = pBuffer.readUUID();
    }

    @Override
    public void write(FriendlyByteBuf pBuffer) {
        pBuffer.writeComponent(this.message);
        pBuffer.writeByte(this.type.getIndex());
        pBuffer.writeUUID(this.sender);
    }

    @Override
    public void handle(ClientGamePacketListener pHandler) {
        pHandler.handleChat(this);
    }

    public Component getMessage() {
        return this.message;
    }

    public ChatType getType() {
        return this.type;
    }

    public UUID getSender() {
        return this.sender;
    }

    @Override
    public boolean isSkippable() {
        return true;
    }
}

