/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;

public class ClientboundCommandsPacket
implements Packet<ClientGamePacketListener> {
    private static final byte MASK_TYPE = 3;
    private static final byte FLAG_EXECUTABLE = 4;
    private static final byte FLAG_REDIRECT = 8;
    private static final byte FLAG_CUSTOM_SUGGESTIONS = 16;
    private static final byte TYPE_ROOT = 0;
    private static final byte TYPE_LITERAL = 1;
    private static final byte TYPE_ARGUMENT = 2;
    private final RootCommandNode<SharedSuggestionProvider> root;

    public ClientboundCommandsPacket(RootCommandNode<SharedSuggestionProvider> pRoot) {
        this.root = pRoot;
    }

    public ClientboundCommandsPacket(FriendlyByteBuf pRoot) {
        List<Entry> list = pRoot.readList(ClientboundCommandsPacket::readNode);
        ClientboundCommandsPacket.resolveEntries(list);
        int i = pRoot.readVarInt();
        this.root = (RootCommandNode)list.get((int)i).node;
    }

    @Override
    public void write(FriendlyByteBuf pBuffer) {
        Object2IntMap<CommandNode<SharedSuggestionProvider>> object2intmap = ClientboundCommandsPacket.enumerateNodes(this.root);
        List<CommandNode<SharedSuggestionProvider>> list = ClientboundCommandsPacket.getNodesInIdOrder(object2intmap);
        pBuffer.writeCollection(list, (p_178810_, p_178811_) -> ClientboundCommandsPacket.writeNode(p_178810_, (CommandNode<SharedSuggestionProvider>)p_178811_, (Map<CommandNode<SharedSuggestionProvider>, Integer>)object2intmap));
        pBuffer.writeVarInt(object2intmap.get(this.root));
    }

    private static void resolveEntries(List<Entry> pEntries) {
        ArrayList list = Lists.newArrayList(pEntries);
        while (!list.isEmpty()) {
            boolean flag = list.removeIf(p_178816_ -> p_178816_.build(pEntries));
            if (flag) continue;
            throw new IllegalStateException("Server sent an impossible command tree");
        }
    }

    private static Object2IntMap<CommandNode<SharedSuggestionProvider>> enumerateNodes(RootCommandNode<SharedSuggestionProvider> pRootNode) {
        CommandNode commandnode;
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        ArrayDeque queue = Queues.newArrayDeque();
        queue.add(pRootNode);
        while ((commandnode = (CommandNode)queue.poll()) != null) {
            if (object2intmap.containsKey((Object)commandnode)) continue;
            int i = object2intmap.size();
            object2intmap.put((Object)commandnode, i);
            queue.addAll(commandnode.getChildren());
            if (commandnode.getRedirect() == null) continue;
            queue.add(commandnode.getRedirect());
        }
        return object2intmap;
    }

    private static List<CommandNode<SharedSuggestionProvider>> getNodesInIdOrder(Object2IntMap<CommandNode<SharedSuggestionProvider>> pNodeToIdMap) {
        ObjectArrayList objectarraylist = new ObjectArrayList(pNodeToIdMap.size());
        objectarraylist.size(pNodeToIdMap.size());
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(pNodeToIdMap)) {
            objectarraylist.set(entry.getIntValue(), (Object)((CommandNode)entry.getKey()));
        }
        return objectarraylist;
    }

    private static Entry readNode(FriendlyByteBuf p_131888_) {
        byte b0 = p_131888_.readByte();
        int[] aint = p_131888_.readVarIntArray();
        int i = (b0 & 8) != 0 ? p_131888_.readVarInt() : 0;
        ArgumentBuilder<SharedSuggestionProvider, ?> argumentbuilder = ClientboundCommandsPacket.createBuilder(p_131888_, b0);
        return new Entry(argumentbuilder, b0, i, aint);
    }

    @Nullable
    private static ArgumentBuilder<SharedSuggestionProvider, ?> createBuilder(FriendlyByteBuf pBuffer, byte pFlags) {
        int i = pFlags & 3;
        if (i == 2) {
            String s = pBuffer.readUtf();
            ArgumentType<?> argumenttype = ArgumentTypes.deserialize(pBuffer);
            if (argumenttype == null) {
                return null;
            }
            RequiredArgumentBuilder requiredargumentbuilder = RequiredArgumentBuilder.argument((String)s, argumenttype);
            if ((pFlags & 0x10) != 0) {
                requiredargumentbuilder.suggests(SuggestionProviders.getProvider(pBuffer.readResourceLocation()));
            }
            return requiredargumentbuilder;
        }
        return i == 1 ? LiteralArgumentBuilder.literal((String)pBuffer.readUtf()) : null;
    }

    private static void writeNode(FriendlyByteBuf pBuffer, CommandNode<SharedSuggestionProvider> pNode, Map<CommandNode<SharedSuggestionProvider>, Integer> pNodeIds) {
        int b0 = 0;
        if (pNode.getRedirect() != null) {
            b0 = (byte)(b0 | 8);
        }
        if (pNode.getCommand() != null) {
            b0 = (byte)(b0 | 4);
        }
        if (pNode instanceof RootCommandNode) {
            b0 = (byte)b0;
        } else if (pNode instanceof ArgumentCommandNode) {
            b0 = (byte)(b0 | 2);
            if (((ArgumentCommandNode)pNode).getCustomSuggestions() != null) {
                b0 = (byte)(b0 | 0x10);
            }
        } else {
            if (!(pNode instanceof LiteralCommandNode)) {
                throw new UnsupportedOperationException("Unknown node type " + pNode);
            }
            b0 = (byte)(b0 | 1);
        }
        pBuffer.writeByte(b0);
        pBuffer.writeVarInt(pNode.getChildren().size());
        for (CommandNode commandnode : pNode.getChildren()) {
            pBuffer.writeVarInt(pNodeIds.get(commandnode));
        }
        if (pNode.getRedirect() != null) {
            pBuffer.writeVarInt(pNodeIds.get(pNode.getRedirect()));
        }
        if (pNode instanceof ArgumentCommandNode) {
            ArgumentCommandNode argumentcommandnode = (ArgumentCommandNode)pNode;
            pBuffer.writeUtf(argumentcommandnode.getName());
            ArgumentTypes.serialize(pBuffer, argumentcommandnode.getType());
            if (argumentcommandnode.getCustomSuggestions() != null) {
                pBuffer.writeResourceLocation(SuggestionProviders.getName((SuggestionProvider<SharedSuggestionProvider>)argumentcommandnode.getCustomSuggestions()));
            }
        } else if (pNode instanceof LiteralCommandNode) {
            pBuffer.writeUtf(((LiteralCommandNode)pNode).getLiteral());
        }
    }

    @Override
    public void handle(ClientGamePacketListener pHandler) {
        pHandler.handleCommands(this);
    }

    public RootCommandNode<SharedSuggestionProvider> getRoot() {
        return this.root;
    }

    static class Entry {
        @Nullable
        private final ArgumentBuilder<SharedSuggestionProvider, ?> builder;
        private final byte flags;
        private final int redirect;
        private final int[] children;
        @Nullable
        CommandNode<SharedSuggestionProvider> node;

        Entry(@Nullable ArgumentBuilder<SharedSuggestionProvider, ?> pBuilder, byte pFlags, int pRedirect, int[] pChildren) {
            this.builder = pBuilder;
            this.flags = pFlags;
            this.redirect = pRedirect;
            this.children = pChildren;
        }

        public boolean build(List<Entry> pEntries) {
            if (this.node == null) {
                if (this.builder == null) {
                    this.node = new RootCommandNode();
                } else {
                    if ((this.flags & 8) != 0) {
                        if (pEntries.get((int)this.redirect).node == null) {
                            return false;
                        }
                        this.builder.redirect(pEntries.get((int)this.redirect).node);
                    }
                    if ((this.flags & 4) != 0) {
                        this.builder.executes(p_131906_ -> 0);
                    }
                    this.node = this.builder.build();
                }
            }
            int[] nArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                if (pEntries.get((int)i).node == null) {
                    return false;
                }
                ++n2;
            }
            nArray = this.children;
            n = this.children.length;
            n2 = 0;
            while (n2 < n) {
                int j = nArray[n2];
                CommandNode<SharedSuggestionProvider> commandnode = pEntries.get((int)j).node;
                if (!(commandnode instanceof RootCommandNode)) {
                    this.node.addChild(commandnode);
                }
                ++n2;
            }
            return true;
        }
    }
}

