/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Sets;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;

public final class ClientboundLoginPacket
extends Record
implements Packet<ClientGamePacketListener> {
    private final int playerId;
    private final boolean hardcore;
    private final GameType gameType;
    @Nullable
    private final GameType previousGameType;
    private final Set<ResourceKey<Level>> levels;
    private final RegistryAccess.Frozen registryHolder;
    private final Holder<DimensionType> dimensionType;
    private final ResourceKey<Level> dimension;
    private final long seed;
    private final int maxPlayers;
    private final int chunkRadius;
    private final int simulationDistance;
    private final boolean reducedDebugInfo;
    private final boolean showDeathScreen;
    private final boolean isDebug;
    private final boolean isFlat;

    public ClientboundLoginPacket(FriendlyByteBuf pBuffer) {
        this(pBuffer.readInt(), pBuffer.readBoolean(), GameType.byId(pBuffer.readByte()), GameType.byNullableId(pBuffer.readByte()), pBuffer.readCollection(Sets::newHashSetWithExpectedSize, p_178965_ -> ResourceKey.create(Registry.DIMENSION_REGISTRY, p_178965_.readResourceLocation())), pBuffer.readWithCodec(RegistryAccess.NETWORK_CODEC).freeze(), pBuffer.readWithCodec(DimensionType.CODEC), ResourceKey.create(Registry.DIMENSION_REGISTRY, pBuffer.readResourceLocation()), pBuffer.readLong(), pBuffer.readVarInt(), pBuffer.readVarInt(), pBuffer.readVarInt(), pBuffer.readBoolean(), pBuffer.readBoolean(), pBuffer.readBoolean(), pBuffer.readBoolean());
    }

    @Override
    public void write(FriendlyByteBuf pBuffer) {
        pBuffer.writeInt(this.playerId);
        pBuffer.writeBoolean(this.hardcore);
        pBuffer.writeByte(this.gameType.getId());
        pBuffer.writeByte(GameType.getNullableId(this.previousGameType));
        pBuffer.writeCollection(this.levels, (p_178962_, p_178963_) -> p_178962_.writeResourceLocation(p_178963_.location()));
        pBuffer.writeWithCodec(RegistryAccess.NETWORK_CODEC, this.registryHolder);
        pBuffer.writeWithCodec(DimensionType.CODEC, this.dimensionType);
        pBuffer.writeResourceLocation(this.dimension.location());
        pBuffer.writeLong(this.seed);
        pBuffer.writeVarInt(this.maxPlayers);
        pBuffer.writeVarInt(this.chunkRadius);
        pBuffer.writeVarInt(this.simulationDistance);
        pBuffer.writeBoolean(this.reducedDebugInfo);
        pBuffer.writeBoolean(this.showDeathScreen);
        pBuffer.writeBoolean(this.isDebug);
        pBuffer.writeBoolean(this.isFlat);
    }

    @Override
    public void handle(ClientGamePacketListener pHandler) {
        pHandler.handleLogin(this);
    }

    public int playerId() {
        return this.playerId;
    }

    public boolean hardcore() {
        return this.hardcore;
    }

    public GameType gameType() {
        return this.gameType;
    }

    @Nullable
    public GameType previousGameType() {
        return this.previousGameType;
    }

    public Set<ResourceKey<Level>> levels() {
        return this.levels;
    }

    public RegistryAccess.Frozen registryHolder() {
        return this.registryHolder;
    }

    public Holder<DimensionType> dimensionType() {
        return this.dimensionType;
    }

    public ResourceKey<Level> dimension() {
        return this.dimension;
    }

    public long seed() {
        return this.seed;
    }

    public int maxPlayers() {
        return this.maxPlayers;
    }

    public int chunkRadius() {
        return this.chunkRadius;
    }

    public int simulationDistance() {
        return this.simulationDistance;
    }

    public boolean reducedDebugInfo() {
        return this.reducedDebugInfo;
    }

    public boolean showDeathScreen() {
        return this.showDeathScreen;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public boolean isFlat() {
        return this.isFlat;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ClientboundLoginPacket.class, "playerId;hardcore;gameType;previousGameType;levels;registryHolder;dimensionType;dimension;seed;maxPlayers;chunkRadius;simulationDistance;reducedDebugInfo;showDeathScreen;isDebug;isFlat", "playerId", "hardcore", "gameType", "previousGameType", "levels", "registryHolder", "dimensionType", "dimension", "seed", "maxPlayers", "chunkRadius", "simulationDistance", "reducedDebugInfo", "showDeathScreen", "isDebug", "isFlat"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ClientboundLoginPacket.class, "playerId;hardcore;gameType;previousGameType;levels;registryHolder;dimensionType;dimension;seed;maxPlayers;chunkRadius;simulationDistance;reducedDebugInfo;showDeathScreen;isDebug;isFlat", "playerId", "hardcore", "gameType", "previousGameType", "levels", "registryHolder", "dimensionType", "dimension", "seed", "maxPlayers", "chunkRadius", "simulationDistance", "reducedDebugInfo", "showDeathScreen", "isDebug", "isFlat"}, this);
    }

    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ClientboundLoginPacket.class, "playerId;hardcore;gameType;previousGameType;levels;registryHolder;dimensionType;dimension;seed;maxPlayers;chunkRadius;simulationDistance;reducedDebugInfo;showDeathScreen;isDebug;isFlat", "playerId", "hardcore", "gameType", "previousGameType", "levels", "registryHolder", "dimensionType", "dimension", "seed", "maxPlayers", "chunkRadius", "simulationDistance", "reducedDebugInfo", "showDeathScreen", "isDebug", "isFlat"}, this, object);
    }

    public ClientboundLoginPacket(int n, boolean bl, GameType gameType, GameType gameType2, Set set, RegistryAccess.Frozen frozen, Holder holder, ResourceKey resourceKey, long l, int n2, int n3, int n4, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.playerId = n;
        this.hardcore = bl;
        this.gameType = gameType;
        this.previousGameType = gameType2;
        this.levels = set;
        this.registryHolder = frozen;
        this.dimensionType = holder;
        this.dimension = resourceKey;
        this.seed = l;
        this.maxPlayers = n2;
        this.chunkRadius = n3;
        this.simulationDistance = n4;
        this.reducedDebugInfo = bl2;
        this.showDeathScreen = bl3;
        this.isDebug = bl4;
        this.isFlat = bl5;
    }
}

