/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.damagesource.CombatTracker;

public class ClientboundPlayerCombatKillPacket
implements Packet<ClientGamePacketListener> {
    private final int playerId;
    private final int killerId;
    private final Component message;

    public ClientboundPlayerCombatKillPacket(CombatTracker pCombatTracker, Component pMessage) {
        this(pCombatTracker.getMob().getId(), pCombatTracker.getKillerId(), pMessage);
    }

    public ClientboundPlayerCombatKillPacket(int pPlayerId, int pKillerId, Component pMessage) {
        this.playerId = pPlayerId;
        this.killerId = pKillerId;
        this.message = pMessage;
    }

    public ClientboundPlayerCombatKillPacket(FriendlyByteBuf pBuffer) {
        this.playerId = pBuffer.readVarInt();
        this.killerId = pBuffer.readInt();
        this.message = pBuffer.readComponent();
    }

    @Override
    public void write(FriendlyByteBuf pBuffer) {
        pBuffer.writeVarInt(this.playerId);
        pBuffer.writeInt(this.killerId);
        pBuffer.writeComponent(this.message);
    }

    @Override
    public void handle(ClientGamePacketListener pHandler) {
        pHandler.handlePlayerCombatKill(this);
    }

    @Override
    public boolean isSkippable() {
        return true;
    }

    public int getKillerId() {
        return this.killerId;
    }

    public int getPlayerId() {
        return this.playerId;
    }

    public Component getMessage() {
        return this.message;
    }
}

