/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.RecipeBookSettings;

public class ClientboundRecipePacket
implements Packet<ClientGamePacketListener> {
    private final State state;
    private final List<ResourceLocation> recipes;
    private final List<ResourceLocation> toHighlight;
    private final RecipeBookSettings bookSettings;

    public ClientboundRecipePacket(State pState, Collection<ResourceLocation> pRecipes, Collection<ResourceLocation> pToHighlight, RecipeBookSettings pBookSettings) {
        this.state = pState;
        this.recipes = ImmutableList.copyOf(pRecipes);
        this.toHighlight = ImmutableList.copyOf(pToHighlight);
        this.bookSettings = pBookSettings;
    }

    public ClientboundRecipePacket(FriendlyByteBuf pBuffer) {
        this.state = pBuffer.readEnum(State.class);
        this.bookSettings = RecipeBookSettings.read(pBuffer);
        this.recipes = pBuffer.readList(FriendlyByteBuf::readResourceLocation);
        this.toHighlight = this.state == State.INIT ? pBuffer.readList(FriendlyByteBuf::readResourceLocation) : ImmutableList.of();
    }

    @Override
    public void write(FriendlyByteBuf pBuffer) {
        pBuffer.writeEnum(this.state);
        this.bookSettings.write(pBuffer);
        pBuffer.writeCollection(this.recipes, FriendlyByteBuf::writeResourceLocation);
        if (this.state == State.INIT) {
            pBuffer.writeCollection(this.toHighlight, FriendlyByteBuf::writeResourceLocation);
        }
    }

    @Override
    public void handle(ClientGamePacketListener pHandler) {
        pHandler.handleAddOrRemoveRecipes(this);
    }

    public List<ResourceLocation> getRecipes() {
        return this.recipes;
    }

    public List<ResourceLocation> getHighlights() {
        return this.toHighlight;
    }

    public RecipeBookSettings getBookSettings() {
        return this.bookSettings;
    }

    public State getState() {
        return this.state;
    }

    public static enum State {
        INIT,
        ADD,
        REMOVE;

    }
}

