/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.scores.Objective;

public class ClientboundSetDisplayObjectivePacket
implements Packet<ClientGamePacketListener> {
    private final int slot;
    private final String objectiveName;

    public ClientboundSetDisplayObjectivePacket(int pSlot, @Nullable Objective pObjective) {
        this.slot = pSlot;
        this.objectiveName = pObjective == null ? "" : pObjective.getName();
    }

    public ClientboundSetDisplayObjectivePacket(FriendlyByteBuf pBuffer) {
        this.slot = pBuffer.readByte();
        this.objectiveName = pBuffer.readUtf();
    }

    @Override
    public void write(FriendlyByteBuf pBuffer) {
        pBuffer.writeByte(this.slot);
        pBuffer.writeUtf(this.objectiveName);
    }

    @Override
    public void handle(ClientGamePacketListener pHandler) {
        pHandler.handleSetDisplayObjective(this);
    }

    public int getSlot() {
        return this.slot;
    }

    @Nullable
    public String getObjectiveName() {
        return Objects.equals(this.objectiveName, "") ? null : this.objectiveName;
    }
}

