/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;

public class ClientboundSetEquipmentPacket
implements Packet<ClientGamePacketListener> {
    private static final byte CONTINUE_MASK = -128;
    private final int entity;
    private final List<Pair<EquipmentSlot, ItemStack>> slots;

    public ClientboundSetEquipmentPacket(int pEntity, List<Pair<EquipmentSlot, ItemStack>> pSlots) {
        this.entity = pEntity;
        this.slots = pSlots;
    }

    public ClientboundSetEquipmentPacket(FriendlyByteBuf pBuffer) {
        byte i;
        this.entity = pBuffer.readVarInt();
        EquipmentSlot[] aequipmentslot = EquipmentSlot.values();
        this.slots = Lists.newArrayList();
        do {
            i = pBuffer.readByte();
            EquipmentSlot equipmentslot = aequipmentslot[i & 0x7F];
            ItemStack itemstack = pBuffer.readItem();
            this.slots.add((Pair<EquipmentSlot, ItemStack>)Pair.of((Object)((Object)equipmentslot), (Object)itemstack));
        } while ((i & 0xFFFFFF80) != 0);
    }

    @Override
    public void write(FriendlyByteBuf pBuffer) {
        pBuffer.writeVarInt(this.entity);
        int i = this.slots.size();
        int j = 0;
        while (j < i) {
            Pair<EquipmentSlot, ItemStack> pair = this.slots.get(j);
            EquipmentSlot equipmentslot = (EquipmentSlot)((Object)pair.getFirst());
            boolean flag = j != i - 1;
            int k = equipmentslot.ordinal();
            pBuffer.writeByte(flag ? k | 0xFFFFFF80 : k);
            pBuffer.writeItem((ItemStack)pair.getSecond());
            ++j;
        }
    }

    @Override
    public void handle(ClientGamePacketListener pHandler) {
        pHandler.handleSetEquipment(this);
    }

    public int getEntity() {
        return this.entity;
    }

    public List<Pair<EquipmentSlot, ItemStack>> getSlots() {
        return this.slots;
    }
}

