/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;

public class ClientboundSetPassengersPacket
implements Packet<ClientGamePacketListener> {
    private final int vehicle;
    private final int[] passengers;

    public ClientboundSetPassengersPacket(Entity pBuffer) {
        this.vehicle = pBuffer.getId();
        List<Entity> list = pBuffer.getPassengers();
        this.passengers = new int[list.size()];
        int i = 0;
        while (i < list.size()) {
            this.passengers[i] = list.get(i).getId();
            ++i;
        }
    }

    public ClientboundSetPassengersPacket(FriendlyByteBuf pBuffer) {
        this.vehicle = pBuffer.readVarInt();
        this.passengers = pBuffer.readVarIntArray();
    }

    @Override
    public void write(FriendlyByteBuf pBuffer) {
        pBuffer.writeVarInt(this.vehicle);
        pBuffer.a(this.passengers);
    }

    @Override
    public void handle(ClientGamePacketListener pHandler) {
        pHandler.handleSetEntityPassengersPacket(this);
    }

    public int[] getPassengers() {
        return this.passengers;
    }

    public int getVehicle() {
        return this.vehicle;
    }
}

