/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import org.apache.commons.lang3.Validate;

public class ClientboundSoundPacket
implements Packet<ClientGamePacketListener> {
    public static final float LOCATION_ACCURACY = 8.0f;
    private final SoundEvent sound;
    private final SoundSource source;
    private final int x;
    private final int y;
    private final int z;
    private final float volume;
    private final float pitch;

    public ClientboundSoundPacket(SoundEvent pSound, SoundSource pSource, double pX, double p_133445_, double pY, float p_133447_, float pZ) {
        Validate.notNull((Object)pSound, (String)"sound", (Object[])new Object[0]);
        this.sound = pSound;
        this.source = pSource;
        this.x = (int)(pX * 8.0);
        this.y = (int)(p_133445_ * 8.0);
        this.z = (int)(pY * 8.0);
        this.volume = p_133447_;
        this.pitch = pZ;
    }

    public ClientboundSoundPacket(FriendlyByteBuf pBuffer) {
        this.sound = (SoundEvent)Registry.SOUND_EVENT.byId(pBuffer.readVarInt());
        this.source = pBuffer.readEnum(SoundSource.class);
        this.x = pBuffer.readInt();
        this.y = pBuffer.readInt();
        this.z = pBuffer.readInt();
        this.volume = pBuffer.readFloat();
        this.pitch = pBuffer.readFloat();
    }

    @Override
    public void write(FriendlyByteBuf pBuffer) {
        pBuffer.writeVarInt(Registry.SOUND_EVENT.getId(this.sound));
        pBuffer.writeEnum(this.source);
        pBuffer.writeInt(this.x);
        pBuffer.writeInt(this.y);
        pBuffer.writeInt(this.z);
        pBuffer.writeFloat(this.volume);
        pBuffer.writeFloat(this.pitch);
    }

    public SoundEvent getSound() {
        return this.sound;
    }

    public SoundSource getSource() {
        return this.source;
    }

    public double getX() {
        return (float)this.x / 8.0f;
    }

    public double getY() {
        return (float)this.y / 8.0f;
    }

    public double getZ() {
        return (float)this.z / 8.0f;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    @Override
    public void handle(ClientGamePacketListener pHandler) {
        pHandler.handleSoundEvent(this);
    }
}

