/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;

public class ClientboundStopSoundPacket
implements Packet<ClientGamePacketListener> {
    private static final int HAS_SOURCE = 1;
    private static final int HAS_SOUND = 2;
    @Nullable
    private final ResourceLocation name;
    @Nullable
    private final SoundSource source;

    public ClientboundStopSoundPacket(@Nullable ResourceLocation pName, @Nullable SoundSource pSource) {
        this.name = pName;
        this.source = pSource;
    }

    public ClientboundStopSoundPacket(FriendlyByteBuf pBuffer) {
        byte i = pBuffer.readByte();
        this.source = (i & 1) > 0 ? pBuffer.readEnum(SoundSource.class) : null;
        this.name = (i & 2) > 0 ? pBuffer.readResourceLocation() : null;
    }

    @Override
    public void write(FriendlyByteBuf pBuffer) {
        if (this.source != null) {
            if (this.name != null) {
                pBuffer.writeByte(3);
                pBuffer.writeEnum(this.source);
                pBuffer.writeResourceLocation(this.name);
            } else {
                pBuffer.writeByte(1);
                pBuffer.writeEnum(this.source);
            }
        } else if (this.name != null) {
            pBuffer.writeByte(2);
            pBuffer.writeResourceLocation(this.name);
        } else {
            pBuffer.writeByte(0);
        }
    }

    @Nullable
    public ResourceLocation getName() {
        return this.name;
    }

    @Nullable
    public SoundSource getSource() {
        return this.source;
    }

    @Override
    public void handle(ClientGamePacketListener pHandler) {
        pHandler.handleStopSoundEvent(this);
    }
}

