/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;

public class ClientboundUpdateMobEffectPacket
implements Packet<ClientGamePacketListener> {
    private static final int FLAG_AMBIENT = 1;
    private static final int FLAG_VISIBLE = 2;
    private static final int FLAG_SHOW_ICON = 4;
    private final int entityId;
    private final int effectId;
    private final byte effectAmplifier;
    private final int effectDurationTicks;
    private final byte flags;

    public ClientboundUpdateMobEffectPacket(int pEntityId, MobEffectInstance pEffectInstance) {
        this.entityId = pEntityId;
        this.effectId = MobEffect.getId(pEffectInstance.getEffect());
        this.effectAmplifier = (byte)(pEffectInstance.getAmplifier() & 0xFF);
        this.effectDurationTicks = pEffectInstance.getDuration() > Short.MAX_VALUE ? Short.MAX_VALUE : pEffectInstance.getDuration();
        byte b0 = 0;
        if (pEffectInstance.isAmbient()) {
            b0 = (byte)(b0 | 1);
        }
        if (pEffectInstance.isVisible()) {
            b0 = (byte)(b0 | 2);
        }
        if (pEffectInstance.showIcon()) {
            b0 = (byte)(b0 | 4);
        }
        this.flags = b0;
    }

    public ClientboundUpdateMobEffectPacket(FriendlyByteBuf pBuffer) {
        this.entityId = pBuffer.readVarInt();
        this.effectId = pBuffer.readVarInt();
        this.effectAmplifier = pBuffer.readByte();
        this.effectDurationTicks = pBuffer.readVarInt();
        this.flags = pBuffer.readByte();
    }

    @Override
    public void write(FriendlyByteBuf pBuffer) {
        pBuffer.writeVarInt(this.entityId);
        pBuffer.writeVarInt(this.effectId);
        pBuffer.writeByte(this.effectAmplifier);
        pBuffer.writeVarInt(this.effectDurationTicks);
        pBuffer.writeByte(this.flags);
    }

    public boolean isSuperLongDuration() {
        return this.effectDurationTicks == Short.MAX_VALUE;
    }

    @Override
    public void handle(ClientGamePacketListener pHandler) {
        pHandler.handleUpdateMobEffect(this);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public int getEffectId() {
        return this.effectId;
    }

    public byte getEffectAmplifier() {
        return this.effectAmplifier;
    }

    public int getEffectDurationTicks() {
        return this.effectDurationTicks;
    }

    public boolean isEffectVisible() {
        return (this.flags & 2) == 2;
    }

    public boolean isEffectAmbient() {
        return (this.flags & 1) == 1;
    }

    public boolean effectShowsIcon() {
        return (this.flags & 4) == 4;
    }
}

