/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;

public class ClientboundUpdateRecipesPacket
implements Packet<ClientGamePacketListener> {
    private final List<Recipe<?>> recipes;

    public ClientboundUpdateRecipesPacket(Collection<Recipe<?>> pRecipes) {
        this.recipes = Lists.newArrayList(pRecipes);
    }

    public ClientboundUpdateRecipesPacket(FriendlyByteBuf pRecipes) {
        this.recipes = pRecipes.readList(ClientboundUpdateRecipesPacket::fromNetwork);
    }

    @Override
    public void write(FriendlyByteBuf pBuffer) {
        pBuffer.writeCollection(this.recipes, ClientboundUpdateRecipesPacket::toNetwork);
    }

    @Override
    public void handle(ClientGamePacketListener pHandler) {
        pHandler.handleUpdateRecipes(this);
    }

    public List<Recipe<?>> getRecipes() {
        return this.recipes;
    }

    public static Recipe<?> fromNetwork(FriendlyByteBuf p_133648_) {
        ResourceLocation resourcelocation = p_133648_.readResourceLocation();
        ResourceLocation resourcelocation1 = p_133648_.readResourceLocation();
        return Registry.RECIPE_SERIALIZER.getOptional(resourcelocation).orElseThrow(() -> new IllegalArgumentException("Unknown recipe serializer " + resourcelocation)).fromNetwork(resourcelocation1, p_133648_);
    }

    public static <T extends Recipe<?>> void toNetwork(FriendlyByteBuf p_179470_, T p_179471_) {
        p_179470_.writeResourceLocation(Registry.RECIPE_SERIALIZER.getKey(p_179471_.getSerializer()));
        p_179470_.writeResourceLocation(p_179471_.getId());
        p_179471_.getSerializer().toNetwork(p_179470_, p_179471_);
    }
}

