/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.resources.ResourceLocation;

public class ServerboundCustomPayloadPacket
implements Packet<ServerGamePacketListener> {
    private static final int MAX_PAYLOAD_SIZE = Short.MAX_VALUE;
    public static final ResourceLocation BRAND = new ResourceLocation("brand");
    private final ResourceLocation identifier;
    private final FriendlyByteBuf data;

    public ServerboundCustomPayloadPacket(ResourceLocation pIdentifier, FriendlyByteBuf pData) {
        this.identifier = pIdentifier;
        this.data = pData;
    }

    public ServerboundCustomPayloadPacket(FriendlyByteBuf pBuffer) {
        this.identifier = pBuffer.readResourceLocation();
        int i = pBuffer.readableBytes();
        if (i < 0 || i > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Payload may not be larger than 32767 bytes");
        }
        this.data = new FriendlyByteBuf(pBuffer.readBytes(i));
    }

    @Override
    public void write(FriendlyByteBuf pBuffer) {
        pBuffer.writeResourceLocation(this.identifier);
        pBuffer.writeBytes(this.data);
    }

    @Override
    public void handle(ServerGamePacketListener pHandler) {
        pHandler.handleCustomPayload(this);
        this.data.release();
    }

    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public FriendlyByteBuf getData() {
        return this.data;
    }
}

