/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class ServerboundInteractPacket
implements Packet<ServerGamePacketListener> {
    private final int entityId;
    private final Action action;
    private final boolean usingSecondaryAction;
    static final Action ATTACK_ACTION = new Action(){

        @Override
        public ActionType getType() {
            return ActionType.ATTACK;
        }

        @Override
        public void dispatch(Handler p_179624_) {
            p_179624_.onAttack();
        }

        @Override
        public void write(FriendlyByteBuf p_179622_) {
        }
    };

    private ServerboundInteractPacket(int pEntityId, boolean pUsingSecondaryAction, Action pAction) {
        this.entityId = pEntityId;
        this.action = pAction;
        this.usingSecondaryAction = pUsingSecondaryAction;
    }

    public static ServerboundInteractPacket createAttackPacket(Entity pEntity, boolean pUsingSecondaryAction) {
        return new ServerboundInteractPacket(pEntity.getId(), pUsingSecondaryAction, ATTACK_ACTION);
    }

    public static ServerboundInteractPacket createInteractionPacket(Entity pEntity, boolean pUsingSecondaryAction, InteractionHand pHand) {
        return new ServerboundInteractPacket(pEntity.getId(), pUsingSecondaryAction, new InteractionAction(pHand));
    }

    public static ServerboundInteractPacket createInteractionPacket(Entity pEntity, boolean pUsingSecondaryAction, InteractionHand pHand, Vec3 pIneractionLocation) {
        return new ServerboundInteractPacket(pEntity.getId(), pUsingSecondaryAction, new InteractionAtLocationAction(pHand, pIneractionLocation));
    }

    public ServerboundInteractPacket(FriendlyByteBuf pBuffer) {
        this.entityId = pBuffer.readVarInt();
        ActionType serverboundinteractpacket$actiontype = pBuffer.readEnum(ActionType.class);
        this.action = serverboundinteractpacket$actiontype.reader.apply(pBuffer);
        this.usingSecondaryAction = pBuffer.readBoolean();
    }

    @Override
    public void write(FriendlyByteBuf pBuffer) {
        pBuffer.writeVarInt(this.entityId);
        pBuffer.writeEnum(this.action.getType());
        this.action.write(pBuffer);
        pBuffer.writeBoolean(this.usingSecondaryAction);
    }

    @Override
    public void handle(ServerGamePacketListener pHandler) {
        pHandler.handleInteract(this);
    }

    @Nullable
    public Entity getTarget(ServerLevel pLevel) {
        return pLevel.getEntityOrPart(this.entityId);
    }

    public boolean isUsingSecondaryAction() {
        return this.usingSecondaryAction;
    }

    public void dispatch(Handler pHandler) {
        this.action.dispatch(pHandler);
    }

    static interface Action {
        public ActionType getType();

        public void dispatch(Handler var1);

        public void write(FriendlyByteBuf var1);
    }

    static enum ActionType {
        INTERACT(friendlyByteBuf -> new InteractionAction((FriendlyByteBuf)((Object)friendlyByteBuf))),
        ATTACK(p_179639_ -> ATTACK_ACTION),
        INTERACT_AT(friendlyByteBuf -> new InteractionAtLocationAction((FriendlyByteBuf)((Object)friendlyByteBuf)));

        final Function<FriendlyByteBuf, Action> reader;

        private ActionType(Function<FriendlyByteBuf, Action> p_179636_) {
            this.reader = p_179636_;
        }
    }

    public static interface Handler {
        public void onInteraction(InteractionHand var1);

        public void onInteraction(InteractionHand var1, Vec3 var2);

        public void onAttack();
    }

    static class InteractionAction
    implements Action {
        private final InteractionHand hand;

        InteractionAction(InteractionHand pBuffer) {
            this.hand = pBuffer;
        }

        private InteractionAction(FriendlyByteBuf pBuffer) {
            this.hand = pBuffer.readEnum(InteractionHand.class);
        }

        @Override
        public ActionType getType() {
            return ActionType.INTERACT;
        }

        @Override
        public void dispatch(Handler pHandler) {
            pHandler.onInteraction(this.hand);
        }

        @Override
        public void write(FriendlyByteBuf pBuffer) {
            pBuffer.writeEnum(this.hand);
        }
    }

    static class InteractionAtLocationAction
    implements Action {
        private final InteractionHand hand;
        private final Vec3 location;

        InteractionAtLocationAction(InteractionHand pHand, Vec3 pLocation) {
            this.hand = pHand;
            this.location = pLocation;
        }

        private InteractionAtLocationAction(FriendlyByteBuf pBuffer) {
            this.location = new Vec3(pBuffer.readFloat(), pBuffer.readFloat(), pBuffer.readFloat());
            this.hand = pBuffer.readEnum(InteractionHand.class);
        }

        @Override
        public ActionType getType() {
            return ActionType.INTERACT_AT;
        }

        @Override
        public void dispatch(Handler pHandler) {
            pHandler.onInteraction(this.hand, this.location);
        }

        @Override
        public void write(FriendlyByteBuf pBuffer) {
            pBuffer.writeFloat((float)this.location.x);
            pBuffer.writeFloat((float)this.location.y);
            pBuffer.writeFloat((float)this.location.z);
            pBuffer.writeEnum(this.hand);
        }
    }
}

