/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;

public class ServerboundPlayerActionPacket
implements Packet<ServerGamePacketListener> {
    private final BlockPos pos;
    private final Direction direction;
    private final Action action;

    public ServerboundPlayerActionPacket(Action pAction, BlockPos pPos, Direction pDirection) {
        this.action = pAction;
        this.pos = pPos.immutable();
        this.direction = pDirection;
    }

    public ServerboundPlayerActionPacket(FriendlyByteBuf pBuffer) {
        this.action = pBuffer.readEnum(Action.class);
        this.pos = pBuffer.readBlockPos();
        this.direction = Direction.from3DDataValue(pBuffer.readUnsignedByte());
    }

    @Override
    public void write(FriendlyByteBuf pBuffer) {
        pBuffer.writeEnum(this.action);
        pBuffer.writeBlockPos(this.pos);
        pBuffer.writeByte(this.direction.get3DDataValue());
    }

    @Override
    public void handle(ServerGamePacketListener pHandler) {
        pHandler.handlePlayerAction(this);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public Action getAction() {
        return this.action;
    }

    public static enum Action {
        START_DESTROY_BLOCK,
        ABORT_DESTROY_BLOCK,
        STOP_DESTROY_BLOCK,
        DROP_ALL_ITEMS,
        DROP_ITEM,
        RELEASE_USE_ITEM,
        SWAP_ITEM_WITH_OFFHAND;

    }
}

